/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.extension.diagrameditor;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.papyrus.infra.core.editorsfactory.IEditorIconFactoryExtended;
import org.eclipse.papyrus.infra.core.extension.diagrameditor.EditorDescriptor;
import org.eclipse.papyrus.infra.core.extension.diagrameditor.IPluggableEditorFactory;
import org.eclipse.swt.graphics.Image;

public class EditorIconFactory
implements IEditorIconFactoryExtended {
    private IPluggableEditorFactory editorFactory;
    protected EditorDescriptor editorDescriptor;
    protected Image cachedImage;

    public EditorIconFactory(EditorDescriptor editorDescriptor) {
        this.editorDescriptor = editorDescriptor;
    }

    @Override
    public Image getEditorIcon(Object pageIdentifier) {
        if (this.cachedImage == null) {
            this.cachedImage = this.createEditorIcon(pageIdentifier);
        }
        return this.cachedImage;
    }

    @Override
    public Image createEditorIcon(Object pageIdentifier) {
        ImageDescriptor imageDescriptor = this.editorDescriptor.getIcon();
        if (imageDescriptor == null) {
            return null;
        }
        Image image = imageDescriptor.createImage();
        return image;
    }

    @Override
    public boolean isPageModelFactoryFor(Object pageIdentifier) {
        return this.getEditorFactory().isPageModelFactoryFor(pageIdentifier);
    }

    protected IPluggableEditorFactory getEditorFactory() {
        if (this.editorFactory == null) {
            this.editorFactory = this.createEditorFactory();
        }
        return this.editorFactory;
    }

    private IPluggableEditorFactory createEditorFactory() {
        try {
            this.editorFactory = this.editorDescriptor.getEditorFactoryClass().newInstance();
            return this.editorFactory;
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getURLMainIcon(Object pageIdentifier) {
        return this.editorDescriptor.getIconURL();
    }

    @Override
    public void dispose() {
        if (this.cachedImage != null) {
            this.cachedImage.dispose();
            this.cachedImage = null;
        }
    }
}

