/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.common.label.generators;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.ETypeParameter;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.common.label.AbstractLabelGenerator;
import org.eclipse.ocl.examples.common.label.ILabelGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EGenericTypeLabelGenerator
extends AbstractLabelGenerator<EGenericType> {
    public static void initialize(@NonNull ILabelGenerator.Registry registry) {
        registry.install(EGenericType.class, new EGenericTypeLabelGenerator());
    }

    public EGenericTypeLabelGenerator() {
        super(EGenericType.class);
    }

    @Override
    public void buildLabelFor(@NonNull ILabelGenerator.Builder labelBuilder, @NonNull EGenericType object) {
        EClassifier eClassifier = object.getEClassifier();
        if (eClassifier != null) {
            labelBuilder.appendObject(eClassifier);
        } else {
            ETypeParameter eTypeParameter = object.getETypeParameter();
            labelBuilder.appendObject(eTypeParameter);
        }
        EList eTypeArguments = object.getETypeArguments();
        int size = eTypeArguments.size();
        if (size > 0) {
            labelBuilder.appendString("<");
            int i = 0;
            while (i < size) {
                if (i > 0) {
                    labelBuilder.appendString(",");
                }
                labelBuilder.appendObject(eTypeArguments.get(0));
                ++i;
            }
            labelBuilder.appendString(">");
        }
    }
}

