/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.markerlistener.providers;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.papyrus.infra.core.Activator;
import org.eclipse.papyrus.infra.services.markerlistener.IPapyrusMarker;
import org.eclipse.papyrus.infra.services.markerlistener.PapyrusMarkerAdapter;
import org.eclipse.papyrus.infra.services.markerlistener.providers.AbstractMarkerProvider;
import org.eclipse.papyrus.infra.services.markerlistener.util.MarkerListenerUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkspaceMarkerProvider
extends AbstractMarkerProvider {
    @Override
    public boolean canProvideMarkersFor(Resource resource) {
        return MarkerListenerUtils.getFile(resource) != null;
    }

    @Override
    public Collection<? extends IPapyrusMarker> getMarkers(Resource resource, String type, boolean includeSubtypes) throws CoreException {
        IFile file = MarkerListenerUtils.getFile(resource);
        if (file != null) {
            IMarker[] markers = file.findMarkers(type, true, 0);
            return PapyrusMarkerAdapter.wrap(resource, Arrays.asList(markers));
        }
        return Collections.emptyList();
    }

    public void createMarkers(Resource resource, Diagnostic diagnostic) {
    }

    @Override
    protected void doCreateMarker(Resource resource, Diagnostic diagnostic) throws CoreException {
        if (MarkerListenerUtils.eclipseResourcesUtil != null) {
            MarkerListenerUtils.eclipseResourcesUtil.createMarkers(resource, diagnostic);
        }
    }

    @Override
    @Deprecated
    public void deleteMarkers(Resource resource, IProgressMonitor monitor) {
        try {
            this.deleteMarkers(resource, monitor, null, true);
        }
        catch (CoreException e) {
            Activator.log.error((Throwable)e);
        }
    }

    @Override
    public void deleteMarkers(Resource resource, IProgressMonitor monitor, String markerType, boolean includeSubtypes) throws CoreException {
        if (MarkerListenerUtils.eclipseResourcesUtil != null) {
            SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)-1);
            MarkerListenerUtils.eclipseResourcesUtil.deleteMarkers((Object)resource);
            sub.done();
        }
    }
}

