/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ext.draw2d.figure;

import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FreeformViewport;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ScalableFigure;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Translatable;

public final class FigureUtilities {
    private FigureUtilities() {
    }

    public static void translateToAbsoluteByIgnoringScrollbar(IFigure figure, Point relativeLocation) {
        PrecisionPoint pPoint = new PrecisionPoint(relativeLocation);
        figure.translateToAbsolute((Translatable)pPoint);
        FigureUtilities.removeParentScrollbarAndZoomFactor(figure, pPoint);
        relativeLocation.x = pPoint.x;
        relativeLocation.y = pPoint.y;
    }

    public static void translateToRelativeByIgnoringScrollbar(IFigure figure, Point absoluteLocation) {
        PrecisionPoint pPoint = new PrecisionPoint(absoluteLocation);
        FigureUtilities.addParentScrollbarAndZoomFactor(figure, pPoint);
        figure.translateToRelative((Translatable)pPoint);
        absoluteLocation.x = pPoint.x;
        absoluteLocation.y = pPoint.y;
    }

    private static void addParentScrollbarAndZoomFactor(IFigure figure, PrecisionPoint location) {
        if (figure instanceof Viewport) {
            location.performTranslate(-((Viewport)figure).getHorizontalRangeModel().getValue(), -((Viewport)figure).getVerticalRangeModel().getValue());
        }
        if (figure instanceof ScalableFigure) {
            location.performScale(((ScalableFigure)figure).getScale());
        }
        if (figure.getParent() != null) {
            FigureUtilities.addParentScrollbarAndZoomFactor(figure.getParent(), location);
        }
    }

    private static void removeParentScrollbarAndZoomFactor(IFigure figure, PrecisionPoint location) {
        if (figure.getParent() != null) {
            FigureUtilities.removeParentScrollbarAndZoomFactor(figure.getParent(), location);
        }
        if (figure instanceof Viewport) {
            location.performTranslate(((Viewport)figure).getHorizontalRangeModel().getValue(), ((Viewport)figure).getVerticalRangeModel().getValue());
        }
        if (figure instanceof ScalableFigure) {
            location.performScale(1.0 / ((ScalableFigure)figure).getScale());
        }
    }

    public static void precisionTranslateToRelative(Figure figure, Point point) {
        PrecisionPoint pPoint = new PrecisionPoint(point);
        figure.translateToRelative((Translatable)pPoint);
        point.x = pPoint.x;
        point.y = pPoint.y;
    }

    public static FreeformViewport getFreeformViewport(IFigure figure) {
        IFigure current = figure;
        while (!(current instanceof FreeformViewport) && current != null) {
            current = current.getParent();
        }
        return (FreeformViewport)current;
    }
}

