/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.MARTE.MARTE_DesignModel.GCM;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ClientServerKind implements Enumerator
{
    REQUIRED(0, "required", "required"),
    PROVIDED(1, "provided", "provided"),
    PROREQ(2, "proreq", "proreq");

    public static final int REQUIRED_VALUE = 0;
    public static final int PROVIDED_VALUE = 1;
    public static final int PROREQ_VALUE = 2;
    private static final ClientServerKind[] VALUES_ARRAY;
    public static final List<ClientServerKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ClientServerKind[]{REQUIRED, PROVIDED, PROREQ};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ClientServerKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ClientServerKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ClientServerKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ClientServerKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ClientServerKind get(int value) {
        switch (value) {
            case 0: {
                return REQUIRED;
            }
            case 1: {
                return PROVIDED;
            }
            case 2: {
                return PROREQ;
            }
        }
        return null;
    }

    private ClientServerKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

