/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.eclipse.project.editors.file;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.papyrus.eclipse.project.editors.Activator;
import org.eclipse.papyrus.eclipse.project.editors.interfaces.IManifestEditor;
import org.eclipse.papyrus.eclipse.project.editors.project.ProjectEditor;
import org.eclipse.pde.internal.ui.editor.actions.FormatOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManifestEditor
extends ProjectEditor
implements IManifestEditor {
    private IFile manifestFile;
    private Manifest manifest;

    public ManifestEditor(IProject project) throws IOException, CoreException {
        super(project);
    }

    public boolean initOk() {
        return this.manifest != null && this.manifestFile != null;
    }

    @Override
    public void addDependency(String dependency) {
        this.addDependency(dependency, null);
    }

    @Override
    public void init() {
        super.init();
        if (this.manifest != null && this.manifestFile != null) {
            return;
        }
        if (this.manifestFile == null) {
            this.manifestFile = this.getManifestFile();
        }
        if (this.manifestFile != null) {
            try {
                this.manifest = new Manifest(this.manifestFile.getContents());
            }
            catch (IOException e) {
                Activator.log.error((Throwable)e);
                throw new RuntimeException(e);
            }
            catch (CoreException e) {
                Activator.log.error((Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void addDependency(String dependency, String version) {
        Attributes.Name rqBundle = new Attributes.Name("Require-Bundle");
        String requireBundle = this.manifest.getMainAttributes().getValue(rqBundle);
        if (requireBundle == null) {
            requireBundle = dependency;
            if (version != null) {
                requireBundle = String.valueOf(requireBundle) + ";" + version;
            }
        } else if (!requireBundle.contains(dependency)) {
            requireBundle = String.valueOf(requireBundle) + "," + dependency;
            if (version != null) {
                requireBundle = String.valueOf(requireBundle) + ";" + version;
            }
        }
        this.manifest.getMainAttributes().put(rqBundle, requireBundle);
    }

    @Override
    public void setDependenciesVersion(String dependencyPattern, String newVersion) {
        Attributes.Name rqBundle = new Attributes.Name("Require-Bundle");
        String requireBundles = this.manifest.getMainAttributes().getValue(rqBundle);
        String[] bundles = requireBundles.split(",");
        String newRequiredBundles = "";
        int ii = 0;
        while (ii < bundles.length) {
            String currentDependency = bundles[ii];
            String[] dependencyValue = currentDependency.split(";");
            if (dependencyValue[0].contains(dependencyPattern)) {
                String newBundleVersion = "bundle-version=\"" + newVersion + '\"';
                newRequiredBundles = String.valueOf(newRequiredBundles) + dependencyValue[0] + ";" + newBundleVersion;
                int i = 1;
                while (i < dependencyValue.length) {
                    String declaration = dependencyValue[i];
                    if (!declaration.contains("bundle-version=")) {
                        newRequiredBundles = String.valueOf(newRequiredBundles) + ";" + dependencyValue[i];
                    }
                    ++i;
                }
            } else {
                newRequiredBundles = String.valueOf(newRequiredBundles) + currentDependency;
            }
            if (ii < bundles.length - 1) {
                newRequiredBundles = String.valueOf(newRequiredBundles) + ",";
            }
            ++ii;
        }
        this.setValue("Require-Bundle", newRequiredBundles);
    }

    @Override
    public void setValue(String key, String value) {
        this.setValue(key, "", value);
    }

    @Override
    public void setValue(String key, String name, String value) {
        this.manifest.getMainAttributes().putValue(key, value);
    }

    @Override
    public void removeValue(String key, String value) {
    }

    @Override
    public void removeValue(String key) {
        this.manifest.getAttributes(key).remove(key);
    }

    private IFile getManifestFile() {
        IFile manifest = this.getProject().getFile("META-INF/MANIFEST.MF");
        if (manifest.exists()) {
            return manifest;
        }
        return null;
    }

    @Override
    public boolean exists() {
        return super.exists() && this.getManifestFile() != null && this.getSymbolicBundleName() != null && this.getBundleVersion() != null;
    }

    @Override
    public void save() {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            this.manifest.write(os);
            final StringReader reader = new StringReader(os.toString("UTF-8"));
            this.manifestFile.setContents(new InputStream(){

                public int read() throws IOException {
                    return reader.read();
                }
            }, true, true, null);
            try {
                FormatOperation.format((IFile)this.manifestFile, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (IOException ex) {
            Activator.log.error((Throwable)ex);
        }
        catch (CoreException ex) {
            Activator.log.error((Throwable)ex);
        }
    }

    @Override
    public Set<String> getMissingFiles() {
        Set<String> files = super.getMissingFiles();
        IFile classpath = this.getProject().getFile("META-INF/MANIFEST.MF");
        if (!classpath.exists()) {
            files.add("META-INF/MANIFEST.MF");
        }
        return files;
    }

    @Override
    public void createFiles(Set<String> files) {
        if (files.contains("META-INF/MANIFEST.MF")) {
            this.manifestFile = this.getProject().getFile("META-INF/MANIFEST.MF");
            if (!this.manifestFile.exists()) {
                try {
                    IContainer parent;
                    String input = "Manifest-Version: 1.0\n";
                    if (!this.manifestFile.getParent().exists() && (parent = this.manifestFile.getParent()) instanceof IFolder && !parent.exists()) {
                        ((IFolder)parent).create(true, false, null);
                    }
                    this.manifestFile.create(this.getInputStream("Manifest-Version: 1.0\n"), true, null);
                    this.manifestFile = this.getProject().getFile("META-INF/MANIFEST.MF");
                    this.manifest = new Manifest(this.manifestFile.getContents());
                }
                catch (CoreException ex) {
                    Activator.log.error((Throwable)ex);
                }
                catch (IOException e) {
                    Activator.log.error((Throwable)e);
                }
            }
        }
        if (this.getSymbolicBundleName() == null) {
            this.setSymbolicBundleName(this.getProject().getName());
        }
        if (this.getBundleVersion() == null) {
            this.setBundleVersion("0.0.1");
        }
    }

    @Override
    public void setSymbolicBundleName(String newName) {
        if (newName == null) {
            newName = "noName";
        }
        Attributes.Name symbolicName = new Attributes.Name("Bundle-SymbolicName");
        this.manifest.getMainAttributes().put(symbolicName, newName);
    }

    @Override
    public String getSymbolicBundleName() {
        if (this.manifest != null) {
            Attributes.Name symbolicName = new Attributes.Name("Bundle-SymbolicName");
            String name = this.manifest.getMainAttributes().getValue(symbolicName);
            int semiColon = name.indexOf(";");
            if (semiColon != -1) {
                return name.substring(0, semiColon);
            }
            return name;
        }
        return null;
    }

    @Override
    public String getBundleVersion() {
        if (this.manifest != null) {
            Attributes.Name symbolicName = new Attributes.Name("bundle-version");
            String version = this.manifest.getMainAttributes().getValue(symbolicName);
            return version;
        }
        return null;
    }

    @Override
    public void setBundleVersion(String version) {
        if (this.manifest != null) {
            Attributes.Name bundleVersion = new Attributes.Name("bundle-version");
            if (version == null) {
                this.manifest.getMainAttributes().remove(bundleVersion);
            } else {
                this.manifest.getMainAttributes().put(bundleVersion, version);
            }
        }
    }

    @Override
    public String getBundleVendor() {
        if (this.manifest != null) {
            Attributes.Name bundleVendor = new Attributes.Name("Bundle-Vendor");
            return this.manifest.getMainAttributes().getValue(bundleVendor);
        }
        return null;
    }

    @Override
    public void setBundleVendor(String vendor) {
        if (this.manifest != null) {
            Attributes.Name bundleVendor = new Attributes.Name("Bundle-Vendor");
            if (vendor == null) {
                this.manifest.getMainAttributes().remove(bundleVendor);
            } else {
                this.manifest.getMainAttributes().put(bundleVendor, vendor);
            }
        }
    }

    @Override
    public String getValue(String key) {
        if (this.manifest != null) {
            Attributes attributes;
            String value = this.manifest.getMainAttributes().getValue(key);
            if (value == null && (attributes = this.manifest.getAttributes(key)) != null) {
                value = attributes.getValue(key);
            }
            return value;
        }
        return null;
    }

    @Override
    public String getBundleName() {
        if (this.manifest != null) {
            Attributes.Name bundleName = new Attributes.Name("Bundle-Name");
            String name = this.manifest.getMainAttributes().getValue(bundleName);
            return name;
        }
        return null;
    }

    @Override
    public void setBundleName(String newName) {
        if (newName == null) {
            newName = "noName";
        }
        Attributes.Name bundleNameName = new Attributes.Name("Bundle-SymbolicName");
        this.manifest.getMainAttributes().put(bundleNameName, newName);
    }

    @Override
    public String getBundleLocalization() {
        if (this.manifest != null) {
            Attributes.Name bundleLocalization = new Attributes.Name("Bundle-Localization");
            String name = this.manifest.getMainAttributes().getValue(bundleLocalization);
            return name;
        }
        return null;
    }

    @Override
    public void setSingleton(boolean singleton) {
        String value = this.manifest.getMainAttributes().getValue("bundle-symbolicName");
        String[] directives = value.split(";");
        if (directives.length == 0) {
            return;
        }
        value = directives[0];
        boolean isDefined = false;
        int i = 1;
        while (i < directives.length) {
            String directive = directives[i];
            if (directive.startsWith("singleton:=")) {
                directive = "singleton:=" + singleton;
                isDefined = true;
            }
            value = String.valueOf(value) + ";" + directive;
            ++i;
        }
        if (!isDefined) {
            value = String.valueOf(value) + ";singleton:=" + singleton;
        }
        this.manifest.getMainAttributes().putValue("bundle-symbolicName", value);
    }
}

