/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.xml.discoverer.actions;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.facet.util.emf.core.IBrowserRegistry;
import org.eclipse.gmt.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.gmt.modisco.infra.discoverymanager.Discoverer;
import org.eclipse.gmt.modisco.infra.discoverymanager.DiscoveryParameter;
import org.eclipse.gmt.modisco.infra.discoverymanager.DiscoveryParameterDirectionKind;
import org.eclipse.gmt.modisco.infra.discoverymanager.DiscoveryParameterImpl;
import org.eclipse.gmt.modisco.xml.discoverer.XmlActivator;
import org.eclipse.modisco.infra.discovery.ui.Activator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class XMLModelDiscoverer
implements Discoverer {
    private static List<DiscoveryParameter> parametersKeys = null;
    private Resource resourceResult = null;
    private final org.eclipse.modisco.xml.discoverer.XMLModelDiscoverer delegateDiscoverer = new org.eclipse.modisco.xml.discoverer.XMLModelDiscoverer();
    @Deprecated
    public static final DiscoveryParameter PARAMETER_SILENT_MODE = new DiscoveryParameterImpl("OPTION_SILENT_MODE", DiscoveryParameterDirectionKind.in, Boolean.class, false);
    public static final DiscoveryParameter PARAMETER_IGNORE_WHITESPACES = new DiscoveryParameterImpl("OPTION_IGNORE_WHITESPACE", DiscoveryParameterDirectionKind.in, Boolean.class, false);
    public static final DiscoveryParameter PARAMETER_LIGHTWEIGHT_MODEL = new DiscoveryParameterImpl("OPTION_LIGHTWEIGHT_MODEL", DiscoveryParameterDirectionKind.in, Boolean.class, false);
    public static final DiscoveryParameter PARAMETER_SERIALIZE_XMI = new DiscoveryParameterImpl("OPTION_SERIALIZE_XMI", DiscoveryParameterDirectionKind.in, Boolean.class, false);
    public static final DiscoveryParameter PARAMETER_TARGET_RESOURCE = new DiscoveryParameterImpl("TARGET_RESOURCE", DiscoveryParameterDirectionKind.out, Resource.class, false);

    protected org.eclipse.modisco.xml.discoverer.XMLModelDiscoverer getDelegateDiscoverer() {
        return this.delegateDiscoverer;
    }

    public final boolean isApplicableTo(Object source) {
        if (source instanceof IFile) {
            IFile file = (IFile)source;
            return this.delegateDiscoverer.isApplicableTo(file);
        }
        return source instanceof File;
    }

    public final Resource discoverElement(Object source, URI target) {
        HashMap<DiscoveryParameter, Object> parameters = new HashMap<DiscoveryParameter, Object>();
        parameters.put(PARAMETER_SILENT_MODE, false);
        parameters.put(PARAMETER_IGNORE_WHITESPACES, false);
        parameters.put(PARAMETER_LIGHTWEIGHT_MODEL, false);
        parameters.put(PARAMETER_SERIALIZE_XMI, false);
        this.discoverElement(source, parameters);
        return (Resource)parameters.get(PARAMETER_TARGET_RESOURCE);
    }

    public final void discoverElement(final Object source, final Map<DiscoveryParameter, Object> parameters) {
        Job job = new Job("discovering XML model"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    boolean serializeXMI = false;
                    if (parameters != null && parameters.get(PARAMETER_SERIALIZE_XMI) != null) {
                        serializeXMI = (Boolean)parameters.get(PARAMETER_SERIALIZE_XMI);
                    }
                    boolean ignoreWhitespace = false;
                    if (parameters != null && parameters.get(PARAMETER_IGNORE_WHITESPACES) != null) {
                        ignoreWhitespace = (Boolean)parameters.get(PARAMETER_IGNORE_WHITESPACES);
                    }
                    boolean lightweightModel = false;
                    if (parameters != null && parameters.get(PARAMETER_LIGHTWEIGHT_MODEL) != null) {
                        lightweightModel = (Boolean)parameters.get(PARAMETER_LIGHTWEIGHT_MODEL);
                    }
                    boolean silent = false;
                    if (parameters != null && parameters.get(PARAMETER_SILENT_MODE) != null) {
                        silent = (Boolean)parameters.get(PARAMETER_SILENT_MODE);
                    }
                    XMLModelDiscoverer.this.setResourceResult(null);
                    XMLModelDiscoverer.this.getDelegateDiscoverer().setIgnoreWhitespace(ignoreWhitespace);
                    XMLModelDiscoverer.this.getDelegateDiscoverer().setLightweightModel(lightweightModel);
                    XMLModelDiscoverer.this.getDelegateDiscoverer().setSerializeTarget(serializeXMI);
                    if (source instanceof IFile) {
                        IFile iFile = (IFile)source;
                        XMLModelDiscoverer.this.getDelegateDiscoverer().setTargetURI(URI.createPlatformResourceURI((String)iFile.getFullPath().addFileExtension("xmi").toOSString(), (boolean)true));
                        XMLModelDiscoverer.this.getDelegateDiscoverer().discoverElement((Object)iFile, monitor);
                    } else if (source instanceof File) {
                        File file = (File)source;
                        XMLModelDiscoverer.this.getDelegateDiscoverer().setTargetURI(URI.createFileURI((String)file.getAbsolutePath().concat(".xmi")));
                        XMLModelDiscoverer.this.getDelegateDiscoverer().discoverElement(file, monitor);
                    } else {
                        throw new IllegalArgumentException("source is not a File or IFile");
                    }
                    XMLModelDiscoverer.this.setResourceResult(XMLModelDiscoverer.this.getDelegateDiscoverer().getTargetModel());
                    if (!silent && XMLModelDiscoverer.this.getResourceResult() != null) {
                        IBrowserRegistry.INSTANCE.browseResource(XMLModelDiscoverer.this.getResourceResult());
                    }
                }
                catch (Exception e) {
                    Status result = new Status(4, "org.eclipse.gmt.modisco.xml.discoverer", "An error occured during model discovery from " + source.toString(), (Throwable)e);
                    XmlActivator.getDefault().getLog().log((IStatus)result);
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
        try {
            job.join();
        }
        catch (InterruptedException e) {
            MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
        }
        if (parameters != null) {
            parameters.put(PARAMETER_TARGET_RESOURCE, this.getResourceResult());
        }
    }

    public final List<DiscoveryParameter> getDiscovererParameters() {
        if (parametersKeys == null) {
            parametersKeys = new ArrayList<DiscoveryParameter>();
            parametersKeys.add(PARAMETER_SILENT_MODE);
            parametersKeys.add(PARAMETER_TARGET_RESOURCE);
            parametersKeys.add(PARAMETER_IGNORE_WHITESPACES);
            parametersKeys.add(PARAMETER_LIGHTWEIGHT_MODEL);
            parametersKeys.add(PARAMETER_SERIALIZE_XMI);
        }
        return parametersKeys;
    }

    public void setResourceResult(Resource aResourceResult) {
        this.resourceResult = aResourceResult;
    }

    public Resource getResourceResult() {
        return this.resourceResult;
    }
}

