/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.console.actions;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ocl.examples.pivot.resource.ASResource;
import org.eclipse.ocl.examples.xtext.base.utilities.BaseCSResource;
import org.eclipse.ocl.examples.xtext.console.OCLConsolePage;
import org.eclipse.ocl.examples.xtext.console.XtextConsolePlugin;
import org.eclipse.ocl.examples.xtext.console.messages.ConsoleMessages;
import org.eclipse.ocl.examples.xtext.essentialocl.ui.model.BaseDocument;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.osgi.framework.Bundle;

public class SaveExpressionAction
extends Action {
    static Map<String, Object> saveOptions = new HashMap<String, Object>();
    protected final OCLConsolePage consolePage;
    private final String tip;

    static {
        saveOptions.put("SAVE_TYPE_INFORMATION", true);
    }

    public SaveExpressionAction(OCLConsolePage consolePage) {
        super(ConsoleMessages.SaveAction_Label, ImageDescriptor.createFromURL((URL)FileLocator.find((Bundle)XtextConsolePlugin.getInstance().getBundle(), (IPath)new Path("$nl$/icons/elcl16/save.gif"), null)));
        this.consolePage = consolePage;
        this.tip = ConsoleMessages.SaveAction_Tip;
    }

    public String getToolTipText() {
        return this.tip;
    }

    public void run() {
        Shell shell = this.consolePage.getControl().getShell();
        if (this.consolePage.getLastOCLExpression() != null) {
            FileDialog dlg = new FileDialog(shell, 8192);
            dlg.setFilterExtensions(new String[]{"*.xmi"});
            dlg.setText(ConsoleMessages.SaveAction_Title);
            final String file = dlg.open();
            if (file != null) {
                try {
                    BaseDocument editorDocument = this.consolePage.getEditorDocument();
                    editorDocument.modify((IUnitOfWork)new IUnitOfWork<Object, XtextResource>(){

                        public Object exec(@Nullable XtextResource resource) throws Exception {
                            if (resource instanceof BaseCSResource) {
                                ASResource asResource = ((BaseCSResource)resource).getASResource(null);
                                asResource.setURI(URI.createFileURI((String)file));
                                asResource.save(saveOptions);
                            }
                            return null;
                        }
                    });
                }
                catch (Exception e) {
                    MessageDialog.openError((Shell)shell, (String)ConsoleMessages.SaveActionError_Title, (String)e.getLocalizedMessage());
                }
            }
        } else {
            MessageDialog.openWarning((Shell)shell, (String)ConsoleMessages.SaveActionWarning_Title, (String)ConsoleMessages.SaveActionWarning_NoExpression);
        }
    }
}

