/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.fla.flamm.util;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.polarsys.chess.fla.flamm.Component;
import org.polarsys.chess.fla.flamm.FlammPackage;

public class FlammReader {
    private URI uri;
    private Resource resource = null;
    private Component rootComponent = null;

    public FlammReader(URI uri) {
        this.uri = uri;
    }

    private boolean readModel() {
        try {
            FlammPackage.eINSTANCE.eClass();
            Resource.Factory.Registry registry = Resource.Factory.Registry.INSTANCE;
            Map extensionMap = registry.getExtensionToFactoryMap();
            extensionMap.put("flamm", new XMIResourceFactoryImpl());
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            this.resource = resourceSet.getResource(this.uri, true);
            this.rootComponent = (Component)this.resource.getContents().get(0);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public Resource getResource() {
        if (this.resource == null) {
            this.readModel();
        }
        return this.resource;
    }

    public Component getRootComponent() {
        if (this.rootComponent == null) {
            this.readModel();
        }
        return this.rootComponent;
    }

    public boolean saveModel() {
        try {
            this.resource.save(Collections.EMPTY_MAP);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }
}

