/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.fla.flamm;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.polarsys.chess.fla.flamm.Component;
import org.polarsys.chess.fla.flamm.Connection;
import org.polarsys.chess.fla.flamm.Failure;
import org.polarsys.chess.fla.flamm.FlammPackage;
import org.polarsys.chess.fla.flamm.Port;
import org.polarsys.chess.fla.flamm.analysis.FlaSystem;

public class CompositeComponent
extends Component {
    protected EList<Component> components;
    protected EList<Connection> connections;

    @Override
    protected EClass eStaticClass() {
        return FlammPackage.Literals.COMPOSITE_COMPONENT;
    }

    public List<Component> getComponents() {
        if (this.components == null) {
            this.components = new EObjectContainmentWithInverseEList(Component.class, (InternalEObject)this, 5, 4);
        }
        return this.components;
    }

    public List<Connection> getConnections() {
        if (this.connections == null) {
            this.connections = new EObjectContainmentEList(Connection.class, (InternalEObject)this, 6);
        }
        return this.connections;
    }

    @Override
    public void propagateFailures() {
        for (Port port : this.getInputPorts()) {
            if (!port.hasNewFailures()) continue;
            this.propagateInputFailures(port);
        }
        for (Port port : this.getOutputPorts()) {
            if (!port.hasNewFailures()) continue;
            this.propagateOutputFailures(port);
        }
    }

    private void propagateInputFailures(Port port) {
        for (Port connectedPort : port.getConnectedPorts()) {
            if (!this.getComponents().contains(connectedPort.getOwner()) && !this.getOutputPorts().contains((Object)connectedPort)) continue;
            this.propagateNewFailures(port, connectedPort);
        }
        port.clearNewFailures();
    }

    protected void propagateOutputFailures(Port port) {
        for (Port connectedPort : port.getConnectedPorts()) {
            if (this.getComponents().contains(connectedPort.getOwner())) continue;
            this.propagateNewFailures(port, connectedPort);
        }
        port.clearNewFailures();
    }

    public void propagateNewFailures(Port source, Port target) {
        for (Failure failure : source.getNewFailures()) {
            if (!target.addFailure(failure, failure)) continue;
            FlaSystem.addUpdatedComponent(target.getOwner());
        }
    }

    @Override
    public void initialize(boolean initNoFailure) {
        super.initialize(initNoFailure);
        for (Component subComponent : this.getComponents()) {
            subComponent.initialize(initNoFailure);
        }
    }

    @Override
    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 5: {
                return ((InternalEList)this.getComponents()).basicAdd((Object)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 5: {
                return ((InternalEList)this.getComponents()).basicRemove((Object)otherEnd, msgs);
            }
            case 6: {
                return ((InternalEList)this.getConnections()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 5: {
                return this.getComponents();
            }
            case 6: {
                return this.getConnections();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 5: {
                this.getComponents().clear();
                this.getComponents().addAll((Collection)newValue);
                return;
            }
            case 6: {
                this.getConnections().clear();
                this.getConnections().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 5: {
                this.getComponents().clear();
                return;
            }
            case 6: {
                this.getConnections().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 5: {
                return this.components != null && !this.components.isEmpty();
            }
            case 6: {
                return this.connections != null && !this.connections.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }
}

