/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.internal.indexdiff;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.JobFamilies;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffCacheEntry;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffChangedListener;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffData;
import org.eclipse.jgit.lib.Repository;

public class IndexDiffCache {
    private Map<Repository, IndexDiffCacheEntry> entries = new HashMap<Repository, IndexDiffCacheEntry>();
    private Set<IndexDiffChangedListener> listeners = new HashSet<IndexDiffChangedListener>();
    private IndexDiffChangedListener globalListener;

    public IndexDiffCache() {
        this.createGlobalListener();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexDiffCacheEntry getIndexDiffCacheEntry(Repository repository) {
        IndexDiffCacheEntry entry;
        Map<Repository, IndexDiffCacheEntry> map = this.entries;
        synchronized (map) {
            block5: {
                entry = this.entries.get(repository);
                if (entry != null) {
                    return entry;
                }
                if (!repository.isBare()) break block5;
                return null;
            }
            entry = new IndexDiffCacheEntry(repository);
            this.entries.put(repository, entry);
        }
        entry.addIndexDiffChangedListener(this.globalListener);
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIndexDiffChangedListener(IndexDiffChangedListener listener) {
        Set<IndexDiffChangedListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeIndexDiffChangedListener(IndexDiffChangedListener listener) {
        Set<IndexDiffChangedListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(listener);
        }
    }

    private void createGlobalListener() {
        this.globalListener = new IndexDiffChangedListener(){

            public void indexDiffChanged(Repository repository, IndexDiffData indexDiffData) {
                IndexDiffCache.this.notifyListeners(repository, indexDiffData);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners(Repository repository, IndexDiffData indexDiffData) {
        IndexDiffChangedListener[] tmpListeners;
        Set<IndexDiffChangedListener> set = this.listeners;
        synchronized (set) {
            tmpListeners = this.listeners.toArray(new IndexDiffChangedListener[this.listeners.size()]);
        }
        int i = 0;
        while (i < tmpListeners.length) {
            try {
                tmpListeners[i].indexDiffChanged(repository, indexDiffData);
            }
            catch (RuntimeException e) {
                Activator.logError("Exception occured in an IndexDiffChangedListener", e);
            }
            ++i;
        }
    }

    public void dispose() {
        for (IndexDiffCacheEntry entry : this.entries.values()) {
            entry.dispose();
        }
        Job.getJobManager().cancel(JobFamilies.INDEX_DIFF_CACHE_UPDATE);
        try {
            Job.getJobManager().join(JobFamilies.INDEX_DIFF_CACHE_UPDATE, null);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }
}

