/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.emf.validation.validity.ui.wizards;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.ocl.examples.emf.validation.validity.ui.messages.ValidityUIMessages;
import org.eclipse.ocl.examples.emf.validation.validity.ui.ripoffs.ResourceAndContainerGroup;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.PlatformUI;

public class ExportValidationResultsFileWizardPage
extends WizardPage
implements Listener {
    private static final int SIZING_CONTAINER_GROUP_HEIGHT = 120;
    private static final String NEW_FILE_WIZARD_PAGE = "org.eclipse.ocl.examples.emf.validation.validity.ui." + ValidityUIMessages.NewWizardPage_newFileWizardContextId;
    @Nullable
    private final String preferredExtension;
    @Nullable
    private final IResource initialResource;
    @Nullable
    private ResourceAndContainerGroup resourceGroup;

    public ExportValidationResultsFileWizardPage(@Nullable String preferredExtension, @NonNull IResource initialResource) {
        super(ValidityUIMessages.NewWizardPage_pageName);
        this.setTitle(ValidityUIMessages.NewWizardPage_pageSummary);
        this.setDescription(ValidityUIMessages.NewWizardPage_pageDescription);
        this.setPageComplete(false);
        this.preferredExtension = preferredExtension;
        this.initialResource = initialResource;
    }

    public void createControl(Composite parent) {
        Composite topLevel = new Composite(parent, 0);
        topLevel.setLayout((Layout)new GridLayout());
        topLevel.setLayoutData((Object)new GridData(272));
        topLevel.setFont(parent.getFont());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)topLevel, NEW_FILE_WIZARD_PAGE);
        this.resourceGroup = this.createResourceAndContainerArea(topLevel);
        this.initSelection(this.initialResource);
        this.validatePage();
        this.setControl((Control)topLevel);
    }

    @Nullable
    private ResourceAndContainerGroup createResourceAndContainerArea(Composite parent) {
        ResourceAndContainerGroup resourceGroup = new ResourceAndContainerGroup(parent, this, ValidityUIMessages.NewWizardPage_fileNameLabel, ValidityUIMessages.NewWizardPage_file, false, 120);
        resourceGroup.setAllowExistingResources(false);
        resourceGroup.setResourceExtension(this.preferredExtension);
        return resourceGroup;
    }

    @NonNull
    private ResourceAndContainerGroup getGroup() {
        ResourceAndContainerGroup resourceGroup2 = this.resourceGroup;
        assert (resourceGroup2 != null);
        return resourceGroup2;
    }

    private boolean isFilteredByParent() {
        ResourceAndContainerGroup group = this.getGroup();
        IPath containerPath = group.getContainerFullPath();
        if (containerPath == null) {
            return false;
        }
        String resourceName = group.getResource();
        if (resourceName == null) {
            return false;
        }
        if (resourceName.length() > 0) {
            IFile newFileHandle = this.getNewExportedFile();
            IWorkspace workspace = newFileHandle.getWorkspace();
            return !workspace.validateFiltered((IResource)newFileHandle).isOK();
        }
        return false;
    }

    private boolean validatePage() {
        this.setMessage(ValidityUIMessages.NewWizardPage_pageDescription);
        this.setErrorMessage(null);
        return this.validateGroup();
    }

    private String getNewExportedFileName() {
        return this.getGroup().getResource();
    }

    private IFile getNewExportedFile() {
        IPath newFilePath = this.getNewExportedFilePath();
        return ResourcesPlugin.getWorkspace().getRoot().getFile(newFilePath);
    }

    public IPath getNewExportedFilePath() {
        ResourceAndContainerGroup group = this.getGroup();
        IPath containerPath = group.getContainerFullPath();
        return containerPath.append(group.getResource());
    }

    private void initSelection(IResource initialSelection) {
        ResourceAndContainerGroup resourceGroup2 = this.resourceGroup;
        IResource resourceSelection2 = initialSelection;
        if (resourceGroup2 != null && resourceSelection2 != null) {
            resourceGroup2.setResource(String.valueOf(ValidityUIMessages.NewWizardPage_defaultFileName) + "." + this.preferredExtension);
            this.initialPopulateContainerNameField(resourceSelection2);
        }
    }

    private void initialPopulateContainerNameField(@NonNull IResource resourceSelection) {
        ResourceAndContainerGroup resourceGroup2 = this.getGroup();
        if (resourceSelection.getType() == 1) {
            resourceSelection = resourceSelection.getParent();
        }
        if (resourceSelection.isAccessible()) {
            resourceGroup2.setContainerFullPath(resourceSelection.getFullPath());
        }
    }

    private boolean validateGroup() {
        boolean valid = true;
        ResourceAndContainerGroup group = this.getGroup();
        if (!group.areAllValuesValid()) {
            int problemType = group.getProblemType();
            String problemMessage = group.getProblemMessage();
            if (problemType == 1 || problemType == 5) {
                this.setMessage(problemMessage);
                this.setErrorMessage(null);
            } else {
                this.setErrorMessage(problemMessage);
            }
            valid = false;
        }
        String resourceName = group.getResource();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IStatus result = workspace.validateName(resourceName, 1);
        if (!result.isOK()) {
            this.setErrorMessage(result.getMessage());
            return false;
        }
        if (group.getAllowExistingResources()) {
            String problemMessage = NLS.bind((String)ValidityUIMessages.NewWizardPage_nameExists, (Object)this.getNewExportedFileName());
            IPath resourcePath = group.getContainerFullPath().append(this.getNewExportedFileName());
            IWorkspaceRoot root = workspace.getRoot();
            if (root.getFolder(resourcePath).exists()) {
                this.setErrorMessage(problemMessage);
                valid = false;
            }
            if (root.getFile(resourcePath).exists()) {
                this.setMessage(problemMessage, 2);
            }
        }
        if (this.isFilteredByParent()) {
            this.setMessage(ValidityUIMessages.NewWizardPage_resourceWillBeFilteredWarning, 3);
            valid = false;
        }
        return valid;
    }

    public void handleEvent(Event event) {
        this.setPageComplete(this.validatePage());
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.getGroup().setFocus();
        }
    }
}

