/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.emf.validation.validity.ui.view;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.emf.validation.validity.AbstractNode;
import org.eclipse.ocl.examples.emf.validation.validity.ConstrainingNode;
import org.eclipse.ocl.examples.emf.validation.validity.Result;
import org.eclipse.ocl.examples.emf.validation.validity.ResultConstrainingNode;
import org.eclipse.ocl.examples.emf.validation.validity.ResultSet;
import org.eclipse.ocl.examples.emf.validation.validity.ResultValidatableNode;
import org.eclipse.ocl.examples.emf.validation.validity.RootNode;
import org.eclipse.ocl.examples.emf.validation.validity.ValidatableNode;
import org.eclipse.ocl.examples.emf.validation.validity.ValidityPackage;
import org.eclipse.ocl.examples.emf.validation.validity.manager.ValidityManager;
import org.eclipse.ocl.examples.emf.validation.validity.manager.ValidityModel;
import org.eclipse.ocl.examples.emf.validation.validity.ui.view.ValidityView;
import org.eclipse.ocl.examples.emf.validation.validity.ui.view.ValidityViewRefreshJob;

public class IDEValidityManager
extends ValidityManager {
    public static final int FAST_REFRESH_DELAY = 250;
    public static final int SLOW_REFRESH_DELAY = 2500;
    @NonNull
    private static final List<Job> validityJobs = new ArrayList<Job>();
    @NonNull
    private final AbstractNodeAdapter nodeAdapter = new AbstractNodeAdapter();
    @NonNull
    private final ResultAdapter resultAdapter = new ResultAdapter();
    @NonNull
    private final ValidityViewRefreshJob refreshJob;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stopValidation() {
        while (!validityJobs.isEmpty()) {
            ArrayList<Job> jobs;
            List<Job> list = validityJobs;
            synchronized (list) {
                jobs = new ArrayList<Job>(validityJobs);
            }
            for (Job job : jobs) {
                job.cancel();
            }
        }
    }

    public IDEValidityManager(@NonNull ValidityViewRefreshJob refreshJob) {
        this.refreshJob = refreshJob;
    }

    @NonNull
    protected ValidityModel createModel(@NonNull Collection<Resource> newResources) {
        IDEValidityModel contents = new IDEValidityModel(this, newResources);
        RootNode rootNode = contents.getRootNode();
        this.installAdapters((List<? extends AbstractNode>)rootNode.getConstrainingNodes());
        this.installAdapters((List<? extends AbstractNode>)rootNode.getValidatableNodes());
        return contents;
    }

    private void installAdapters(@NonNull List<? extends AbstractNode> nodes) {
        for (AbstractNode abstractNode : nodes) {
            abstractNode.eAdapters().add((Object)this.nodeAdapter);
            this.installAdapters((List<? extends AbstractNode>)abstractNode.getChildren());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runValidation(@NonNull ValidityView validityView) {
        ValidityViewJob validationJob = new ValidityViewJob(validityView);
        List<Job> list = validityJobs;
        synchronized (list) {
            validityJobs.add(validationJob);
        }
        validationJob.schedule();
    }

    public void redraw() {
        this.refreshJob.add(null);
    }

    static /* synthetic */ List access$1() {
        return validityJobs;
    }

    static /* synthetic */ List access$2(IDEValidityManager iDEValidityManager, ResultSet resultSet, IProgressMonitor iProgressMonitor) {
        return iDEValidityManager.installResultSet(resultSet, iProgressMonitor);
    }

    public class AbstractNodeAdapter
    extends AdapterImpl {
        public void notifyChanged(Notification notification) {
            Object target = notification.getNotifier();
            if (target instanceof AbstractNode) {
                int event = notification.getEventType();
                Object feature = notification.getFeature();
                if (event == 1) {
                    if (feature == ValidityPackage.Literals.ABSTRACT_NODE__ENABLED) {
                        IDEValidityManager.this.refreshJob.add((AbstractNode)target);
                    } else if (feature == ValidityPackage.Literals.ABSTRACT_NODE__GRAYED) {
                        IDEValidityManager.this.refreshJob.add((AbstractNode)target);
                    } else if (feature == ValidityPackage.Literals.ABSTRACT_NODE__WORST_RESULT) {
                        IDEValidityManager.this.refreshJob.add((AbstractNode)target);
                    } else if (feature == ValidityPackage.Literals.ABSTRACT_NODE__LABEL) {
                        IDEValidityManager.this.refreshJob.add((AbstractNode)target);
                    }
                }
            }
        }
    }

    protected class IDEValidityModel
    extends ValidityModel {
        public IDEValidityModel(@NonNull IDEValidityManager validityManager, Collection<Resource> newResources) {
            super((ValidityManager)validityManager, newResources);
        }

        @Nullable
        protected Result createResult(@Nullable IProgressMonitor monitor) {
            if (monitor != null && monitor.isCanceled()) {
                return null;
            }
            Result result = super.createResult(monitor);
            if (result == null) {
                return null;
            }
            result.eAdapters().add((Object)IDEValidityManager.this.resultAdapter);
            return result;
        }
    }

    public class ResultAdapter
    extends AdapterImpl {
        public void notifyChanged(Notification notification) {
            Object target = notification.getNotifier();
            if (target instanceof Result) {
                Result result = (Result)target;
                int event = notification.getEventType();
                Object feature = notification.getFeature();
                if (event == 1 && feature == ValidityPackage.Literals.RESULT__SEVERITY) {
                    ResultValidatableNode resultValidatableNode;
                    ResultConstrainingNode resultConstrainingNode = result.getResultConstrainingNode();
                    if (resultConstrainingNode != null) {
                        IDEValidityManager.this.refreshJob.add((AbstractNode)resultConstrainingNode);
                        ConstrainingNode parent = resultConstrainingNode.getParent();
                        if (parent != null) {
                            IDEValidityManager.this.refreshJob.add((AbstractNode)parent);
                        }
                    }
                    if ((resultValidatableNode = result.getResultValidatableNode()) != null) {
                        IDEValidityManager.this.refreshJob.add((AbstractNode)resultValidatableNode);
                        ValidatableNode parent = resultValidatableNode.getParent();
                        if (parent != null) {
                            IDEValidityManager.this.refreshJob.add((AbstractNode)parent);
                        }
                    }
                }
            }
        }
    }

    private class ValidityViewJob
    extends Job {
        @NonNull
        protected final ValidityView validityView;

        private ValidityViewJob(ValidityView validityView) {
            super("Validity View Validation");
            this.validityView = validityView;
        }

        /*
         * Exception decompiling
         */
        protected IStatus run(IProgressMonitor monitor) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[TRYBLOCK]], but top level block is 28[WHILELOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @NonNull
        private List<ConstrainingNode> getConstrainingNodeAncestors(@NonNull ConstrainingNode constraining) {
            ConstrainingNode ancestor = constraining.getParent();
            ArrayList<ConstrainingNode> ancestors = new ArrayList<ConstrainingNode>();
            while (ancestor != null) {
                ancestors.add(ancestor);
                ancestor = ancestor.getParent();
            }
            return ancestors;
        }
    }
}

