/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.emf.validation.validity.ui.providers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ocl.examples.emf.validation.validity.AbstractNode;
import org.eclipse.ocl.examples.emf.validation.validity.RootNode;
import org.eclipse.ocl.examples.emf.validation.validity.manager.ValidityManager;

public abstract class AbstractNodeContentProvider
implements ITreeContentProvider {
    @NonNull
    public static final Object[] NO_OBJECTS = new Object[0];
    @NonNull
    private final ValidityManager validityManager;

    public AbstractNodeContentProvider(@NonNull ValidityManager validityManager) {
        this.validityManager = validityManager;
    }

    public void dispose() {
    }

    public Object[] getElements(Object inputElement) {
        RootNode rootNode = this.validityManager.getRootNode();
        if (rootNode == null) {
            return NO_OBJECTS;
        }
        List<? extends AbstractNode> validatableNodes = this.getRootNodes(rootNode);
        ArrayList<AbstractNode> visibleNodes = new ArrayList<AbstractNode>(validatableNodes.size());
        for (AbstractNode abstractNode : validatableNodes) {
            if (!abstractNode.isVisible()) continue;
            visibleNodes.add(abstractNode);
        }
        return visibleNodes.toArray(new Object[visibleNodes.size()]);
    }

    public Object[] getChildren(Object parentElement) {
        return ((AbstractNode)parentElement).getVisibleChildren();
    }

    public Object getParent(Object element) {
        return ((AbstractNode)element).getParent();
    }

    @NonNull
    protected abstract List<? extends AbstractNode> getRootNodes(@NonNull RootNode var1);

    public boolean hasChildren(Object element) {
        AbstractNode[] validatableNodes = ((AbstractNode)element).getVisibleChildren();
        return validatableNodes.length > 0;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }
}

