/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.emf.validation.validity.ui.actions;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.ocl.examples.emf.validation.validity.ui.actions.RunValidityAction;
import org.eclipse.ocl.examples.emf.validation.validity.ui.view.ValidityView;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.part.EditorPart;

public class ShowValidityViewHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Object applicationContext = event.getApplicationContext();
        Object editorPart = HandlerUtil.getVariable((Object)applicationContext, (String)"activeEditor");
        Object shell = HandlerUtil.getVariable((Object)applicationContext, (String)"activeShell");
        if (!(shell instanceof Shell) || !(editorPart instanceof EditorPart)) {
            return null;
        }
        EditorPart editorPartInstance = (EditorPart)editorPart;
        IWorkbenchPartSite site = editorPartInstance.getSite();
        this.updateValidityView(site, true, true);
        return null;
    }

    private void updateValidityView(IWorkbenchPartSite site, boolean openAsNeeded, boolean runValidation) {
        IViewReference[] openViews = site.getPage().getViewReferences();
        if (this.isValidityViewOpen(openViews) || openAsNeeded) {
            try {
                site.getPage().showView("org.eclipse.ocl.examples.emf.validation.validity.ui.validity");
            }
            catch (PartInitException e) {
                return;
            }
        } else {
            return;
        }
        IWorkbenchPart part = site.getPart();
        IViewReference validityViewReference = site.getPage().findViewReference("org.eclipse.ocl.examples.emf.validation.validity.ui.validity", null);
        IViewPart viewPart = validityViewReference.getView(true);
        if (viewPart instanceof ValidityView) {
            ValidityView validityView = (ValidityView)viewPart;
            validityView.selectionChanged(part, site.getSelectionProvider().getSelection());
            if (runValidation) {
                RunValidityAction runValidationAction = new RunValidityAction(validityView);
                runValidationAction.run();
            }
        }
        viewPart.setFocus();
    }

    private boolean isValidityViewOpen(IViewReference[] openViews) {
        IViewReference[] iViewReferenceArray = openViews;
        int n = openViews.length;
        int n2 = 0;
        while (n2 < n) {
            IViewReference view = iViewReferenceArray[n2];
            if ("org.eclipse.ocl.examples.emf.validation.validity.ui.validity".equals(view.getId())) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

