/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.infra.browser.uicore;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.gmt.modisco.infra.browser.uicore.CustomizationManager;
import org.eclipse.gmt.modisco.infra.browser.uicore.internal.AppearanceConfiguration;
import org.eclipse.gmt.modisco.infra.browser.uicore.internal.model.ITreeElement;
import org.eclipse.gmt.modisco.infra.browser.uicore.internal.model.ModelElementItem;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class CustomizableModelContentProvider
implements ITreeContentProvider {
    private final AppearanceConfiguration appearanceConfiguration;

    public CustomizableModelContentProvider(CustomizationManager customizationManager) {
        this.appearanceConfiguration = customizationManager.getAppearanceConfiguration();
    }

    public Object[] getElements(Object inputElement) {
        Object[] rootElements = this.getRootElements(inputElement);
        if (rootElements == null) {
            return null;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        Object[] objectArray = rootElements;
        int n = rootElements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element instanceof EObject) {
                EObject eObject = (EObject)element;
                result.add(new ModelElementItem(eObject, null, this.appearanceConfiguration));
            } else {
                result.add(element);
            }
            ++n2;
        }
        return result.toArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getRootElements(Object inputElement) {
        IFile file;
        URI uri;
        ResourceSetImpl resourceSet;
        Resource resource;
        if (inputElement instanceof IFile && (resource = (resourceSet = new ResourceSetImpl()).getResource(uri = URI.createFileURI((String)(file = (IFile)inputElement).getLocation().toString()), true)) != null) {
            Resource resource2 = resource;
            synchronized (resource2) {
                EList contents = resource.getContents();
                return contents.toArray();
            }
        }
        return null;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof ITreeElement) {
            ITreeElement treeElement = (ITreeElement)parentElement;
            return treeElement.getChildren().toArray();
        }
        return null;
    }

    public Object getParent(Object element) {
        if (element instanceof ITreeElement) {
            ITreeElement treeElement = (ITreeElement)element;
            return treeElement.getTreeParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof ITreeElement) {
            ITreeElement treeElement = (ITreeElement)element;
            return treeElement.hasChildren();
        }
        return false;
    }
}

