/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.ant;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.internal.build.BundleHelper;
import org.eclipse.pde.internal.build.tasks.TaskHelper;
import org.eclipse.pde.internal.core.PDECoreMessages;
import org.eclipse.pde.internal.core.target.ExportTargetJob;
import org.eclipse.pde.internal.core.target.TargetPlatformService;

public class TargetPlatformProvisionTask
extends Task {
    private File targetFile;
    private File destinationDirectory;
    private boolean clearDestination;

    public void execute() throws BuildException {
        try {
            try {
                BundleHelper.getDefault().setLog((Object)this);
                this.run();
            }
            catch (CoreException e) {
                throw new BuildException(TaskHelper.statusToString((IStatus)e.getStatus(), null).toString());
            }
        }
        finally {
            BundleHelper.getDefault().setLog(null);
        }
    }

    private void export(ITargetDefinition targetDefinition) throws CoreException {
        ExportTargetJob exportTargetJob = new ExportTargetJob(targetDefinition, this.destinationDirectory.toURI(), this.clearDestination);
        exportTargetJob.schedule();
        try {
            exportTargetJob.join();
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw new CoreException(Status.CANCEL_STATUS);
        }
    }

    private IStatus resolve(final ITargetDefinition targetDefinition) throws CoreException {
        final IStatus[] status = new IStatus[1];
        Job resolveJob = new Job(NLS.bind((String)PDECoreMessages.TargetPlatformProvisionTask_Resolving_X_Job, (Object)(targetDefinition.getName() != null && targetDefinition.getName().length() > 0 ? targetDefinition.getName() : this.targetFile.getName()))){

            protected IStatus run(IProgressMonitor monitor) {
                status[0] = targetDefinition.resolve(monitor);
                return Status.OK_STATUS;
            }
        };
        resolveJob.setPriority(30);
        resolveJob.schedule();
        try {
            resolveJob.join();
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw new CoreException(Status.CANCEL_STATUS);
        }
        return status[0];
    }

    private void run() throws CoreException {
        if (this.targetFile == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", PDECoreMessages.TargetPlatformProvisionTask_ErrorDefinitionNotSet));
        }
        if (!this.targetFile.isFile() || !this.targetFile.canRead()) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", NLS.bind((String)PDECoreMessages.TargetPlatformProvisionTask_ErrorDefinitionNotFoundAtSpecifiedLocation, (Object)this.targetFile)));
        }
        if (this.destinationDirectory == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", PDECoreMessages.TargetPlatformProvisionTask_ErrorDestinationNotSet));
        }
        ITargetDefinition targetDefinition = TargetPlatformService.getDefault().getTarget(this.targetFile.toURI()).getTargetDefinition();
        this.log(PDECoreMessages.TargetPlatformProvisionTask_Resolving_target_status);
        IStatus status = this.resolve(targetDefinition);
        if (status.matches(12)) {
            throw new CoreException(status);
        }
        if (!status.isOK()) {
            this.log(TaskHelper.statusToString((IStatus)status, null).toString(), 1);
        }
        this.log(PDECoreMessages.TargetPlatformProvisionTask_Exporting_target_status);
        this.export(targetDefinition);
    }

    public void setClearDestination(boolean clearDestination) {
        this.clearDestination = clearDestination;
    }

    public void setDestinationDirectory(File destinationDirectory) {
        this.destinationDirectory = destinationDirectory;
    }

    public void setTargetFile(File targetFile) {
        this.targetFile = targetFile;
    }
}

