/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.ant;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PDECoreMessages;
import org.eclipse.pde.internal.core.XMLDefaultHandler;
import org.eclipse.pde.internal.core.builders.SchemaTransformer;
import org.eclipse.pde.internal.core.ischema.ISchema;
import org.eclipse.pde.internal.core.ischema.ISchemaInclude;
import org.eclipse.pde.internal.core.plugin.ExternalFragmentModel;
import org.eclipse.pde.internal.core.plugin.ExternalPluginModel;
import org.eclipse.pde.internal.core.schema.Schema;
import org.eclipse.pde.internal.core.schema.SchemaDescriptor;
import org.eclipse.pde.internal.core.util.HeaderMap;
import org.eclipse.pde.internal.core.util.SAXParserWrapper;
import org.xml.sax.helpers.DefaultHandler;

public class ConvertSchemaToHTML
extends Task {
    private SchemaTransformer fTransformer = new SchemaTransformer();
    private String manifest;
    private String destination;
    private URL cssURL;
    private String additionalSearchPaths;

    public void execute() throws BuildException {
        if (this.destination == null) {
            throw new BuildException(NLS.bind((String)PDECoreMessages.Builders_Convert_missingAttribute, (Object)"destination"));
        }
        if (this.manifest == null) {
            throw new BuildException(NLS.bind((String)PDECoreMessages.Builders_Convert_missingAttribute, (Object)"manifest"));
        }
        if (!new Path(this.destination).isValidPath(this.destination)) {
            throw new BuildException(NLS.bind((String)PDECoreMessages.Builders_Convert_illegalValue, (Object)"destination"));
        }
        IPluginModelBase model = this.readManifestFile();
        if (model == null) {
            return;
        }
        String pluginID = model.getPluginBase().getId();
        if (pluginID == null) {
            pluginID = this.getPluginID();
        }
        List<IPath> searchPaths = this.getSearchPaths();
        IPluginExtensionPoint[] extPoints = model.getPluginBase().getExtensionPoints();
        int i = 0;
        while (i < extPoints.length) {
            String schemaLocation = extPoints[i].getSchema();
            PrintWriter out = null;
            if (schemaLocation != null && !schemaLocation.equals("")) {
                Schema schema = null;
                SAXParserWrapper parser = null;
                try {
                    File directory;
                    parser = new SAXParserWrapper();
                    File schemaFile = new File(model.getInstallLocation(), schemaLocation);
                    XMLDefaultHandler handler = new XMLDefaultHandler();
                    parser.parse(schemaFile, (DefaultHandler)handler);
                    URL url = schemaFile.toURL();
                    SchemaDescriptor desc = new SchemaDescriptor(extPoints[i].getFullId(), url, searchPaths);
                    schema = (Schema)desc.getSchema(false);
                    ISchemaInclude[] includes = schema.getIncludes();
                    int j = 0;
                    while (j < includes.length) {
                        if (includes[j].getIncludedSchema() == null) {
                            this.log(NLS.bind((String)PDECoreMessages.ConvertSchemaToHTML_CannotFindIncludedSchema, (Object)includes[j].getLocation(), (Object)schemaFile), 0);
                        }
                        ++j;
                    }
                    File file = directory = new Path(this.destination).isAbsolute() ? new File(this.destination) : new File(this.getProject().getBaseDir(), this.destination);
                    if (!(directory.exists() && directory.isDirectory() || directory.mkdirs())) {
                        schema.dispose();
                        return;
                    }
                    try {
                        String id = extPoints[i].getId();
                        if (id.indexOf(46) == -1) {
                            id = String.valueOf(pluginID) + "." + id;
                        }
                        File file2 = new File(directory, String.valueOf(id.replace('.', '_')) + ".html");
                        out = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(file2), "UTF-8"), true);
                        this.fTransformer.transform((ISchema)schema, out, this.cssURL, (byte)1);
                    }
                    catch (Exception e) {
                        throw new BuildException((Throwable)e);
                    }
                }
                finally {
                    if (out != null) {
                        out.close();
                    }
                    if (schema != null) {
                        schema.dispose();
                    }
                }
            }
            ++i;
        }
    }

    public void setManifest(String manifest) {
        this.manifest = manifest;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public void setAdditionalSearchPaths(String additionalSearchPaths) {
        this.additionalSearchPaths = additionalSearchPaths;
    }

    public URL getCSSURL() {
        return this.cssURL;
    }

    public void setCSSURL(String url) {
        try {
            this.cssURL = new URL(url);
        }
        catch (MalformedURLException e) {
            PDECore.logException((Throwable)e);
        }
    }

    public void setCSSURL(URL url) {
        this.cssURL = url;
    }

    private String getPluginID() {
        File file = new Path(this.manifest).isAbsolute() ? new File(this.manifest) : new File(this.getProject().getBaseDir(), this.manifest);
        File OSGiFile = new File(file.getParentFile(), "META-INF/MANIFEST.MF");
        if (OSGiFile.exists()) {
            String value;
            block5: {
                Map headers = ManifestElement.parseBundleManifest((InputStream)new FileInputStream(OSGiFile), (Map)new HeaderMap());
                value = ((String)headers.get("Bundle-SymbolicName")).toString();
                if (value != null) break block5;
                return null;
            }
            try {
                ManifestElement[] elements = ManifestElement.parseHeader((String)"Bundle-SymbolicName", (String)value);
                if (elements.length > 0) {
                    return elements[0].getValue();
                }
            }
            catch (Exception e1) {
                System.out.print(e1.getMessage());
            }
        }
        return null;
    }

    private List<IPath> getSearchPaths() {
        if (this.additionalSearchPaths == null) {
            return null;
        }
        String[] paths = this.additionalSearchPaths.split(",");
        ArrayList<IPath> result = new ArrayList<IPath>(paths.length);
        int i = 0;
        while (i < paths.length) {
            Path path = new Path(paths[i]);
            if (path.isValidPath(paths[i])) {
                if (!path.isAbsolute()) {
                    File baseDir = this.getProject().getBaseDir();
                    path = new Path(baseDir.getPath()).append((IPath)path);
                }
                result.add((IPath)path);
            } else {
                System.out.println(NLS.bind((String)PDECoreMessages.ConvertSchemaToHTML_InvalidAdditionalSearchPath, (Object)paths[i]));
            }
            ++i;
        }
        return result;
    }

    private IPluginModelBase readManifestFile() throws BuildException {
        File file = new Path(this.manifest).isAbsolute() ? new File(this.manifest) : new File(this.getProject().getBaseDir(), this.manifest);
        BufferedInputStream stream = null;
        try {
            stream = new BufferedInputStream(new FileInputStream(file));
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
        ExternalFragmentModel model = null;
        try {
            if (file.getName().toLowerCase(Locale.ENGLISH).equals("fragment.xml")) {
                model = new ExternalFragmentModel();
            } else if (file.getName().toLowerCase(Locale.ENGLISH).equals("plugin.xml")) {
                model = new ExternalPluginModel();
            } else {
                ((InputStream)stream).close();
                throw new BuildException(NLS.bind((String)PDECoreMessages.Builders_Convert_illegalValue, (Object)"manifest"));
            }
            String parentPath = file.getParentFile().getAbsolutePath();
            model.setInstallLocation(parentPath);
            model.load((InputStream)stream, false);
            ((InputStream)stream).close();
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
        return model;
    }
}

