/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.alf.validation.typing;

import org.eclipse.papyrus.uml.alf.validation.typing.MultiplicityFacade;
import org.eclipse.papyrus.uml.alf.validation.typing.TypeFacade;
import org.eclipse.papyrus.uml.alf.validation.typing.TypeUtils;

public class TypeExpression {
    private TypeFacade type;
    private MultiplicityFacade multiplicity;

    public String getLabel() {
        String label = "";
        label = String.valueOf(label) + this.type.getLabel();
        label = String.valueOf(label) + this.multiplicity.getLabel();
        return label;
    }

    public TypeFacade getTypeFacade() {
        return this.type;
    }

    public MultiplicityFacade getMultiplicityFacade() {
        return this.multiplicity;
    }

    public int isCompatibleWithMe(TypeExpression t) {
        if (t == TypeUtils._nullExpression) {
            return 3;
        }
        int typeCompatibilityLevel = this.type.isCompatibleWithMe(t.type);
        if (typeCompatibilityLevel == 0) {
            return 0;
        }
        boolean isCompatible = this.multiplicity.isCompatibleWithMe(t.multiplicity);
        if (isCompatible) {
            return typeCompatibilityLevel;
        }
        return 0;
    }

    public void setType(TypeFacade type) {
        this.type = type;
    }

    public MultiplicityFacade getMultiplicity() {
        return this.multiplicity;
    }

    public void setMultiplicity(MultiplicityFacade multiplicity) {
        this.multiplicity = multiplicity;
    }

    public boolean isACollection() {
        boolean isACollection = this.multiplicity.getUpperBound() == -1 || this.multiplicity.getUpperBound() > 1 || this.type.isACollection();
        return isACollection;
    }

    public boolean isOrdered() {
        return this.multiplicity.isOrdered() || this.type.isOrdered();
    }
}

