/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.alf.validation.typing;

public class MultiplicityFacade {
    private int lowerBound = 0;
    private int upperBound = 0;
    private boolean nonUnique = false;
    private boolean ordered = false;

    public String getLabel() {
        if (this.lowerBound == this.upperBound) {
            if (this.lowerBound == 1) {
                return "";
            }
            if (this.lowerBound == -1) {
                return "[*]";
            }
            return "[" + this.lowerBound + "]";
        }
        if (this.upperBound == -1) {
            if (this.lowerBound == 0) {
                return "[*]";
            }
            return "[" + this.lowerBound + "..*]";
        }
        return "[" + this.lowerBound + ".." + this.upperBound + "]";
    }

    public boolean isCompatibleWithMe(MultiplicityFacade multiplicity) {
        boolean upperBoundCompatible = true;
        switch (this.upperBound) {
            case -1: {
                break;
            }
            default: {
                if (multiplicity.upperBound != -1) break;
                upperBoundCompatible = false;
            }
        }
        return upperBoundCompatible;
    }

    public void setLowerBound(int lowerBound) {
        this.lowerBound = lowerBound;
    }

    public void setUpperBound(int lowerBound) {
        this.upperBound = lowerBound;
    }

    public int getLowerBound() {
        return this.lowerBound;
    }

    public int getUpperBound() {
        return this.upperBound;
    }

    public boolean isUnique() {
        return !this.nonUnique;
    }

    public boolean isOrdered() {
        return this.ordered;
    }

    public boolean isSequence() {
        return this.ordered && this.nonUnique;
    }

    public void setIsUnique(boolean isUnique) {
        this.nonUnique = !isUnique;
    }

    public void setIsOrdered(boolean isOrdered) {
        this.ordered = isOrdered;
    }

    public void setIsSequence(boolean isSequence) {
        this.ordered = true;
        this.nonUnique = true;
    }
}

