/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.alf.scoping;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlfPartialScope {
    private List<List<EObject>> nestedScopes;
    private IGetNameStrategy nameStrategy;
    private IBuildScopeStrategy buildScopeStrategy;

    public AlfPartialScope(IGetNameStrategy nameStrategy, IBuildScopeStrategy buildScopeStrategy, EObject contextElement) {
        this.nameStrategy = nameStrategy;
        this.buildScopeStrategy = buildScopeStrategy;
        this.nestedScopes = buildScopeStrategy.buildScope(contextElement);
    }

    public String getElementName(EObject eObject) {
        return this.nameStrategy.getName(eObject);
    }

    public void buildScope(EObject contextElement) {
        this.nestedScopes = this.buildScopeStrategy.buildScope(contextElement);
    }

    public List<EObject> resolveByName(String elemName) {
        ArrayList<EObject> resolvedElements = new ArrayList<EObject>();
        Iterator<List<EObject>> nestedScopesIterator = this.nestedScopes.iterator();
        String normalizedElementName = elemName.startsWith("'") ? elemName.substring(1, elemName.length() - 1) : elemName;
        while (nestedScopesIterator.hasNext() && resolvedElements.isEmpty()) {
            for (EObject elem : nestedScopesIterator.next()) {
                if (!this.getElementName(elem).equals(normalizedElementName)) continue;
                resolvedElements.add(elem);
            }
        }
        return resolvedElements;
    }

    public List<List<EObject>> getScopeDetails() {
        return this.nestedScopes;
    }

    public int getScopingLevel(EObject element) {
        int i = 0;
        while (i < this.nestedScopes.size()) {
            if (this.nestedScopes.get(i).contains(element)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IBuildScopeStrategy {
        public List<List<EObject>> buildScope(EObject var1);
    }

    public static interface IGetNameStrategy {
        public String getName(EObject var1);
    }
}

