/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.alf.alf;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum BooleanValue implements Enumerator
{
    TRUE(0, "TRUE", "true"),
    FALSE(1, "FALSE", "false");

    public static final int TRUE_VALUE = 0;
    public static final int FALSE_VALUE = 1;
    private static final BooleanValue[] VALUES_ARRAY;
    public static final List<BooleanValue> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new BooleanValue[]{TRUE, FALSE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static BooleanValue get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            BooleanValue result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static BooleanValue getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            BooleanValue result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static BooleanValue get(int value) {
        switch (value) {
            case 0: {
                return TRUE;
            }
            case 1: {
                return FALSE;
            }
        }
        return null;
    }

    private BooleanValue(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

