/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.layers.runtime;

import org.eclipse.emf.common.util.EList;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.Shape;
import org.eclipse.papyrus.layers.runtime.LayersModelEventNotifier;
import org.eclipse.papyrus.layers.runtime.TraceLayersModelEventListener;
import org.eclipse.papyrus.layers.runtime.utils.TriggeredEventTraces;
import org.eclipse.papyrus.layers.stackmodel.LayersException;
import org.eclipse.papyrus.layers.stackmodel.layers.BooleanInstance;
import org.eclipse.papyrus.layers.stackmodel.layers.Layer;
import org.eclipse.papyrus.layers.stackmodel.layers.LayerExpression;
import org.eclipse.papyrus.layers.stackmodel.layers.LayersFactory;
import org.eclipse.papyrus.layers.stackmodel.layers.LayersPackage;
import org.eclipse.papyrus.layers.stackmodel.layers.LayersStack;
import org.eclipse.papyrus.layers.stackmodel.layers.Property;
import org.eclipse.papyrus.layers.stackmodel.layers.StackedLayerOperator;
import org.eclipse.papyrus.layers.stackmodel.layers.util.PropertyUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class LayersModelEventNotifierTest {
    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testLayersModelEventNotifier() {
        LayersStack layersStack = LayersFactory.eINSTANCE.createLayersStack();
        LayersModelEventNotifier notifier = new LayersModelEventNotifier(layersStack);
        Assert.assertNotNull((String)"notifier created", (Object)notifier);
    }

    @Test
    @Ignore
    public void testActivate() {
        Assert.fail((String)"Not yet implemented");
    }

    @Test
    @Ignore
    public void testDeactivate() {
        Assert.fail((String)"Not yet implemented");
    }

    @Test
    public void testDispose() {
        LayersStack layersStack = LayersFactory.eINSTANCE.createLayersStack();
        LayersModelEventNotifier notifier = new LayersModelEventNotifier(layersStack);
        TraceLayersModelEventListener listener = new TraceLayersModelEventListener();
        notifier.addLayersModelEventListener(listener);
        TriggeredEventTraces traces = listener.traces;
        StackedLayerOperator layerOp1 = LayersFactory.eINSTANCE.createStackedLayerOperator();
        layersStack.setLayers((LayerExpression)layerOp1);
        Assert.assertFalse((String)"notifier disposed", (boolean)notifier.isDisposed());
        notifier.dispose();
        Assert.assertTrue((String)"notifier disposed", (boolean)notifier.isDisposed());
    }

    @Test
    public void testAddLayersModelEventListener() {
        LayersStack layersStack = LayersFactory.eINSTANCE.createLayersStack();
        LayersModelEventNotifier notifier = new LayersModelEventNotifier(layersStack);
        TraceLayersModelEventListener listener = new TraceLayersModelEventListener();
        notifier.addLayersModelEventListener(listener);
        Assert.assertNotNull((String)"notifier created", (Object)notifier);
        Assert.assertTrue((String)"listener added to internal list", (boolean)notifier.listeners.contains(listener));
    }

    @Test
    public void testRemoveLayersModelEventListener() {
        LayersStack layersStack = LayersFactory.eINSTANCE.createLayersStack();
        LayersModelEventNotifier notifier = new LayersModelEventNotifier(layersStack);
        TraceLayersModelEventListener listener = new TraceLayersModelEventListener();
        notifier.addLayersModelEventListener(listener);
        Assert.assertTrue((String)"listener added to internal list", (boolean)notifier.listeners.contains(listener));
        notifier.removeLayersModelEventListener(listener);
        Assert.assertFalse((String)"listener removed from internal list", (boolean)notifier.listeners.contains(listener));
    }

    @Test
    public void testFirePropertyValueAddedEvent() throws LayersException {
        LayersStack layersStack = LayersFactory.eINSTANCE.createLayersStack();
        LayersModelEventNotifier notifier = new LayersModelEventNotifier(layersStack);
        TraceLayersModelEventListener listener = new TraceLayersModelEventListener();
        notifier.addLayersModelEventListener(listener);
        TriggeredEventTraces traces = listener.traces;
        StackedLayerOperator layerOp1 = LayersFactory.eINSTANCE.createStackedLayerOperator();
        System.err.println("setLayers(layerOp1)");
        layersStack.setLayers((LayerExpression)layerOp1);
        Assert.assertTrue((String)"event recorded", (boolean)traces.contains("layerSet"));
        Assert.assertEquals((String)"one event recorded", (long)1L, (long)traces.traces.size());
        Assert.assertEquals((String)"one event recorded", (Object)"layerSet", (Object)traces.traces.get((int)0).name);
        Layer layer1 = LayersFactory.eINSTANCE.createLayer();
        System.err.println("layerOp1.getLayers().add(layer1)");
        layerOp1.getLayers().add((Object)layer1);
        traces.traces.clear();
        Property isSunday = PropertyUtils.getInstance().createProperty("isSunday", LayersPackage.eINSTANCE.getBooleanType());
        layer1.addPropertyInstance(isSunday);
        Assert.assertEquals((String)"one event recorded", (Object)"propertyValueAdded", (Object)traces.traces.get((int)0).name);
        Assert.assertTrue((String)"event recorded", (boolean)traces.contains("propertyValueAdded"));
        Assert.assertEquals((String)"one event recorded", (long)1L, (long)traces.traces.size());
    }

    @Test
    public void testFirePropertyValueRemoved() throws LayersException {
        LayersStack layersStack = LayersFactory.eINSTANCE.createLayersStack();
        LayersModelEventNotifier notifier = new LayersModelEventNotifier(layersStack);
        TraceLayersModelEventListener listener = new TraceLayersModelEventListener();
        notifier.addLayersModelEventListener(listener);
        TriggeredEventTraces traces = listener.traces;
        StackedLayerOperator layerOp1 = LayersFactory.eINSTANCE.createStackedLayerOperator();
        System.err.println("setLayers(layerOp1)");
        layersStack.setLayers((LayerExpression)layerOp1);
        Assert.assertTrue((String)"event recorded", (boolean)traces.contains("layerSet"));
        Assert.assertEquals((String)"one event recorded", (long)1L, (long)traces.traces.size());
        Assert.assertEquals((String)"one event recorded", (Object)"layerSet", (Object)traces.traces.get((int)0).name);
        Layer layer1 = LayersFactory.eINSTANCE.createLayer();
        System.err.println("layerOp1.getLayers().add(layer1)");
        layerOp1.getLayers().add((Object)layer1);
        String propertyName = "isSunday";
        Property isSunday = PropertyUtils.getInstance().createProperty(propertyName, LayersPackage.eINSTANCE.getBooleanType());
        layer1.addPropertyInstance(isSunday);
        traces.traces.clear();
        layer1.removePropertyInstance(isSunday);
        Assert.assertEquals((String)"one event recorded", (Object)"propertyValueRemoved", (Object)traces.traces.get((int)0).name);
        Assert.assertTrue((String)"event recorded", (boolean)traces.contains("propertyValueRemoved"));
        Assert.assertEquals((String)"one event recorded", (long)1L, (long)traces.traces.size());
    }

    @Test
    public void testFirePropertyValueChanged() throws LayersException {
        LayersStack layersStack = LayersFactory.eINSTANCE.createLayersStack();
        LayersModelEventNotifier notifier = new LayersModelEventNotifier(layersStack);
        TraceLayersModelEventListener listener = new TraceLayersModelEventListener();
        notifier.addLayersModelEventListener(listener);
        TriggeredEventTraces traces = listener.traces;
        StackedLayerOperator layerOp1 = LayersFactory.eINSTANCE.createStackedLayerOperator();
        layersStack.setLayers((LayerExpression)layerOp1);
        Layer layer1 = LayersFactory.eINSTANCE.createLayer();
        layerOp1.getLayers().add((Object)layer1);
        String propertyName = "isSunday";
        Property isSunday = PropertyUtils.getInstance().createProperty(propertyName, LayersPackage.eINSTANCE.getBooleanType());
        BooleanInstance isSundayInstance = (BooleanInstance)layer1.addPropertyInstance(isSunday);
        traces.traces.clear();
        isSundayInstance.setValue(true);
        Assert.assertEquals((String)"one event recorded", (Object)"propertyValueChanged", (Object)traces.traces.get((int)0).name);
        Assert.assertTrue((String)"event recorded", (boolean)traces.contains("propertyValueChanged"));
        Assert.assertEquals((String)"one event recorded", (long)1L, (long)traces.traces.size());
    }

    @Test
    public void testFireLayerAdded() {
        LayersStack layersStack = LayersFactory.eINSTANCE.createLayersStack();
        LayersModelEventNotifier notifier = new LayersModelEventNotifier(layersStack);
        TraceLayersModelEventListener listener = new TraceLayersModelEventListener();
        notifier.addLayersModelEventListener(listener);
        TriggeredEventTraces traces = listener.traces;
        StackedLayerOperator layerOp1 = LayersFactory.eINSTANCE.createStackedLayerOperator();
        System.err.println("setLayers(layerOp1)");
        layersStack.setLayers((LayerExpression)layerOp1);
        Assert.assertTrue((String)"event recorded", (boolean)traces.contains("layerSet"));
        Assert.assertEquals((String)"one event recorded", (long)1L, (long)traces.traces.size());
        Assert.assertEquals((String)"one event recorded", (Object)"layerSet", (Object)traces.traces.get((int)0).name);
        Layer layer1 = LayersFactory.eINSTANCE.createLayer();
        System.err.println("layerOp1.getLayers().add(layer1)");
        layerOp1.getLayers().add((Object)layer1);
        Assert.assertTrue((String)"event recorded", (boolean)traces.contains("layerAdded"));
        Assert.assertEquals((String)"one event recorded", (long)2L, (long)traces.traces.size());
        Assert.assertEquals((String)"one event recorded", (Object)"layerAdded", (Object)traces.traces.get((int)1).name);
    }

    @Test
    public void testFireLayerRemoved() {
        LayersStack layersStack = LayersFactory.eINSTANCE.createLayersStack();
        LayersModelEventNotifier notifier = new LayersModelEventNotifier(layersStack);
        TraceLayersModelEventListener listener = new TraceLayersModelEventListener();
        notifier.addLayersModelEventListener(listener);
        TriggeredEventTraces traces = listener.traces;
        StackedLayerOperator layerOp1 = LayersFactory.eINSTANCE.createStackedLayerOperator();
        layersStack.setLayers((LayerExpression)layerOp1);
        Layer layer1 = LayersFactory.eINSTANCE.createLayer();
        layerOp1.getLayers().add((Object)layer1);
        traces.clear();
        layerOp1.getLayers().remove((Object)layer1);
        Assert.assertTrue((String)"event recorded", (boolean)traces.contains("layerRemoved"));
        Assert.assertEquals((String)"one event recorded", (long)1L, (long)traces.traces.size());
        Assert.assertEquals((String)"one event recorded", (Object)"layerRemoved", (Object)traces.traces.get((int)0).name);
    }

    @Test
    public void testFireLayerSetForRootLayer() {
        LayersStack layersStack = LayersFactory.eINSTANCE.createLayersStack();
        LayersModelEventNotifier notifier = new LayersModelEventNotifier(layersStack);
        TraceLayersModelEventListener listener = new TraceLayersModelEventListener();
        notifier.addLayersModelEventListener(listener);
        TriggeredEventTraces traces = listener.traces;
        StackedLayerOperator layerOp1 = LayersFactory.eINSTANCE.createStackedLayerOperator();
        layersStack.setLayers((LayerExpression)layerOp1);
        Layer layer1 = LayersFactory.eINSTANCE.createLayer();
        layerOp1.getLayers().add((Object)layer1);
        traces.clear();
        layersStack.setLayers(null);
        Assert.assertTrue((String)"event recorded", (boolean)traces.contains("layerSet"));
        Assert.assertEquals((String)"one event recorded", (long)1L, (long)traces.traces.size());
        Assert.assertEquals((String)"one event recorded", (Object)"layerSet", (Object)traces.traces.get((int)0).name);
    }

    @Test
    public void testFireEventWhenRootLayerIsReplaced() {
        LayersStack layersStack = LayersFactory.eINSTANCE.createLayersStack();
        LayersModelEventNotifier notifier = new LayersModelEventNotifier(layersStack);
        TraceLayersModelEventListener listener = new TraceLayersModelEventListener();
        notifier.addLayersModelEventListener(listener);
        TriggeredEventTraces traces = listener.traces;
        StackedLayerOperator layerOp1 = LayersFactory.eINSTANCE.createStackedLayerOperator();
        layersStack.setLayers((LayerExpression)layerOp1);
        Layer layer1 = LayersFactory.eINSTANCE.createLayer();
        layerOp1.getLayers().add((Object)layer1);
        traces.clear();
        Layer layer2 = LayersFactory.eINSTANCE.createLayer();
        layersStack.setLayers((LayerExpression)layer2);
        Assert.assertTrue((String)"event recorded", (boolean)traces.contains("layerSet"));
        Assert.assertEquals((String)"one event recorded", (long)1L, (long)traces.traces.size());
        Assert.assertEquals((String)"one event recorded", (Object)"layerSet", (Object)traces.traces.get((int)0).name);
    }

    @Test
    public void testFireEventWhenLayerIsReplaced() {
        LayersStack layersStack = LayersFactory.eINSTANCE.createLayersStack();
        LayersModelEventNotifier notifier = new LayersModelEventNotifier(layersStack);
        TraceLayersModelEventListener listener = new TraceLayersModelEventListener();
        notifier.addLayersModelEventListener(listener);
        TriggeredEventTraces traces = listener.traces;
        StackedLayerOperator layerOp1 = LayersFactory.eINSTANCE.createStackedLayerOperator();
        layersStack.setLayers((LayerExpression)layerOp1);
        Layer layer1 = LayersFactory.eINSTANCE.createLayer();
        layerOp1.getLayers().add((Object)layer1);
        traces.clear();
        Layer layer2 = LayersFactory.eINSTANCE.createLayer();
        layerOp1.getLayers().set(0, (Object)layer2);
        Assert.assertTrue((String)"event recorded", (boolean)traces.contains("layerSet"));
        Assert.assertEquals((String)"one event recorded", (long)1L, (long)traces.traces.size());
        Assert.assertEquals((String)"one event recorded", (Object)"layerSet", (Object)traces.traces.get((int)0).name);
    }

    @Test
    public void testFireLayerMoved() {
        LayersStack layersStack = LayersFactory.eINSTANCE.createLayersStack();
        LayersModelEventNotifier notifier = new LayersModelEventNotifier(layersStack);
        TraceLayersModelEventListener listener = new TraceLayersModelEventListener();
        notifier.addLayersModelEventListener(listener);
        TriggeredEventTraces traces = listener.traces;
        StackedLayerOperator layerOp1 = LayersFactory.eINSTANCE.createStackedLayerOperator();
        layersStack.setLayers((LayerExpression)layerOp1);
        Layer layer1 = LayersFactory.eINSTANCE.createLayer();
        layerOp1.getLayers().add((Object)layer1);
        Layer layer2 = LayersFactory.eINSTANCE.createLayer();
        layerOp1.getLayers().add((Object)layer2);
        traces.clear();
        EList list = layerOp1.getLayers();
        list.move(0, (Object)layer2);
        Assert.assertTrue((String)"event recorded", (boolean)traces.contains("layerMoved"));
        Assert.assertEquals((String)"one event recorded", (long)1L, (long)traces.traces.size());
        Assert.assertEquals((String)"one event recorded", (Object)"layerMoved", (Object)traces.traces.get((int)0).name);
    }

    @Test
    public void testFireViewAddedToLayer() {
        LayersStack layersStack = LayersFactory.eINSTANCE.createLayersStack();
        LayersModelEventNotifier notifier = new LayersModelEventNotifier(layersStack);
        TraceLayersModelEventListener listener = new TraceLayersModelEventListener();
        notifier.addLayersModelEventListener(listener);
        TriggeredEventTraces traces = listener.traces;
        StackedLayerOperator layerOp1 = LayersFactory.eINSTANCE.createStackedLayerOperator();
        layersStack.setLayers((LayerExpression)layerOp1);
        Layer layer1 = LayersFactory.eINSTANCE.createLayer();
        layerOp1.getLayers().add((Object)layer1);
        Layer layer2 = LayersFactory.eINSTANCE.createLayer();
        layerOp1.getLayers().add((Object)layer2);
        traces.clear();
        Shape view1 = NotationFactory.eINSTANCE.createShape();
        layer1.getViews().add((Object)view1);
        Assert.assertEquals((String)"one event recorded", (long)1L, (long)traces.traces.size());
        Assert.assertEquals((String)"one event recorded", (Object)"viewAddedToLayer", (Object)traces.traces.get((int)0).name);
        Assert.assertTrue((String)"event recorded", (boolean)traces.contains("viewAddedToLayer"));
        traces.clear();
        Shape view2 = NotationFactory.eINSTANCE.createShape();
        layer2.getViews().add((Object)view2);
        Assert.assertEquals((String)"one event recorded", (long)1L, (long)traces.traces.size());
        Assert.assertEquals((String)"one event recorded", (Object)"viewAddedToLayer", (Object)traces.traces.get((int)0).name);
        Assert.assertTrue((String)"event recorded", (boolean)traces.contains("viewAddedToLayer"));
        traces.clear();
        layer2.getViews().add((Object)view1);
        Assert.assertEquals((String)"one event recorded", (long)1L, (long)traces.traces.size());
        Assert.assertEquals((String)"one event recorded", (Object)"viewAddedToLayer", (Object)traces.traces.get((int)0).name);
        Assert.assertTrue((String)"event recorded", (boolean)traces.contains("viewAddedToLayer"));
    }

    @Test
    public void testFireViewRemovedFromLayer() {
        LayersStack layersStack = LayersFactory.eINSTANCE.createLayersStack();
        LayersModelEventNotifier notifier = new LayersModelEventNotifier(layersStack);
        TraceLayersModelEventListener listener = new TraceLayersModelEventListener();
        notifier.addLayersModelEventListener(listener);
        TriggeredEventTraces traces = listener.traces;
        StackedLayerOperator layerOp1 = LayersFactory.eINSTANCE.createStackedLayerOperator();
        layersStack.setLayers((LayerExpression)layerOp1);
        Layer layer1 = LayersFactory.eINSTANCE.createLayer();
        layerOp1.getLayers().add((Object)layer1);
        Layer layer2 = LayersFactory.eINSTANCE.createLayer();
        layerOp1.getLayers().add((Object)layer2);
        Shape view1 = NotationFactory.eINSTANCE.createShape();
        layer1.getViews().add((Object)view1);
        traces.clear();
        layer1.getViews().remove((Object)view1);
        Assert.assertEquals((String)"one event recorded", (long)1L, (long)traces.traces.size());
        Assert.assertEquals((String)"one event recorded", (Object)"viewRemovedFromLayer", (Object)traces.traces.get((int)0).name);
        Assert.assertTrue((String)"event recorded", (boolean)traces.contains("viewRemovedFromLayer"));
    }

    @Test
    @Ignore
    public void testFireViewMovedBetweenLayer() {
        Assert.fail((String)"Not yet implemented");
    }
}

