/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.layers.runtime;

import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.layers.runtime.Activator;
import org.eclipse.papyrus.layers.runtime.ILayersModelEventListener;
import org.eclipse.papyrus.layers.runtime.LayersModelEventNotifier;
import org.eclipse.papyrus.layers.runtime.LayersModelEventUtils;
import org.eclipse.papyrus.layers.stackmodel.BadStateException;
import org.eclipse.papyrus.layers.stackmodel.LayersException;
import org.eclipse.papyrus.layers.stackmodel.NotFoundException;
import org.eclipse.papyrus.layers.stackmodel.command.ComputePropertyValueCommand;
import org.eclipse.papyrus.layers.stackmodel.layers.AbstractLayer;
import org.eclipse.papyrus.layers.stackmodel.layers.LayersPackage;
import org.eclipse.papyrus.layers.stackmodel.layers.LayersStack;
import org.eclipse.papyrus.layers.stackmodel.layers.LayersStackApplication;
import org.eclipse.papyrus.layers.stackmodel.layers.Property;
import org.eclipse.papyrus.layers.stackmodel.layers.PropertySetter;
import org.eclipse.papyrus.layers.stackmodel.layers.TypeInstance;
import org.eclipse.papyrus.layers.stackmodel.notifier.DiagramViewEventNotifier;
import org.eclipse.papyrus.layers.stackmodel.notifier.IDiagramViewEventListener;

public class LayerStackSynchronizer
implements IDiagramViewEventListener,
ILayersModelEventListener {
    protected Diagram diagram;
    protected LayersStack layersStack;
    protected LayersStackApplication application;
    protected LayersModelEventNotifier layersModelEventNotifier;
    protected DiagramViewEventNotifier diagramViewEventNotifier;

    public LayerStackSynchronizer(LayersStack layersStack) {
        this.diagram = layersStack.getDiagram();
        this.layersStack = layersStack;
        this.application = (LayersStackApplication)layersStack.eContainer();
        this.activate();
    }

    public Diagram getDiagram() {
        return this.diagram;
    }

    public LayersStack getLayersStack() {
        return this.layersStack;
    }

    protected void activate() {
        this.diagramViewEventNotifier = new DiagramViewEventNotifier(this.diagram);
        this.diagramViewEventNotifier.addEventListener((IDiagramViewEventListener)this);
        this.layersModelEventNotifier = new LayersModelEventNotifier(this.layersStack);
        this.layersModelEventNotifier.addLayersModelEventListener(this);
    }

    protected void deactivate() {
        this.diagramViewEventNotifier.removeEventListener((IDiagramViewEventListener)this);
        this.diagramViewEventNotifier = null;
        this.layersModelEventNotifier.removeLayersModelEventListener(this);
        this.layersModelEventNotifier = null;
    }

    protected void dispose() {
        this.deactivate();
        this.diagramViewEventNotifier = null;
        this.layersModelEventNotifier = null;
    }

    protected boolean isDisposed() {
        return this.diagramViewEventNotifier == null;
    }

    protected void checkApplication() throws BadStateException {
        if (this.application == null) {
            throw new BadStateException("Attempt to call a method requireing the 'application object, but the Application object is not set. You must provide a LayerStack contained in its Application.");
        }
    }

    @Override
    public void propertyValueAdded(Notification notification) {
        if (Activator.log.isDebugEnabled()) {
            Activator.log.debug(String.valueOf(this.getClass().getSimpleName()) + ".propertyValueAdded " + notification.getNewValue());
        }
        Object setter = null;
        try {
            String propertyName = LayersModelEventUtils.PropertyEvents.getPropertyNameFromValueAdd(notification);
            AbstractLayer layer = LayersModelEventUtils.PropertyEvents.getAbstractLayer(notification);
            EList views = layer.getViews();
            if (views.size() == 0) {
                return;
            }
            this.checkApplication();
            Property property = this.application.getPropertyRegistry().getProperty(propertyName);
            EList commands = this.layersStack.getViewsComputePropertyValueCommand((List)views, property);
            setter = this.application.getPropertySetterRegistry().getPropertySetter(property);
            int i = 0;
            while (i < views.size()) {
                if (commands != null && commands.get(i) != null) {
                    setter.setValue((View)views.get(i), ((ComputePropertyValueCommand)commands.get(i)).getCmdValue());
                } else {
                    Activator.log.info(String.valueOf(this.getClass().getSimpleName()) + "ERROR - a cmd is null " + commands);
                }
                ++i;
            }
        }
        catch (NotFoundException e) {
            Activator.log.error((Throwable)e);
        }
        catch (LayersException e) {
            Activator.log.error((Throwable)e);
        }
        catch (UnsupportedOperationException e) {
            throw new UnsupportedOperationException("setter='" + setter.getClass().getName() + "'", e);
        }
    }

    @Override
    public void propertyValueRemoved(Notification notification) {
        if (Activator.log.isDebugEnabled()) {
            Activator.log.debug(String.valueOf(this.getClass().getSimpleName()) + ".propertyValueRemoved " + notification.getOldValue());
        }
        try {
            String propertyName = LayersModelEventUtils.PropertyEvents.getPropertyNameFromValueRemove(notification);
            AbstractLayer layer = LayersModelEventUtils.PropertyEvents.getAbstractLayer(notification);
            EList views = layer.getViews();
            if (views.size() == 0) {
                return;
            }
            this.checkApplication();
            Property property = this.application.getPropertyRegistry().getProperty(propertyName);
            EList commands = this.layersStack.getViewsComputePropertyValueCommand((List)views, property);
            if (commands == null) {
                return;
            }
            PropertySetter setter = this.application.getPropertySetterRegistry().getPropertySetter(property);
            int i = 0;
            while (i < views.size()) {
                TypeInstance cmd = ((ComputePropertyValueCommand)commands.get(i)).getCmdValue();
                if (cmd != null) {
                    setter.setValue((View)views.get(i), cmd.getCmdValue());
                }
                ++i;
            }
        }
        catch (NotFoundException e) {
            Activator.log.error((Throwable)e);
        }
        catch (LayersException e) {
            Activator.log.error((Throwable)e);
        }
    }

    @Override
    public void propertyValueChanged(Notification notification) {
        if (Activator.log.isDebugEnabled()) {
            Activator.log.debug(String.valueOf(this.getClass().getSimpleName()) + ".propertyValueChanged " + notification.getNewValue());
        }
        if (notification.getFeature() == LayersPackage.eINSTANCE.getLayerExpression_IsLayerEnabled()) {
            this.propertyValueChangedIsLayerEnabled(notification);
            return;
        }
        try {
            String propertyName = LayersModelEventUtils.PropertyEvents.getPropertyNameFromValueSet(notification);
            AbstractLayer layer = LayersModelEventUtils.PropertyEvents.getAbstractLayer(notification);
            EList views = layer.getViews();
            if (views.size() == 0) {
                return;
            }
            this.checkApplication();
            Property property = this.application.getPropertyRegistry().getProperty(propertyName);
            EList commands = this.layersStack.getViewsComputePropertyValueCommand((List)views, property);
            if (commands == null) {
                return;
            }
            PropertySetter setter = this.application.getPropertySetterRegistry().getPropertySetter(property);
            int i = 0;
            while (i < views.size()) {
                ComputePropertyValueCommand getValueCmd = (ComputePropertyValueCommand)commands.get(i);
                if (getValueCmd != null) {
                    setter.setValue((View)views.get(i), getValueCmd.getCmdValue());
                }
                ++i;
            }
        }
        catch (NotFoundException e) {
            Activator.log.error((Throwable)e);
        }
        catch (LayersException e) {
            Activator.log.error((Throwable)e);
        }
    }

    private void propertyValueChangedIsLayerEnabled(Notification notification) {
        if (Activator.log.isDebugEnabled()) {
            Activator.log.debug(String.valueOf(this.getClass().getSimpleName()) + ".propertyValueChangedIsLayerEnabled " + notification.getNewValue());
        }
        try {
            this.checkApplication();
            AbstractLayer layer = (AbstractLayer)notification.getNotifier();
            this.recomputePropertiesForAllViewsOf(layer);
        }
        catch (NotFoundException e) {
            Activator.log.error((Throwable)e);
        }
        catch (LayersException e) {
            Activator.log.error((Throwable)e);
        }
    }

    private void recompute(List<View> views, List<Property> properties) throws LayersException {
        for (View view : views) {
            this.recompute(view, properties);
        }
    }

    private void recompute(View view, List<Property> properties) throws LayersException {
        EList commands = this.layersStack.getPropertiesComputePropertyValueCommand(view, properties);
        if (commands == null) {
            return;
        }
        int i = 0;
        while (i < commands.size()) {
            try {
                Property property = properties.get(i);
                PropertySetter setter = this.application.getPropertySetterRegistry().getPropertySetter(property);
                ComputePropertyValueCommand getterCmd = (ComputePropertyValueCommand)commands.get(i);
                if (getterCmd != null) {
                    setter.setValue(view, getterCmd.getCmdValue());
                }
            }
            catch (NotFoundException e) {
                Activator.log.error((Throwable)e);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            ++i;
        }
    }

    @Override
    public void layerAdded(Notification notification) {
        if (Activator.log.isDebugEnabled()) {
            Activator.log.debug(String.valueOf(this.getClass().getSimpleName()) + ".layerAdded() " + notification.getNewValue());
        }
        if (!(notification.getNewValue() instanceof AbstractLayer)) {
            Activator.log.info("TODO: " + this.getClass().getSimpleName() + ".layerAdded() " + notification.getOldValue() + " - recompute for LayerOperator not implemented yet.");
            return;
        }
        AbstractLayer layer = (AbstractLayer)notification.getNewValue();
        try {
            this.checkApplication();
            this.recomputePropertiesForAllViewsOf(layer);
        }
        catch (LayersException e) {
            Activator.log.error((Throwable)e);
        }
    }

    @Override
    public void layerRemoved(Notification notification) {
        if (Activator.log.isDebugEnabled()) {
            Activator.log.debug(String.valueOf(this.getClass().getSimpleName()) + " layerRemoved() " + notification.getOldValue());
        }
        if (!(notification.getOldValue() instanceof AbstractLayer)) {
            Activator.log.info("TODO: " + this.getClass().getSimpleName() + ".layerRemoved() " + notification.getOldValue() + " - recompute() after removing layerOperator not implemented yet.");
            return;
        }
        AbstractLayer layer = (AbstractLayer)notification.getOldValue();
        try {
            this.checkApplication();
            this.recomputePropertiesForAllViewsOf(layer);
        }
        catch (LayersException e) {
            Activator.log.error((Throwable)e);
        }
    }

    private void recomputePropertiesForAllViewsOf(AbstractLayer layer) throws LayersException {
        EList properties = layer.getAttachedProperties();
        EList views = layer.getViews();
        if (views.size() == 0) {
            return;
        }
        this.recompute((List<View>)views, (List<Property>)properties);
    }

    @Override
    public void layerMoved(Notification notification) {
        if (Activator.log.isDebugEnabled()) {
            Activator.log.debug(String.valueOf(this.getClass().getSimpleName()) + " layerMoved(not tested) " + notification.getNewValue());
        }
        AbstractLayer layer = (AbstractLayer)notification.getNewValue();
        try {
            this.checkApplication();
            this.recomputePropertiesForAllViewsOf(layer);
        }
        catch (LayersException e) {
            Activator.log.error((Throwable)e);
        }
    }

    @Override
    public void layerSet(Notification notification) {
        Activator.log.info(String.valueOf(this.getClass().getSimpleName()) + " layerSet(not implemented) " + notification.getNewValue());
    }

    @Override
    public void viewAddedToLayer(Notification notification) {
        if (Activator.log.isDebugEnabled()) {
            Activator.log.debug(String.valueOf(this.getClass().getSimpleName()) + " viewAddedToLayer( " + notification.getNewValue() + " )");
        }
        try {
            AbstractLayer layer = LayersModelEventUtils.PropertyEvents.getAbstractLayer(notification);
            View view = LayersModelEventUtils.ViewEvents.getViewAdded(notification);
            this.checkApplication();
            EList properties = layer.getAttachedProperties();
            EList commands = this.layersStack.getPropertiesComputePropertyValueCommand(view, (List)properties);
            if (commands == null) {
                return;
            }
            int i = 0;
            while (i < commands.size()) {
                try {
                    Property property = (Property)properties.get(i);
                    PropertySetter setter = this.application.getPropertySetterRegistry().getPropertySetter(property);
                    setter.setValue(view, ((ComputePropertyValueCommand)commands.get(i)).getCmdValue());
                }
                catch (NotFoundException e) {
                    Activator.log.error("No setter found", (Throwable)e);
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                ++i;
            }
        }
        catch (LayersException e) {
            Activator.log.error((Throwable)e);
        }
    }

    @Override
    public void multiViewsAddedToLayer(Notification notification) {
        if (Activator.log.isDebugEnabled()) {
            Activator.log.debug(String.valueOf(this.getClass().getSimpleName()) + ".multiViewsAddedToLayer( " + notification.getNewValue() + " )");
        }
        try {
            AbstractLayer layer = LayersModelEventUtils.PropertyEvents.getAbstractLayer(notification);
            List<View> views = LayersModelEventUtils.ViewEvents.getViewsAdded(notification);
            this.checkApplication();
            EList properties = layer.getAttachedProperties();
            this.recompute(views, (List<Property>)properties);
        }
        catch (LayersException e) {
            Activator.log.error((Throwable)e);
        }
    }

    @Override
    public void viewRemovedFromLayer(Notification notification) {
        if (Activator.log.isDebugEnabled()) {
            Activator.log.debug(String.valueOf(this.getClass().getSimpleName()) + " viewRemovedFromLayer( " + notification.getOldValue() + " )");
        }
        try {
            AbstractLayer layer = LayersModelEventUtils.PropertyEvents.getAbstractLayer(notification);
            View view = LayersModelEventUtils.ViewEvents.getViewRemoved(notification);
            this.checkApplication();
            EList properties = layer.getAttachedProperties();
            EList commands = this.layersStack.getPropertiesComputePropertyValueCommand(view, (List)properties);
            if (commands == null) {
                return;
            }
            int i = 0;
            while (i < commands.size()) {
                try {
                    Property property = (Property)properties.get(i);
                    PropertySetter setter = this.application.getPropertySetterRegistry().getPropertySetter(property);
                    setter.setValue(view, ((ComputePropertyValueCommand)commands.get(i)).getCmdValue());
                }
                catch (NotFoundException e) {
                    Activator.log.error("No setter found", (Throwable)e);
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                ++i;
            }
        }
        catch (LayersException e) {
            Activator.log.error((Throwable)e);
        }
    }

    @Override
    public void multiViewsRemovedFromLayer(Notification notification) {
        if (Activator.log.isDebugEnabled()) {
            Activator.log.debug(String.valueOf(this.getClass().getSimpleName()) + " multiViewsRemovedFromLayer( " + notification.getOldValue() + " )");
        }
        try {
            AbstractLayer layer = LayersModelEventUtils.PropertyEvents.getAbstractLayer(notification);
            List<View> views = LayersModelEventUtils.ViewEvents.getViewsRemoved(notification);
            this.checkApplication();
            EList properties = layer.getAttachedProperties();
            this.recompute(views, (List<Property>)properties);
        }
        catch (LayersException e) {
            Activator.log.error((Throwable)e);
        }
    }

    @Override
    public void viewMovedBetweenLayer(Notification notification) {
        Activator.log.info(String.valueOf(this.getClass().getSimpleName()) + " viewMovedBetweenLayer(not implemented) " + notification.getNewValue());
    }

    public void diagramViewAdded(Notification msg) {
        Activator.log.info(String.valueOf(this.getClass().getSimpleName()) + " diagramViewAdded(not implemented) " + msg.getNewValue());
    }

    public void diagramViewRemoved(Notification msg) {
        Activator.log.info(String.valueOf(this.getClass().getSimpleName()) + " diagramViewRemoved(not implemented) " + msg.getOldValue());
    }
}

