/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.layers.runtime;

import org.eclipse.emf.common.util.URI;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.papyrus.infra.core.resource.IModel;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.gmfdiag.common.model.NotationModel;
import org.eclipse.papyrus.layers.runtime.LayerStackApplicationSynchronizer;
import org.eclipse.papyrus.layers.runtime.NotationDiagramHelper;
import org.eclipse.papyrus.layers.runtime.model.LayersModel;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LayerStackApplicationSynchronizerTest {
    protected static final String PROJECT_MODEL_URI = "org.eclipse.papyrus.infra.core/tmp/model1.di";
    protected ModelSet modelSet;

    @Before
    public void setUp() throws Exception {
        ModelSet mngr = new ModelSet();
        LayersModel layersModel = new LayersModel();
        mngr.registerModel((IModel)layersModel);
        NotationModel notationModel = new NotationModel();
        mngr.registerModel((IModel)notationModel);
        URI uri = URI.createPlatformResourceURI((String)PROJECT_MODEL_URI, (boolean)true);
        mngr.createModels(uri);
        this.modelSet = mngr;
    }

    @After
    public void tearDown() throws Exception {
        this.modelSet.unload();
    }

    @Test
    public void testModelSetCreation() {
        NotationModel notationModel = (NotationModel)this.modelSet.getModel("org.eclipse.papyrus.infra.core.resource.notation.NotationModel");
        Assert.assertNotNull((String)"NotationModel is created", (Object)notationModel);
        notationModel.addDiagram(NotationFactory.eINSTANCE.createDiagram());
        Assert.assertNotNull((String)"Diagram is in the roots", (Object)notationModel.getResource().getContents().get(0));
        LayersModel layersModel = (LayersModel)this.modelSet.getModel("org.eclipse.papyrus.layers.runtime.model.LayersModel");
        Assert.assertNotNull((String)"LayerModel is created", (Object)((Object)layersModel));
        Assert.assertNotNull((String)"LayerStackApplication is created", (Object)layersModel.getLayerStackApplication());
    }

    @Test
    public void testLayerStackApplicationSynchronizer() {
        NotationModel notationModel = (NotationModel)this.modelSet.getModel("org.eclipse.papyrus.infra.core.resource.notation.NotationModel");
        LayersModel layersModel = (LayersModel)this.modelSet.getModel("org.eclipse.papyrus.layers.runtime.model.LayersModel");
        LayerStackApplicationSynchronizer synchronizer = new LayerStackApplicationSynchronizer(layersModel, notationModel);
        Assert.assertNotNull((String)"application created", (Object)synchronizer);
        synchronizer.dispose();
    }

    @Test
    public void testGetLayersModel() {
        NotationModel notationModel = (NotationModel)this.modelSet.getModel("org.eclipse.papyrus.infra.core.resource.notation.NotationModel");
        LayersModel layersModel = (LayersModel)this.modelSet.getModel("org.eclipse.papyrus.layers.runtime.model.LayersModel");
        LayerStackApplicationSynchronizer synchronizer = new LayerStackApplicationSynchronizer(layersModel, notationModel);
        Assert.assertNotNull((String)"layers model exist", (Object)((Object)synchronizer.getLayersModel()));
        Assert.assertSame((String)"right layer model", (Object)((Object)layersModel), (Object)((Object)synchronizer.getLayersModel()));
        synchronizer.dispose();
    }

    @Test
    public void testGetNotationModel() {
        NotationModel notationModel = (NotationModel)this.modelSet.getModel("org.eclipse.papyrus.infra.core.resource.notation.NotationModel");
        LayersModel layersModel = (LayersModel)this.modelSet.getModel("org.eclipse.papyrus.layers.runtime.model.LayersModel");
        LayerStackApplicationSynchronizer synchronizer = new LayerStackApplicationSynchronizer(layersModel, notationModel);
        Assert.assertNotNull((String)"layers model exist", (Object)synchronizer.getNotationModel());
        Assert.assertSame((String)"right layer model", (Object)notationModel, (Object)synchronizer.getNotationModel());
        synchronizer.dispose();
    }

    @Test
    public void testDispose() {
        NotationModel notationModel = (NotationModel)this.modelSet.getModel("org.eclipse.papyrus.infra.core.resource.notation.NotationModel");
        LayersModel layersModel = (LayersModel)this.modelSet.getModel("org.eclipse.papyrus.layers.runtime.model.LayersModel");
        LayerStackApplicationSynchronizer synchronizer = new LayerStackApplicationSynchronizer(layersModel, notationModel);
        Assert.assertNotNull((String)"application created", (Object)((Object)synchronizer.getLayersModel()));
        Assert.assertFalse((String)"object is disposed", (boolean)synchronizer.isDisposed());
        synchronizer.dispose();
        Assert.assertTrue((String)"object is disposed", (boolean)synchronizer.isDisposed());
    }

    @Test
    public void testLayerStackAdded() {
        NotationModel notationModel = (NotationModel)this.modelSet.getModel("org.eclipse.papyrus.infra.core.resource.notation.NotationModel");
        LayersModel layersModel = (LayersModel)this.modelSet.getModel("org.eclipse.papyrus.layers.runtime.model.LayersModel");
        Diagram diagram = NotationFactory.eINSTANCE.createDiagram();
        notationModel.addDiagram(diagram);
        NotationDiagramHelper helper = new NotationDiagramHelper(layersModel, diagram);
        LayerStackApplicationSynchronizer synchronizer = new LayerStackApplicationSynchronizer(layersModel, notationModel);
        Assert.assertNotNull((String)"application created", (Object)synchronizer);
        helper.attachLayersStack();
        Assert.assertNotNull((String)"LayerStackSynchronizer added", (Object)synchronizer.getSynchronizers().get(diagram));
        synchronizer.dispose();
    }

    @Test
    public void testLayerStackRemoved() {
        NotationModel notationModel = (NotationModel)this.modelSet.getModel("org.eclipse.papyrus.infra.core.resource.notation.NotationModel");
        LayersModel layersModel = (LayersModel)this.modelSet.getModel("org.eclipse.papyrus.layers.runtime.model.LayersModel");
        Diagram diagram = NotationFactory.eINSTANCE.createDiagram();
        notationModel.addDiagram(diagram);
        NotationDiagramHelper helper = new NotationDiagramHelper(layersModel, diagram);
        LayerStackApplicationSynchronizer synchronizer = new LayerStackApplicationSynchronizer(layersModel, notationModel);
        Assert.assertNotNull((String)"application created", (Object)synchronizer);
        helper.attachLayersStack();
        Assert.assertNotNull((String)"LayerStackSynchronizer added", (Object)synchronizer.getSynchronizers().get(diagram));
        helper.removeLayersStack();
        Assert.assertNull((String)"LayerStackSynchronizer removed", (Object)synchronizer.getSynchronizers().get(diagram));
        synchronizer.dispose();
    }

    @Test
    public void testDiagramRemoved() {
        NotationModel notationModel = (NotationModel)this.modelSet.getModel("org.eclipse.papyrus.infra.core.resource.notation.NotationModel");
        LayersModel layersModel = (LayersModel)this.modelSet.getModel("org.eclipse.papyrus.layers.runtime.model.LayersModel");
        Diagram diagram = NotationFactory.eINSTANCE.createDiagram();
        notationModel.addDiagram(diagram);
        NotationDiagramHelper helper = new NotationDiagramHelper(layersModel, diagram);
        LayerStackApplicationSynchronizer synchronizer = new LayerStackApplicationSynchronizer(layersModel, notationModel);
        Assert.assertNotNull((String)"application created", (Object)synchronizer);
        helper.attachLayersStack();
        Assert.assertNotNull((String)"LayerStackSynchronizer added", (Object)synchronizer.getSynchronizers().get(diagram));
        notationModel.getResource().getContents().remove((Object)diagram);
        Assert.assertNull((String)"LayerStackSynchronizer removed", (Object)synchronizer.getSynchronizers().get(diagram));
        synchronizer.dispose();
    }

    @Test
    public void testLayerStackApplicationSynchronizerRestartSynchronizer() {
        NotationModel notationModel = (NotationModel)this.modelSet.getModel("org.eclipse.papyrus.infra.core.resource.notation.NotationModel");
        LayersModel layersModel = (LayersModel)this.modelSet.getModel("org.eclipse.papyrus.layers.runtime.model.LayersModel");
        Diagram diagram = NotationFactory.eINSTANCE.createDiagram();
        notationModel.addDiagram(diagram);
        NotationDiagramHelper helper = new NotationDiagramHelper(layersModel, diagram);
        helper.attachLayersStack();
        LayerStackApplicationSynchronizer synchronizer = new LayerStackApplicationSynchronizer(layersModel, notationModel);
        Assert.assertNotNull((String)"application created", (Object)synchronizer);
        Assert.assertNotNull((String)"LayerStackSynchronizer created", (Object)synchronizer.getSynchronizers().get(diagram));
        Diagram diagram2 = NotationFactory.eINSTANCE.createDiagram();
        notationModel.addDiagram(diagram2);
        NotationDiagramHelper helper2 = new NotationDiagramHelper(layersModel, diagram2);
        helper2.attachLayersStack();
        Assert.assertNotNull((String)"LayerStackSynchronizer created", (Object)synchronizer.getSynchronizers().get(diagram2));
        synchronizer.dispose();
    }

    @Test
    public void testLayerStackApplicationSynchronizerStartWithNoApplicationInModel() {
        NotationModel notationModel = (NotationModel)this.modelSet.getModel("org.eclipse.papyrus.infra.core.resource.notation.NotationModel");
        LayersModel layersModel = (LayersModel)this.modelSet.getModel("org.eclipse.papyrus.layers.runtime.model.LayersModel");
        LayerStackApplicationSynchronizer synchronizer = new LayerStackApplicationSynchronizer(layersModel, notationModel);
        Assert.assertNotNull((String)"application created", (Object)synchronizer);
        Assert.assertNull((String)"Application is not created in model", (Object)layersModel.lookupLayerStackApplication());
        Diagram diagram = NotationFactory.eINSTANCE.createDiagram();
        notationModel.addDiagram(diagram);
        NotationDiagramHelper helper = new NotationDiagramHelper(layersModel, diagram);
        helper.attachLayersStack();
        Assert.assertNotNull((String)"LayerStackSynchronizer created", (Object)synchronizer.getSynchronizers().get(diagram));
        Assert.assertNotNull((String)"Application is created in model", (Object)layersModel.lookupLayerStackApplication());
        synchronizer.dispose();
    }
}

