/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.base.ui.wizards;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.presentation.EcoreActionBarContributor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.emf.validation.validity.ui.ripoffs.ResourceAndContainerGroup;
import org.eclipse.ocl.examples.xtext.base.ui.Activator;
import org.eclipse.ocl.examples.xtext.base.ui.messages.BaseUIMessages;
import org.eclipse.ocl.examples.xtext.base.ui.wizards.AbstractFileNewWizard;
import org.eclipse.ocl.examples.xtext.base.ui.wizards.AbstractFileNewWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractFileDialog
extends EcoreActionBarContributor.ExtendedLoadResourceAction.ExtendedLoadResourceDialog {
    private static final int SIZING_CONTAINER_GROUP_HEIGHT = 120;
    public static final String PREFIX = "org.eclipse.ocl.examples.xtext.base.ui.";
    private static final String NEW_FILE_WIZARD_PAGE = "org.eclipse.ocl.examples.xtext.base.ui." + BaseUIMessages.NewWizardPage_newFileWizardContextId;
    @Nullable
    protected final IResource initialSelection;
    private AbstractFileNewWizardPage wizardPage;
    @NonNull
    protected final AbstractFileNewWizard wizard;
    @Nullable
    private ResourceAndContainerGroup resourceGroup;

    public AbstractFileDialog(@NonNull AbstractFileNewWizard wizard, @NonNull AbstractFileNewWizardPage wizardPage, @Nullable IResource initialSelection) {
        super(wizardPage.getShell(), null);
        this.initialSelection = initialSelection;
        this.wizardPage = wizardPage;
        this.wizard = wizard;
    }

    public Composite createDialogArea(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite topLevel = new Composite(parent, 0);
        topLevel.setLayout((Layout)new GridLayout());
        topLevel.setLayoutData((Object)new GridData(272));
        topLevel.setFont(parent.getFont());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)topLevel, NEW_FILE_WIZARD_PAGE);
        this.resourceGroup = this.createResourceAndContainerArea(topLevel);
        this.createMetamodelsArea(topLevel);
        this.initSelection(this.initialSelection);
        return topLevel;
    }

    protected void createMetamodelsArea(Composite topLevel) {
        super.createDialogArea(topLevel);
    }

    @Nullable
    protected ResourceAndContainerGroup createResourceAndContainerArea(Composite parent) {
        ResourceAndContainerGroup resourceGroup = new ResourceAndContainerGroup(parent, (Listener)this.wizardPage, this.wizard.getNewFileLabel(), BaseUIMessages.NewWizardPage_file, false, 120);
        resourceGroup.setAllowExistingResources(false);
        resourceGroup.setResourceExtension(this.wizard.getNewFileExtension());
        return resourceGroup;
    }

    public String getFileName() {
        return this.getGroup().getResource();
    }

    @NonNull
    protected ResourceAndContainerGroup getGroup() {
        ResourceAndContainerGroup resourceGroup2 = this.resourceGroup;
        assert (resourceGroup2 != null);
        return resourceGroup2;
    }

    public IFile getNewFile() {
        IPath newFilePath = this.getNewFilePath();
        return Activator.getPluginWorkspace().getRoot().getFile(newFilePath);
    }

    public IPath getNewFilePath() {
        ResourceAndContainerGroup group = this.getGroup();
        IPath containerPath = group.getContainerFullPath();
        return containerPath.append(group.getResource());
    }

    public Shell getShell() {
        return this.wizard.getShell();
    }

    public void initSelection(IResource initialSelection) {
        ResourceAndContainerGroup resourceGroup2 = this.resourceGroup;
        if (resourceGroup2 != null) {
            IResource resourceSelection2 = initialSelection;
            if (resourceSelection2 instanceof IFile) {
                IPath fullPath = resourceSelection2.getFullPath();
                if (this.uriField != null) {
                    URI uri = URI.createPlatformResourceURI((String)fullPath.toString(), (boolean)true);
                    this.uriField.setText(uri.toString());
                }
                IPath removeFileExtension = fullPath.removeFileExtension();
                IPath addFileExtension = removeFileExtension.addFileExtension(this.wizard.getNewFileExtension());
                resourceGroup2.setResource(addFileExtension.lastSegment());
            } else {
                resourceGroup2.setResource(this.wizard.getNewFileName());
            }
            if (resourceSelection2 != null) {
                this.initialPopulateContainerNameField(resourceSelection2);
            }
        }
    }

    private void initialPopulateContainerNameField(@NonNull IResource resourceSelection) {
        ResourceAndContainerGroup resourceGroup2 = this.getGroup();
        if (resourceSelection.getType() == 1) {
            resourceSelection = resourceSelection.getParent();
        }
        if (resourceSelection.isAccessible()) {
            resourceGroup2.setContainerFullPath(resourceSelection.getFullPath());
        }
    }

    protected boolean isFilteredByParent() {
        ResourceAndContainerGroup group = this.getGroup();
        IPath containerPath = group.getContainerFullPath();
        if (containerPath == null) {
            return false;
        }
        String resourceName = group.getResource();
        if (resourceName == null) {
            return false;
        }
        if (resourceName.length() > 0) {
            IFile newFileHandle = this.getNewFile();
            IWorkspace workspace = newFileHandle.getWorkspace();
            return !workspace.validateFiltered((IResource)newFileHandle).isOK();
        }
        return false;
    }

    public boolean isURIFieldValid() {
        return this.uriField == null || this.uriField.getText() != "";
    }

    public boolean validateGroup() {
        boolean valid = true;
        ResourceAndContainerGroup group = this.getGroup();
        if (!group.areAllValuesValid()) {
            int problemType = group.getProblemType();
            String problemMessage = group.getProblemMessage();
            if (problemType == 1 || problemType == 5) {
                this.wizardPage.setMessage(problemMessage);
                this.wizardPage.setErrorMessage(null);
            } else {
                this.wizardPage.setErrorMessage(problemMessage);
            }
            valid = false;
        }
        String resourceName = group.getResource();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IStatus result = workspace.validateName(resourceName, 1);
        if (!result.isOK()) {
            this.wizardPage.setErrorMessage(result.getMessage());
            return false;
        }
        if (group.getAllowExistingResources()) {
            String problemMessage = NLS.bind((String)BaseUIMessages.NewWizardPage_nameExists, (Object)this.getFileName());
            IPath resourcePath = group.getContainerFullPath().append(this.getFileName());
            IWorkspaceRoot root = workspace.getRoot();
            if (root.getFolder(resourcePath).exists()) {
                this.wizardPage.setErrorMessage(problemMessage);
                valid = false;
            }
            if (root.getFile(resourcePath).exists()) {
                this.wizardPage.setMessage(problemMessage, 2);
            }
        }
        if (this.isFilteredByParent()) {
            this.wizardPage.setMessage(BaseUIMessages.NewWizardPage_resourceWillBeFilteredWarning, 3);
            valid = false;
        }
        return valid;
    }
}

