/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ecore.extender.tool.internal;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.UnmodifiableIterator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.sirius.ecore.extender.business.api.permission.IPermissionAuthority;
import org.eclipse.sirius.ecore.extender.business.api.permission.PermissionAuthorityRegistry;
import org.eclipse.sirius.ext.emf.EReferencePredicate;

public class ReferencesResolver {
    private Predicate<EReference> filter;
    private ResourceSet set;

    public ReferencesResolver(ResourceSet set, final EReferencePredicate filter) {
        this.filter = new Predicate<EReference>(){

            public boolean apply(EReference input) {
                return filter.apply(input);
            }
        };
        this.set = set;
    }

    public void resolve(IProgressMonitor monitor) {
        IPermissionAuthority authority = PermissionAuthorityRegistry.getDefault().getPermissionAuthority(this.set);
        List<Resource> cachedIdsResources = ReferencesResolver.prepareResolveAll(this.set, authority);
        monitor.beginTask("Resolving non contained references", this.set.getResources().size());
        for (Resource res : Lists.newArrayList((Iterable)this.set.getResources())) {
            this.doResolveAll(res);
            monitor.worked(1);
        }
        monitor.done();
        ReferencesResolver.unprepareResolveAll(authority, cachedIdsResources);
    }

    private void doResolveAll(Resource resource) {
        TreeIterator i = resource.getAllContents();
        while (i.hasNext()) {
            EObject eObject = (EObject)i.next();
            this.resolveCrossReferences(eObject);
        }
    }

    private void resolveCrossReferences(EObject eObject) {
        UnmodifiableIterator it = Iterators.filter((Iterator)eObject.eClass().getEAllReferences().iterator(), this.filter);
        while (it.hasNext()) {
            eObject.eGet((EStructuralFeature)it.next());
        }
    }

    public static List<Resource> prepareResolveAll(ResourceSet set, IPermissionAuthority authority) {
        if (authority != null) {
            authority.setListening(false);
        }
        LinkedList<Resource> cachedIdsResources = new LinkedList<Resource>();
        for (Resource resource : set.getResources()) {
            if (!(resource instanceof ResourceImpl) || ((ResourceImpl)resource).getIntrinsicIDToEObjectMap() != null) continue;
            ((ResourceImpl)resource).setIntrinsicIDToEObjectMap(new HashMap());
            cachedIdsResources.add(resource);
        }
        return cachedIdsResources;
    }

    public static void unprepareResolveAll(IPermissionAuthority authority, List<Resource> cachedIdsResources) {
        for (Resource resource : cachedIdsResources) {
            if (!(resource instanceof ResourceImpl) || ((ResourceImpl)resource).getIntrinsicIDToEObjectMap() == null) continue;
            ((ResourceImpl)resource).setIntrinsicIDToEObjectMap(null);
        }
        if (authority != null) {
            authority.setListening(true);
        }
    }
}

