/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ecore.extender.business.internal.permission;

import java.util.Collection;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.ecore.extender.business.api.permission.LockStatus;
import org.eclipse.sirius.ecore.extender.business.internal.permission.AbstractPermissionAuthority;

public class ReadOnlyPermissionAuthority
extends AbstractPermissionAuthority {
    private boolean activation;

    public void activate() {
        this.activation = true;
    }

    protected boolean isReadOnly() {
        return this.activation;
    }

    private void notify(boolean approval, EObject obj) {
        if (approval) {
            if (this.isLocked(obj)) {
                this.releaseFromLockedAndNotify(obj);
            }
        } else if (!this.isLocked(obj)) {
            this.storeAsLockedAndNotify(obj);
        }
    }

    protected boolean checkApproval(EObject eObject) {
        boolean approval = !this.isReadOnly();
        this.notify(approval, eObject);
        return approval;
    }

    @Override
    public boolean canCreateIn(EObject obj) {
        return this.checkApproval(obj);
    }

    @Override
    public boolean canDeleteInstance(EObject target) {
        return this.checkApproval(target);
    }

    @Override
    public boolean canEditFeature(EObject obj, String featureName) {
        return this.checkApproval(obj);
    }

    @Override
    public boolean canEditInstance(EObject obj) {
        return this.checkApproval(obj);
    }

    @Override
    public void setReportIssues(boolean report) {
    }

    @Override
    public void notifyInstanceChange(EObject instance) {
    }

    @Override
    public void notifyInstanceDeletion(EObject instance) {
    }

    @Override
    public void notifyNewInstanceCreation(EObject instance) {
    }

    @Override
    public void notifyLock(Collection<? extends EObject> elements) {
    }

    @Override
    public void notifyUnlock(Collection<? extends EObject> elements) {
    }

    @Override
    public LockStatus getLockStatus(EObject element) {
        return this.canEditInstance(element) ? LockStatus.NOT_LOCKED : LockStatus.LOCKED_BY_OTHER;
    }
}

