/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.viewport;

import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.coordinate.PixelCoordinate;
import org.eclipse.nebula.widgets.nattable.coordinate.Range;
import org.eclipse.nebula.widgets.nattable.grid.command.ClientAreaResizeCommand;
import org.eclipse.nebula.widgets.nattable.layer.AbstractLayerTransform;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEventHandler;
import org.eclipse.nebula.widgets.nattable.layer.event.IStructuralChangeEvent;
import org.eclipse.nebula.widgets.nattable.print.command.PrintEntireGridCommand;
import org.eclipse.nebula.widgets.nattable.print.command.TurnViewportOffCommand;
import org.eclipse.nebula.widgets.nattable.print.command.TurnViewportOnCommand;
import org.eclipse.nebula.widgets.nattable.resize.event.ColumnResizeEvent;
import org.eclipse.nebula.widgets.nattable.resize.event.RowResizeEvent;
import org.eclipse.nebula.widgets.nattable.selection.ScrollSelectionCommandHandler;
import org.eclipse.nebula.widgets.nattable.selection.command.MoveSelectionCommand;
import org.eclipse.nebula.widgets.nattable.selection.command.ScrollSelectionCommand;
import org.eclipse.nebula.widgets.nattable.selection.event.CellSelectionEvent;
import org.eclipse.nebula.widgets.nattable.selection.event.ColumnSelectionEvent;
import org.eclipse.nebula.widgets.nattable.selection.event.RowSelectionEvent;
import org.eclipse.nebula.widgets.nattable.viewport.HorizontalScrollBarHandler;
import org.eclipse.nebula.widgets.nattable.viewport.IScroller;
import org.eclipse.nebula.widgets.nattable.viewport.ScrollBarScroller;
import org.eclipse.nebula.widgets.nattable.viewport.VerticalScrollBarHandler;
import org.eclipse.nebula.widgets.nattable.viewport.command.RecalculateScrollBarsCommandHandler;
import org.eclipse.nebula.widgets.nattable.viewport.command.ShowCellInViewportCommandHandler;
import org.eclipse.nebula.widgets.nattable.viewport.command.ShowColumnInViewportCommandHandler;
import org.eclipse.nebula.widgets.nattable.viewport.command.ShowRowInViewportCommandHandler;
import org.eclipse.nebula.widgets.nattable.viewport.command.ViewportDragCommandHandler;
import org.eclipse.nebula.widgets.nattable.viewport.command.ViewportSelectColumnCommandHandler;
import org.eclipse.nebula.widgets.nattable.viewport.command.ViewportSelectRowCommandHandler;
import org.eclipse.nebula.widgets.nattable.viewport.event.ScrollEvent;
import org.eclipse.nebula.widgets.nattable.viewport.event.ViewportEventHandler;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Scrollable;

public class ViewportLayer
extends AbstractLayerTransform
implements IUniqueIndexLayer {
    private static final int EDGE_HOVER_REGION_SIZE = 12;
    private HorizontalScrollBarHandler hBarListener;
    private VerticalScrollBarHandler vBarListener;
    private final IUniqueIndexLayer scrollableLayer;
    private IScroller<?> horizontalScroller;
    private IScroller<?> verticalScroller;
    private boolean horizontalScrollbarEnabled = true;
    private boolean verticalScrollbarEnabled = true;
    private PixelCoordinate origin = new PixelCoordinate(0, 0);
    private PixelCoordinate minimumOrigin = new PixelCoordinate(0, 0);
    private int minimumOriginColumnPosition = 0;
    private int minimumOriginRowPosition = 0;
    private boolean viewportOff = false;
    private PixelCoordinate savedOrigin = new PixelCoordinate(0, 0);
    private int maxColumnPosition = -1;
    private int minColumnPosition = -1;
    private int maxRowPosition = -1;
    private int minRowPosition = -1;
    private int cachedColumnCount = -1;
    private int cachedRowCount = -1;
    private int cachedClientAreaWidth = 0;
    private int cachedClientAreaHeight = 0;
    private int cachedWidth = -1;
    private int cachedHeight = -1;
    private MoveViewportRunnable edgeHoverRunnable;
    private ILayerEventHandler<RowResizeEvent> resizeEventHandler;
    boolean processingClientAreaResizeCommand = false;

    public ViewportLayer(IUniqueIndexLayer underlyingLayer) {
        super(underlyingLayer);
        this.scrollableLayer = underlyingLayer;
        this.registerCommandHandlers();
        this.registerEventHandler(new ViewportEventHandler(this));
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.hBarListener != null) {
            this.hBarListener.dispose();
        }
        if (this.vBarListener != null) {
            this.vBarListener.dispose();
        }
        this.cancelEdgeHoverScroll();
    }

    public void setHorizontalScroller(IScroller<?> scroller) {
        this.horizontalScroller = scroller;
    }

    public void setVerticalScroller(IScroller<?> scroller) {
        this.verticalScroller = scroller;
    }

    public int getMaxWidth() {
        if (this.getMaxColumnPosition() < 0) {
            return -1;
        }
        int maxWidth = 0;
        int i = 0;
        while (i < this.getMaxColumnPosition()) {
            maxWidth += this.scrollableLayer.getColumnWidthByPosition(i);
            ++i;
        }
        return maxWidth;
    }

    public int getMinVerticalStart() {
        if (this.getMinColumnPosition() < 0) {
            return -1;
        }
        int minStart = 0;
        int i = 0;
        while (i < this.getMinColumnPosition()) {
            minStart += this.scrollableLayer.getColumnWidthByPosition(i);
            ++i;
        }
        return minStart;
    }

    public int getMaxHeight() {
        if (this.getMaxRowPosition() < 0) {
            return -1;
        }
        int maxHeight = 0;
        int i = 0;
        while (i < this.getMaxRowPosition()) {
            maxHeight += this.getRowHeightByPosition(i);
            ++i;
        }
        return maxHeight;
    }

    public int getMinHorizontalStart() {
        if (this.getMinRowPosition() < 0) {
            return -1;
        }
        int minStart = 0;
        int i = 0;
        while (i < this.getMinRowPosition()) {
            minStart += this.getRowHeightByPosition(i);
            ++i;
        }
        return minStart;
    }

    public PixelCoordinate getMinimumOrigin() {
        return this.minimumOrigin;
    }

    public int getMinimumOriginColumnPosition() {
        return this.minimumOriginColumnPosition;
    }

    public int getMinimumOriginRowPosition() {
        return this.minimumOriginRowPosition;
    }

    public void setMinimumOriginX(int newMinimumOriginX) {
        if (newMinimumOriginX >= 0) {
            int minStart = this.getMinVerticalStart();
            if (newMinimumOriginX < minStart) {
                newMinimumOriginX = minStart;
            }
            PixelCoordinate previousMinimumOrigin = this.minimumOrigin;
            if (newMinimumOriginX != this.minimumOrigin.getX()) {
                this.minimumOrigin = new PixelCoordinate(newMinimumOriginX, this.minimumOrigin.getY());
                this.minimumOriginColumnPosition = this.scrollableLayer.getColumnPositionByX(this.minimumOrigin.getX());
            }
            int delta = this.minimumOrigin.getX() - previousMinimumOrigin.getX();
            this.setOriginX(this.origin.getX() + delta);
            this.recalculateHorizontalScrollBar();
        }
    }

    public void setMinimumOriginY(int newMinimumOriginY) {
        if (newMinimumOriginY >= 0) {
            int minStart = this.getMinHorizontalStart();
            if (newMinimumOriginY < minStart) {
                newMinimumOriginY = minStart;
            }
            PixelCoordinate previousMinimumOrigin = this.minimumOrigin;
            if (newMinimumOriginY != this.minimumOrigin.getY()) {
                this.minimumOrigin = new PixelCoordinate(this.minimumOrigin.getX(), newMinimumOriginY);
                this.minimumOriginRowPosition = this.scrollableLayer.getRowPositionByY(this.minimumOrigin.getY());
            }
            int delta = this.minimumOrigin.getY() - previousMinimumOrigin.getY();
            this.setOriginY(this.origin.getY() + delta);
            this.recalculateVerticalScrollBar();
        }
    }

    public void setMinimumOrigin(int newMinimumOriginX, int newMinimumOriginY) {
        this.setMinimumOriginX(newMinimumOriginX);
        this.setMinimumOriginY(newMinimumOriginY);
    }

    public PixelCoordinate getOrigin() {
        return this.viewportOff ? this.minimumOrigin : this.origin;
    }

    private int getOriginColumnPosition() {
        return this.scrollableLayer.getColumnPositionByX(this.getOrigin().getX());
    }

    private int getOriginRowPosition() {
        return this.scrollableLayer.getRowPositionByY(this.getOrigin().getY());
    }

    private int boundsCheckOriginX(int x) {
        int min = this.minimumOrigin.getX();
        if (x <= min) {
            return min;
        }
        int max = Math.max(this.getUnderlyingLayer().getStartXOfColumnPosition(0) + this.getUnderlyingLayer().getWidth(), min);
        if (x > max) {
            return max;
        }
        return x;
    }

    private int boundsCheckOriginY(int y) {
        int min = this.minimumOrigin.getY();
        if (y <= min) {
            return min;
        }
        int max = Math.max(this.getUnderlyingLayer().getStartYOfRowPosition(0) + this.getUnderlyingLayer().getHeight(), min);
        if (y > max) {
            return max;
        }
        return y;
    }

    public void setOriginX(int newOriginX) {
        newOriginX = this.boundsCheckOriginX(newOriginX);
        if ((newOriginX = this.boundsCheckOriginX(this.adjustOriginX(newOriginX))) != this.origin.getX()) {
            this.invalidateHorizontalStructure();
            this.origin = new PixelCoordinate(newOriginX, this.origin.getY());
            this.fireScrollEvent();
        }
    }

    public void setOriginY(int newOriginY) {
        newOriginY = this.boundsCheckOriginY(newOriginY);
        if ((newOriginY = this.boundsCheckOriginY(this.adjustOriginY(newOriginY))) != this.origin.getY()) {
            this.invalidateVerticalStructure();
            this.origin = new PixelCoordinate(this.origin.getX(), newOriginY);
            this.fireScrollEvent();
        }
    }

    public void resetOrigin(int newOriginX, int newOriginY) {
        PixelCoordinate previousOrigin = this.origin;
        this.minimumOrigin = new PixelCoordinate(0, 0);
        this.minimumOriginColumnPosition = 0;
        this.minimumOriginRowPosition = 0;
        this.origin = new PixelCoordinate(newOriginX, newOriginY);
        if (this.origin.getX() != previousOrigin.getX()) {
            this.invalidateHorizontalStructure();
        }
        if (this.origin.getY() != previousOrigin.getY()) {
            this.invalidateVerticalStructure();
        }
    }

    public int getMaxColumnPosition() {
        return this.maxColumnPosition;
    }

    public void setMaxColumnPosition(int maxColumnPosition) {
        this.maxColumnPosition = maxColumnPosition;
    }

    public int getMinColumnPosition() {
        return this.minColumnPosition;
    }

    public void setMinColumnPosition(int minColumnPosition) {
        this.minColumnPosition = minColumnPosition;
        int newMinOriginX = this.scrollableLayer.getStartXOfColumnPosition(this.minColumnPosition);
        this.setMinimumOriginX(newMinOriginX);
    }

    public int getMaxRowPosition() {
        return this.maxRowPosition;
    }

    public void setMaxRowPosition(int maxRowPosition) {
        this.maxRowPosition = maxRowPosition;
    }

    public int getMinRowPosition() {
        return this.minRowPosition;
    }

    public void setMinRowPosition(int minRowPosition) {
        this.minRowPosition = minRowPosition;
        int newMinOriginY = this.scrollableLayer.getStartYOfRowPosition(this.minRowPosition);
        this.setMinimumOriginY(newMinOriginY);
    }

    @Override
    protected void registerCommandHandlers() {
        this.registerCommandHandler(new RecalculateScrollBarsCommandHandler(this));
        this.registerCommandHandler(new ScrollSelectionCommandHandler(this));
        this.registerCommandHandler(new ShowCellInViewportCommandHandler(this));
        this.registerCommandHandler(new ShowColumnInViewportCommandHandler(this));
        this.registerCommandHandler(new ShowRowInViewportCommandHandler(this));
        this.registerCommandHandler(new ViewportSelectColumnCommandHandler(this));
        this.registerCommandHandler(new ViewportSelectRowCommandHandler(this));
        this.registerCommandHandler(new ViewportDragCommandHandler(this));
    }

    @Override
    public int getColumnCount() {
        int availableWidth;
        if (this.viewportOff) {
            if (this.getMaxColumnPosition() >= 0) {
                return this.getMaxColumnPosition();
            }
            if (this.getMinColumnPosition() >= 0) {
                return Math.max(this.scrollableLayer.getColumnCount() - this.getMinColumnPosition(), 0);
            }
            return Math.max(this.scrollableLayer.getColumnCount() - this.getMinimumOriginColumnPosition(), 0);
        }
        if (this.cachedColumnCount < 0 && (availableWidth = this.getClientAreaWidth()) >= 0) {
            if (this.origin.getX() < this.minimumOrigin.getX()) {
                this.origin = new PixelCoordinate(this.minimumOrigin.getX(), this.origin.getY());
            }
            this.recalculateAvailableWidthAndColumnCount();
        }
        return this.cachedColumnCount;
    }

    @Override
    public int getColumnPositionByIndex(int columnIndex) {
        return this.scrollableLayer.getColumnPositionByIndex(columnIndex) - this.getOriginColumnPosition();
    }

    @Override
    public int localToUnderlyingColumnPosition(int localColumnPosition) {
        int underlyingPosition = this.getOriginColumnPosition() + localColumnPosition;
        if (underlyingPosition < this.getMinimumOriginColumnPosition()) {
            return -1;
        }
        return underlyingPosition;
    }

    @Override
    public int underlyingToLocalColumnPosition(ILayer sourceUnderlyingLayer, int underlyingColumnPosition) {
        if (sourceUnderlyingLayer != this.getUnderlyingLayer()) {
            return -1;
        }
        return underlyingColumnPosition - this.getOriginColumnPosition();
    }

    @Override
    public int getWidth() {
        if (this.viewportOff) {
            int width = this.scrollableLayer.getWidth() - this.scrollableLayer.getStartXOfColumnPosition(this.getMinimumOriginColumnPosition());
            if (this.getMaxColumnPosition() >= 0) {
                int maxWidth = this.getMaxWidth();
                if (maxWidth < width) {
                    return maxWidth;
                }
            } else {
                return width;
            }
        }
        if (this.cachedWidth < 0) {
            this.recalculateAvailableWidthAndColumnCount();
        }
        return this.cachedWidth;
    }

    @Override
    public int getColumnWidthByPosition(int columnPosition) {
        int width = super.getColumnWidthByPosition(columnPosition);
        return width;
    }

    @Override
    public boolean isColumnPositionResizable(int columnPosition) {
        return this.getUnderlyingLayer().isColumnPositionResizable(this.getOriginColumnPosition() + columnPosition);
    }

    @Override
    public int getColumnPositionByX(int x) {
        return this.getUnderlyingLayer().getColumnPositionByX(this.getOrigin().getX() + x) - this.getOriginColumnPosition();
    }

    @Override
    public int getStartXOfColumnPosition(int columnPosition) {
        return this.getUnderlyingLayer().getStartXOfColumnPosition(this.getOriginColumnPosition() + columnPosition) - this.getOrigin().getX();
    }

    @Override
    public int getRowCount() {
        int availableHeight;
        if (this.viewportOff) {
            if (this.getMaxRowPosition() >= 0) {
                return this.getMaxRowPosition();
            }
            if (this.getMinRowPosition() >= 0) {
                return Math.max(this.scrollableLayer.getRowCount() - this.getMinRowPosition(), 0);
            }
            return Math.max(this.scrollableLayer.getRowCount() - this.getMinimumOriginRowPosition(), 0);
        }
        if (this.cachedRowCount < 0 && (availableHeight = this.getClientAreaHeight()) >= 0) {
            if (this.origin.getY() < this.minimumOrigin.getY()) {
                this.origin = new PixelCoordinate(this.origin.getX(), this.minimumOrigin.getY());
            }
            this.recalculateAvailableHeightAndRowCount();
        }
        return this.cachedRowCount;
    }

    @Override
    public int getRowPositionByIndex(int rowIndex) {
        return this.scrollableLayer.getRowPositionByIndex(rowIndex) - this.getOriginRowPosition();
    }

    @Override
    public int localToUnderlyingRowPosition(int localRowPosition) {
        int underlyingPosition = this.getOriginRowPosition() + localRowPosition;
        if (underlyingPosition < this.getMinimumOriginRowPosition()) {
            return -1;
        }
        return underlyingPosition;
    }

    @Override
    public int underlyingToLocalRowPosition(ILayer sourceUnderlyingLayer, int underlyingRowPosition) {
        if (sourceUnderlyingLayer != this.getUnderlyingLayer()) {
            return -1;
        }
        return underlyingRowPosition - this.getOriginRowPosition();
    }

    @Override
    public int getHeight() {
        if (this.viewportOff) {
            int height = this.scrollableLayer.getHeight() - this.scrollableLayer.getStartYOfRowPosition(this.getMinimumOriginRowPosition());
            if (this.getMaxRowPosition() >= 0) {
                int maxHeight = this.getMaxHeight();
                if (maxHeight < height) {
                    return maxHeight;
                }
            } else {
                return height;
            }
        }
        if (this.cachedHeight < 0) {
            this.recalculateAvailableHeightAndRowCount();
        }
        return this.cachedHeight;
    }

    @Override
    public int getRowHeightByPosition(int rowPosition) {
        int height = super.getRowHeightByPosition(rowPosition);
        return height;
    }

    @Override
    public int getRowPositionByY(int y) {
        return this.getUnderlyingLayer().getRowPositionByY(this.getOrigin().getY() + y) - this.getOriginRowPosition();
    }

    @Override
    public int getStartYOfRowPosition(int rowPosition) {
        return this.getUnderlyingLayer().getStartYOfRowPosition(this.getOriginRowPosition() + rowPosition) - this.getOrigin().getY();
    }

    @Override
    public Rectangle getBoundsByPosition(int columnPosition, int rowPosition) {
        int underlyingColumnPosition = this.localToUnderlyingColumnPosition(columnPosition);
        int underlyingRowPosition = this.localToUnderlyingRowPosition(rowPosition);
        Rectangle bounds = this.getUnderlyingLayer().getBoundsByPosition(underlyingColumnPosition, underlyingRowPosition);
        bounds.x -= this.getOrigin().getX();
        bounds.y -= this.getOrigin().getY();
        return bounds;
    }

    public void invalidateHorizontalStructure() {
        this.cachedColumnCount = -1;
        this.cachedClientAreaWidth = 0;
        this.cachedWidth = -1;
    }

    public void invalidateVerticalStructure() {
        this.cachedRowCount = -1;
        this.cachedClientAreaHeight = 0;
        this.cachedHeight = -1;
    }

    protected void recalculateAvailableWidthAndColumnCount() {
        int checkedOriginX;
        int clientAreaWidth;
        int availableWidth = clientAreaWidth = this.getMaxColumnPosition() >= 0 ? Math.min(this.getMaxWidth(), this.getClientAreaWidth()) : this.getClientAreaWidth();
        int originColumnPosition = this.getOriginColumnPosition();
        if (originColumnPosition >= 0) {
            availableWidth += this.getOrigin().getX() - this.getUnderlyingLayer().getStartXOfColumnPosition(originColumnPosition);
        }
        int maxColumnCount = this.getMaxColumnPosition() < 0 ? this.getUnderlyingLayer().getColumnCount() : this.getMaxColumnPosition();
        this.cachedWidth = 0;
        this.cachedColumnCount = 0;
        int columnPosition = originColumnPosition;
        while (columnPosition >= 0 && columnPosition < maxColumnCount && availableWidth > 0) {
            int width = this.getUnderlyingLayer().getColumnWidthByPosition(columnPosition);
            availableWidth -= width;
            this.cachedWidth += width;
            ++this.cachedColumnCount;
            ++columnPosition;
        }
        if (this.cachedWidth > clientAreaWidth) {
            this.cachedWidth = clientAreaWidth;
        }
        if ((checkedOriginX = this.boundsCheckOriginX(this.origin.getX())) != this.origin.getX()) {
            this.origin = new PixelCoordinate(checkedOriginX, this.origin.getY());
        }
    }

    protected void recalculateAvailableHeightAndRowCount() {
        int checkedOriginY;
        int clientAreaHeight;
        int availableHeight = clientAreaHeight = this.getMaxRowPosition() >= 0 ? Math.min(this.getMaxHeight(), this.getClientAreaHeight()) : this.getClientAreaHeight();
        int originRowPosition = this.getOriginRowPosition();
        if (originRowPosition >= 0) {
            availableHeight += this.getOrigin().getY() - this.getUnderlyingLayer().getStartYOfRowPosition(originRowPosition);
        }
        int maxRowCount = this.getMaxRowPosition() < 0 ? this.getUnderlyingLayer().getRowCount() : this.getMaxRowPosition();
        this.cachedHeight = 0;
        this.cachedRowCount = 0;
        int rowPosition = originRowPosition;
        while (rowPosition >= 0 && rowPosition < maxRowCount && availableHeight > 0) {
            int height = this.getUnderlyingLayer().getRowHeightByPosition(rowPosition);
            availableHeight -= height;
            this.cachedHeight += height;
            ++this.cachedRowCount;
            ++rowPosition;
        }
        if (this.cachedHeight > clientAreaHeight) {
            this.cachedHeight = clientAreaHeight;
        }
        if ((checkedOriginY = this.boundsCheckOriginY(this.origin.getY())) != this.origin.getY()) {
            this.origin = new PixelCoordinate(this.origin.getX(), checkedOriginY);
        }
    }

    public void moveCellPositionIntoViewport(int scrollableColumnPosition, int scrollableRowPosition) {
        this.moveColumnPositionIntoViewport(scrollableColumnPosition);
        this.moveRowPositionIntoViewport(scrollableRowPosition);
    }

    public void moveColumnPositionIntoViewport(int scrollableColumnPosition) {
        ILayer underlyingLayer = this.getUnderlyingLayer();
        int maxWidth = this.getMaxWidth();
        if (underlyingLayer.getColumnIndexByPosition(scrollableColumnPosition) >= 0 && (maxWidth < 0 || maxWidth >= 0 && underlyingLayer.getStartXOfColumnPosition(scrollableColumnPosition) < maxWidth) && scrollableColumnPosition >= this.getMinimumOriginColumnPosition()) {
            int originColumnPosition = this.getOriginColumnPosition();
            if (scrollableColumnPosition <= originColumnPosition) {
                this.setOriginX(this.scrollableLayer.getStartXOfColumnPosition(scrollableColumnPosition));
            } else {
                int maxX;
                int scrollableColumnStartX = underlyingLayer.getStartXOfColumnPosition(scrollableColumnPosition);
                int scrollableColumnEndX = scrollableColumnStartX + underlyingLayer.getColumnWidthByPosition(scrollableColumnPosition);
                int clientAreaWidth = this.getClientAreaWidth();
                int viewportEndX = this.getOrigin().getX() + clientAreaWidth;
                int n = maxX = maxWidth >= 0 ? Math.min(maxWidth, scrollableColumnEndX) : scrollableColumnEndX;
                if (viewportEndX < maxX) {
                    this.setOriginX(Math.min(maxX - clientAreaWidth, maxX));
                }
            }
            this.adjustHorizontalScrollBar();
        }
    }

    public void moveRowPositionIntoViewport(int scrollableRowPosition) {
        ILayer underlyingLayer = this.getUnderlyingLayer();
        int maxHeight = this.getMaxHeight();
        if (underlyingLayer.getRowIndexByPosition(scrollableRowPosition) >= 0 && (maxHeight < 0 || maxHeight >= 0 && underlyingLayer.getStartYOfRowPosition(scrollableRowPosition) < maxHeight) && scrollableRowPosition >= this.getMinimumOriginRowPosition()) {
            int originRowPosition = this.getOriginRowPosition();
            if (scrollableRowPosition <= originRowPosition) {
                this.setOriginY(this.scrollableLayer.getStartYOfRowPosition(scrollableRowPosition));
            } else {
                int maxY;
                int scrollableRowStartY = underlyingLayer.getStartYOfRowPosition(scrollableRowPosition);
                int scrollableRowEndY = scrollableRowStartY + underlyingLayer.getRowHeightByPosition(scrollableRowPosition);
                int clientAreaHeight = this.getClientAreaHeight();
                int viewportEndY = this.getOrigin().getY() + clientAreaHeight;
                int n = maxY = maxHeight >= 0 ? Math.min(maxHeight, scrollableRowEndY) : scrollableRowEndY;
                if (viewportEndY < maxY) {
                    this.setOriginY(Math.min(maxY - clientAreaHeight, maxY));
                }
            }
            this.adjustVerticalScrollBar();
            if (this.resizeEventHandler == null) {
                this.resizeEventHandler = new KeepRowInsideViewportEventHandler(scrollableRowPosition);
                this.registerEventHandler(this.resizeEventHandler);
                Display.getCurrent().timerExec(100, new Runnable(){

                    @Override
                    public void run() {
                        ViewportLayer.this.unregisterEventHandler(ViewportLayer.this.resizeEventHandler);
                        ViewportLayer.this.resizeEventHandler = null;
                    }
                });
            }
        }
    }

    protected void fireScrollEvent() {
        this.fireLayerEvent(new ScrollEvent(this));
    }

    @Override
    public boolean doCommand(ILayerCommand command) {
        if (command instanceof ClientAreaResizeCommand && command.convertToTargetLayer(this)) {
            if (this.processingClientAreaResizeCommand) {
                return false;
            }
            this.processingClientAreaResizeCommand = true;
            ClientAreaResizeCommand clientAreaResizeCommand = (ClientAreaResizeCommand)command;
            Scrollable scrollable = clientAreaResizeCommand.getScrollable();
            Rectangle clientArea = scrollable.getClientArea();
            Rectangle calcArea = clientAreaResizeCommand.getCalcArea();
            int widthDiff = clientArea.width - calcArea.width;
            int heightDiff = clientArea.height - calcArea.height;
            if (this.hBarListener == null && this.horizontalScrollbarEnabled) {
                ScrollBar hBar = scrollable.getHorizontalBar();
                if (this.horizontalScroller != null && this.horizontalScroller.getUnderlying() != hBar) {
                    hBar.setEnabled(false);
                    hBar.setVisible(false);
                } else {
                    this.horizontalScroller = new ScrollBarScroller(hBar);
                }
                this.hBarListener = new HorizontalScrollBarHandler(this, this.horizontalScroller);
                if (scrollable instanceof NatTable) {
                    this.hBarListener.setTable((NatTable)scrollable);
                }
            }
            if (this.vBarListener == null && this.verticalScrollbarEnabled) {
                ScrollBar vBar = scrollable.getVerticalBar();
                if (this.verticalScroller != null && this.verticalScroller.getUnderlying() != vBar) {
                    vBar.setEnabled(false);
                    vBar.setVisible(false);
                } else {
                    this.verticalScroller = new ScrollBarScroller(vBar);
                }
                this.vBarListener = new VerticalScrollBarHandler(this, this.verticalScroller);
                if (scrollable instanceof NatTable) {
                    this.vBarListener.setTable((NatTable)scrollable);
                }
            }
            this.handleGridResize();
            Rectangle possibleArea = clientArea;
            possibleArea.width -= widthDiff;
            possibleArea.height -= heightDiff;
            clientAreaResizeCommand.setCalcArea(possibleArea);
            this.processingClientAreaResizeCommand = false;
        } else {
            if (command instanceof TurnViewportOffCommand) {
                this.savedOrigin = this.origin;
                this.viewportOff = true;
                return true;
            }
            if (command instanceof TurnViewportOnCommand) {
                this.viewportOff = false;
                this.origin = this.savedOrigin;
                this.recalculateScrollBars();
                return true;
            }
            if (command instanceof PrintEntireGridCommand) {
                this.moveCellPositionIntoViewport(0, 0);
            }
        }
        return super.doCommand(command);
    }

    private void recalculateHorizontalScrollBar() {
        if (this.hBarListener != null) {
            this.hBarListener.recalculateScrollBarSize();
            if (!this.hBarListener.scroller.getEnabled()) {
                this.setOriginX(this.minimumOrigin.getX());
            } else {
                this.setOriginX(this.origin.getX());
            }
        }
    }

    private void recalculateVerticalScrollBar() {
        if (this.vBarListener != null) {
            this.vBarListener.recalculateScrollBarSize();
            if (!this.vBarListener.scroller.getEnabled()) {
                this.setOriginY(this.minimumOrigin.getY());
            } else {
                this.setOriginY(this.origin.getY());
            }
        }
    }

    public void recalculateScrollBars() {
        this.recalculateHorizontalScrollBar();
        this.recalculateVerticalScrollBar();
    }

    protected void handleGridResize() {
        this.setOriginX(this.origin.getX());
        this.recalculateHorizontalScrollBar();
        this.setOriginY(this.origin.getY());
        this.recalculateVerticalScrollBar();
    }

    protected int adjustOriginX(int originX) {
        if (this.getColumnCount() == 0) {
            return 0;
        }
        int availableWidth = this.getClientAreaWidth() - (this.scrollableLayer.getWidth() - originX);
        if (availableWidth <= 0) {
            int visibleWidth;
            int clientAreaWidth = this.getClientAreaWidth();
            if (this.getMaxColumnPosition() >= 0 && clientAreaWidth >= this.getWidth() && (visibleWidth = this.calculateVisibleWidth(originX)) < clientAreaWidth) {
                originX -= clientAreaWidth - visibleWidth;
            }
            return originX;
        }
        return this.boundsCheckOriginX(originX - availableWidth);
    }

    private int calculateVisibleWidth(int originX) {
        int partialVisibleColumnWidth;
        int visibleWidth = partialVisibleColumnWidth = this.getUnderlyingLayer().getStartXOfColumnPosition(this.getOriginColumnPosition() + 1) - originX;
        int i = this.getOriginColumnPosition() + 1;
        while (i < this.getMaxColumnPosition()) {
            visibleWidth += this.getUnderlyingLayer().getColumnWidthByPosition(i);
            ++i;
        }
        return visibleWidth;
    }

    protected int adjustOriginY(int originY) {
        if (this.getRowCount() == 0) {
            return 0;
        }
        int availableHeight = this.getClientAreaHeight() - (this.scrollableLayer.getHeight() - originY);
        if (availableHeight <= 0) {
            int visibleHeight;
            int clientAreaHeight = this.getClientAreaHeight();
            if (this.getMaxRowPosition() >= 0 && clientAreaHeight >= this.getHeight() && (visibleHeight = this.calculateVisibleHeight(originY)) < clientAreaHeight) {
                originY -= clientAreaHeight - visibleHeight;
            }
            return originY;
        }
        return this.boundsCheckOriginY(originY - availableHeight);
    }

    private int calculateVisibleHeight(int originY) {
        int partialVisibleRowHeight;
        int visibleHeight = partialVisibleRowHeight = this.getUnderlyingLayer().getStartYOfRowPosition(this.getOriginRowPosition() + 1) - originY;
        int i = this.getOriginRowPosition() + 1;
        while (i < this.getMaxRowPosition()) {
            visibleHeight += this.getUnderlyingLayer().getRowHeightByPosition(i);
            ++i;
        }
        return visibleHeight;
    }

    public void scrollVerticallyByAPage(ScrollSelectionCommand scrollSelectionCommand) {
        this.getUnderlyingLayer().doCommand(this.scrollVerticallyByAPageCommand(scrollSelectionCommand));
    }

    protected MoveSelectionCommand scrollVerticallyByAPageCommand(ScrollSelectionCommand scrollSelectionCommand) {
        return new MoveSelectionCommand(scrollSelectionCommand.getDirection(), this.getRowCount(), scrollSelectionCommand.isShiftMask(), scrollSelectionCommand.isControlMask());
    }

    protected boolean isLastColumnCompletelyDisplayed() {
        int lastDisplayableColumnIndex = this.getUnderlyingLayer().getColumnIndexByPosition(this.getUnderlyingLayer().getColumnCount() - 1);
        int visibleColumnCount = this.getColumnCount();
        int lastVisibleColumnIndex = this.getColumnIndexByPosition(visibleColumnCount - 1);
        return lastVisibleColumnIndex == lastDisplayableColumnIndex && this.getClientAreaWidth() >= this.getWidth();
    }

    protected boolean isLastRowCompletelyDisplayed() {
        int lastDisplayableRowIndex = this.getUnderlyingLayer().getRowIndexByPosition(this.getUnderlyingLayer().getRowCount() - 1);
        int visibleRowCount = this.getRowCount();
        int lastVisibleRowIndex = this.getRowIndexByPosition(visibleRowCount - 1);
        return lastVisibleRowIndex == lastDisplayableRowIndex && this.getClientAreaHeight() >= this.getHeight();
    }

    @Override
    public void handleLayerEvent(ILayerEvent event) {
        if (event instanceof IStructuralChangeEvent) {
            IStructuralChangeEvent structuralChangeEvent = (IStructuralChangeEvent)event;
            if (structuralChangeEvent.isHorizontalStructureChanged()) {
                this.invalidateHorizontalStructure();
                if (this.viewportOff && (this.getMaxColumnPosition() >= 0 || this.getMinColumnPosition() >= 0) && event instanceof ColumnResizeEvent) {
                    this.correctSavedOriginX();
                }
            }
            if (structuralChangeEvent.isVerticalStructureChanged()) {
                this.invalidateVerticalStructure();
                if (this.viewportOff && (this.getMaxRowPosition() >= 0 || this.getMinRowPosition() >= 0) && event instanceof RowResizeEvent) {
                    this.correctSavedOriginY();
                }
            }
        }
        if (event instanceof CellSelectionEvent) {
            this.processSelection((CellSelectionEvent)event);
        } else if (event instanceof ColumnSelectionEvent) {
            this.processColumnSelection((ColumnSelectionEvent)event);
        } else if (event instanceof RowSelectionEvent) {
            this.processRowSelection((RowSelectionEvent)event);
        }
        super.handleLayerEvent(event);
    }

    private void correctSavedOriginX() {
        int newOriginX = this.savedOrigin.getX();
        int columnPosition = 0;
        if (this.getMinColumnPosition() >= 0) {
            int possibleWidth = 0;
            int col = columnPosition;
            while (col < this.getMinColumnPosition()) {
                possibleWidth += this.scrollableLayer.getColumnWidthByPosition(col);
                ++col;
            }
            if (possibleWidth != this.minimumOrigin.getX()) {
                int delta = this.minimumOrigin.getX() - possibleWidth;
                newOriginX -= delta;
                this.minimumOrigin = new PixelCoordinate(this.minimumOrigin.getX() - delta, this.minimumOrigin.getY());
            }
        } else {
            int clientAreaWidth;
            int originX = this.savedOrigin.getX();
            int visibleWidth = this.calculateVisibleWidth(originX);
            if (visibleWidth < (clientAreaWidth = this.getClientAreaWidth())) {
                int possibleWidth = 0;
                int columnCount = this.getMaxColumnPosition() >= 0 ? this.getMaxColumnPosition() : this.scrollableLayer.getColumnCount();
                int col = columnPosition;
                while (col < columnCount) {
                    possibleWidth += this.scrollableLayer.getColumnWidthByPosition(col);
                    ++col;
                }
                newOriginX = possibleWidth >= clientAreaWidth ? this.scrollableLayer.getStartXOfColumnPosition(columnPosition) : this.scrollableLayer.getWidth() - clientAreaWidth;
                newOriginX = Math.max(0, newOriginX);
            }
        }
        this.savedOrigin = new PixelCoordinate(newOriginX, this.savedOrigin.getY());
    }

    private void correctSavedOriginY() {
        int newOriginY = this.savedOrigin.getY();
        int rowPosition = 0;
        if (this.getMinRowPosition() >= 0) {
            int possibleHeight = 0;
            int row = rowPosition;
            while (row < this.getMinRowPosition()) {
                possibleHeight += this.scrollableLayer.getRowHeightByPosition(row);
                ++row;
            }
            if (possibleHeight != this.minimumOrigin.getY()) {
                int delta = this.minimumOrigin.getY() - possibleHeight;
                newOriginY -= delta;
                this.minimumOrigin = new PixelCoordinate(this.minimumOrigin.getX(), this.minimumOrigin.getY() - delta);
            }
        } else {
            int clientAreaHeight;
            int originY = this.savedOrigin.getY();
            int visibleHeight = this.calculateVisibleHeight(originY);
            if (visibleHeight < (clientAreaHeight = this.getClientAreaHeight())) {
                int possibleHeight = 0;
                int rowCount = this.getMaxRowPosition() >= 0 ? this.getMaxRowPosition() : this.scrollableLayer.getRowCount();
                int row = rowPosition;
                while (row < rowCount) {
                    possibleHeight += this.scrollableLayer.getRowHeightByPosition(row);
                    ++row;
                }
                newOriginY = possibleHeight >= clientAreaHeight ? this.scrollableLayer.getStartYOfRowPosition(rowPosition) : this.scrollableLayer.getHeight() - clientAreaHeight;
                newOriginY = Math.max(0, newOriginY);
            }
        }
        this.savedOrigin = new PixelCoordinate(this.savedOrigin.getX(), newOriginY);
    }

    private void processSelection(CellSelectionEvent selectionEvent) {
        this.moveCellPositionIntoViewport(selectionEvent.getColumnPosition(), selectionEvent.getRowPosition());
        this.adjustHorizontalScrollBar();
        this.adjustVerticalScrollBar();
    }

    private void processColumnSelection(ColumnSelectionEvent selectionEvent) {
        for (Range columnPositionRange : selectionEvent.getColumnPositionRanges()) {
            this.moveColumnPositionIntoViewport(columnPositionRange.end - 1);
            this.adjustHorizontalScrollBar();
        }
    }

    private void processRowSelection(RowSelectionEvent selectionEvent) {
        int rowPositionToMoveIntoViewport = selectionEvent.getRowPositionToMoveIntoViewport();
        if (rowPositionToMoveIntoViewport >= 0) {
            this.moveRowPositionIntoViewport(rowPositionToMoveIntoViewport);
            this.adjustVerticalScrollBar();
        }
    }

    private void adjustHorizontalScrollBar() {
        if (this.hBarListener != null) {
            this.hBarListener.adjustScrollBar();
        }
    }

    private void adjustVerticalScrollBar() {
        if (this.vBarListener != null) {
            this.vBarListener.adjustScrollBar();
        }
    }

    public int getClientAreaWidth() {
        int clientAreaWidth = this.getClientAreaProvider().getClientArea().width;
        if (clientAreaWidth != this.cachedClientAreaWidth) {
            this.invalidateHorizontalStructure();
            this.cachedClientAreaWidth = clientAreaWidth;
        }
        return this.cachedClientAreaWidth;
    }

    public int getClientAreaHeight() {
        int clientAreaHeight = this.getClientAreaProvider().getClientArea().height;
        if (clientAreaHeight != this.cachedClientAreaHeight) {
            this.invalidateVerticalStructure();
            this.cachedClientAreaHeight = clientAreaHeight;
        }
        return this.cachedClientAreaHeight;
    }

    public IUniqueIndexLayer getScrollableLayer() {
        return this.scrollableLayer;
    }

    @Override
    public String toString() {
        return "Viewport Layer";
    }

    public void drag(int x, int y) {
        if (x < 0 && y < 0) {
            this.cancelEdgeHoverScroll();
            return;
        }
        MoveViewportRunnable move = this.edgeHoverRunnable;
        if (move == null) {
            move = new MoveViewportRunnable();
        }
        Rectangle clientArea = this.getClientAreaProvider().getClientArea();
        int change = 0;
        int minX = clientArea.x;
        int maxX = clientArea.x + clientArea.width;
        if (x >= minX && x < minX + 12) {
            change = -1;
        } else if (x >= maxX - 12 && x < maxX) {
            change = 1;
        }
        move.x = change;
        change = 0;
        int minY = clientArea.y;
        int maxY = clientArea.y + clientArea.height;
        if (y >= minY && y < minY + 12) {
            change = -1;
        } else if (y >= maxY - 12 && y < maxY) {
            change = 1;
        }
        move.y = change;
        if (move.x != 0 || move.y != 0) {
            move.schedule();
        } else {
            this.cancelEdgeHoverScroll();
        }
    }

    private void cancelEdgeHoverScroll() {
        this.edgeHoverRunnable = null;
    }

    public void setHorizontalScrollbarEnabled(boolean enabled) {
        this.horizontalScrollbarEnabled = enabled;
    }

    public void setVerticalScrollbarEnabled(boolean enabled) {
        this.verticalScrollbarEnabled = enabled;
    }

    class KeepRowInsideViewportEventHandler
    implements ILayerEventHandler<RowResizeEvent> {
        private final int rowPosition;

        public KeepRowInsideViewportEventHandler(int rowPosition) {
            this.rowPosition = rowPosition;
        }

        @Override
        public void handleLayerEvent(RowResizeEvent event) {
            ViewportLayer.this.moveRowPositionIntoViewport(this.rowPosition);
        }

        @Override
        public Class<RowResizeEvent> getLayerEventClass() {
            return RowResizeEvent.class;
        }
    }

    class MoveViewportRunnable
    implements Runnable {
        private int x;
        private int y;
        private final Display display = Display.getCurrent();

        public void schedule() {
            if (ViewportLayer.this.edgeHoverRunnable != this) {
                ViewportLayer.this.edgeHoverRunnable = this;
                this.display.timerExec(500, (Runnable)this);
            }
        }

        @Override
        public void run() {
            if (ViewportLayer.this.edgeHoverRunnable != this) {
                return;
            }
            if (this.x != 0) {
                ViewportLayer.this.setOriginX(ViewportLayer.this.getUnderlyingLayer().getStartXOfColumnPosition(ViewportLayer.this.getOriginColumnPosition() + this.x));
            }
            if (this.y != 0) {
                ViewportLayer.this.setOriginY(ViewportLayer.this.getUnderlyingLayer().getStartYOfRowPosition(ViewportLayer.this.getOriginRowPosition() + this.y));
            }
            this.display.timerExec(100, (Runnable)this);
        }
    }
}

