/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.util;

import java.net.URL;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class GUIHelper {
    private static final String KEY_PREFIX = String.valueOf(GUIHelper.class.getCanonicalName()) + ".";
    public static final Color COLOR_GRAY = Display.getDefault().getSystemColor(15);
    public static final Color COLOR_WHITE = Display.getDefault().getSystemColor(1);
    public static final Color COLOR_DARK_GRAY = Display.getDefault().getSystemColor(16);
    public static final Color COLOR_BLACK = Display.getDefault().getSystemColor(2);
    public static final Color COLOR_BLUE = Display.getDefault().getSystemColor(9);
    public static final Color COLOR_RED = Display.getDefault().getSystemColor(3);
    public static final Color COLOR_YELLOW = Display.getDefault().getSystemColor(7);
    public static final Color COLOR_GREEN = Display.getDefault().getSystemColor(5);
    public static final Color COLOR_LIST_BACKGROUND = Display.getDefault().getSystemColor(25);
    public static final Color COLOR_LIST_FOREGROUND = Display.getDefault().getSystemColor(24);
    public static final Color COLOR_LIST_SELECTION = Display.getDefault().getSystemColor(26);
    public static final Color COLOR_LIST_SELECTION_TEXT = Display.getDefault().getSystemColor(27);
    public static final Color COLOR_WIDGET_BACKGROUND = Display.getDefault().getSystemColor(22);
    public static final Color COLOR_WIDGET_FOREGROUND = Display.getDefault().getSystemColor(21);
    public static final Color COLOR_TITLE_INACTIVE_BACKGROUND = Display.getDefault().getSystemColor(34);
    public static final Color COLOR_WIDGET_BORDER = Display.getDefault().getSystemColor(23);
    public static final Color COLOR_WIDGET_DARK_SHADOW = Display.getDefault().getSystemColor(17);
    public static final Color COLOR_WIDGET_LIGHT_SHADOW = Display.getDefault().getSystemColor(19);
    public static final Color COLOR_WIDGET_NORMAL_SHADOW = Display.getDefault().getSystemColor(18);
    public static final Color COLOR_WIDGET_HIGHLIGHT_SHADOW = Display.getDefault().getSystemColor(20);
    public static final Font DEFAULT_FONT = Display.getDefault().getSystemFont();
    public static final int DEFAULT_RESIZE_HANDLE_SIZE = 4;
    public static final int DEFAULT_MIN_DISPLAY_SIZE = 5;
    public static final int DEFAULT_ANTIALIAS = -1;
    public static final int DEFAULT_TEXT_ANTIALIAS = -1;
    private static final String[] IMAGE_DIRS = new String[]{"org/eclipse/nebula/widgets/nattable/images/", ""};
    private static final String[] IMAGE_EXTENSIONS = new String[]{".png", ".gif"};
    private static final AtomicLong atomicLong = new AtomicLong(0L);

    public static Color getColor(RGB rgb) {
        return GUIHelper.getColor(rgb.red, rgb.green, rgb.blue);
    }

    public static Color getColor(int red, int green, int blue) {
        String key = GUIHelper.getColorKey(red, green, blue);
        if (JFaceResources.getColorRegistry().hasValueFor(key)) {
            return JFaceResources.getColorRegistry().get(key);
        }
        JFaceResources.getColorRegistry().put(key, new RGB(red, green, blue));
        return GUIHelper.getColor(key);
    }

    public static Color getColor(String key) {
        return JFaceResources.getColorRegistry().get(key);
    }

    private static String getColorKey(int red, int green, int blue) {
        return String.valueOf(KEY_PREFIX) + "_COLOR_" + red + "_" + green + "_" + blue;
    }

    public static Font getFont(FontData ... fontDatas) {
        StringBuilder keyBuilder = new StringBuilder();
        FontData[] fontDataArray = fontDatas;
        int n = fontDatas.length;
        int n2 = 0;
        while (n2 < n) {
            FontData fontData = fontDataArray[n2];
            keyBuilder.append(fontData.toString());
            ++n2;
        }
        String key = keyBuilder.toString();
        if (JFaceResources.getFontRegistry().hasValueFor(key)) {
            return JFaceResources.getFont((String)key);
        }
        JFaceResources.getFontRegistry().put(key, fontDatas);
        return JFaceResources.getFont((String)key);
    }

    public static Font getFont(String key) {
        return JFaceResources.getFont((String)key);
    }

    public static Image getImage(String key) {
        URL imageUrl;
        Image image = JFaceResources.getImage((String)key);
        if (image == null && (imageUrl = GUIHelper.getImageUrl(key)) != null) {
            ImageDescriptor imageDescriptor = ImageDescriptor.createFromURL((URL)imageUrl);
            JFaceResources.getImageRegistry().put(key, imageDescriptor.createImage());
            image = JFaceResources.getImage((String)key);
        }
        return image;
    }

    public static Image getImage(ImageData data) {
        if (JFaceResources.getImage((String)data.toString()) == null) {
            JFaceResources.getImageRegistry().put(data.toString(), ImageDescriptor.createFromImageData((ImageData)data));
        }
        return JFaceResources.getImage((String)data.toString());
    }

    private static URL getImageUrl(String imageName) {
        String[] stringArray = IMAGE_DIRS;
        int n = IMAGE_DIRS.length;
        int n2 = 0;
        while (n2 < n) {
            String dir = stringArray[n2];
            String[] stringArray2 = IMAGE_EXTENSIONS;
            int n3 = IMAGE_EXTENSIONS.length;
            int n4 = 0;
            while (n4 < n3) {
                String ext = stringArray2[n4];
                URL url = GUIHelper.class.getClassLoader().getResource(String.valueOf(dir) + imageName + ext);
                if (url != null) {
                    return url;
                }
                ++n4;
            }
            ++n2;
        }
        return null;
    }

    public static ImageDescriptor getImageDescriptor(String key) {
        ImageDescriptor imageDescriptor = null;
        URL imageUrl = GUIHelper.getImageUrl(key);
        if (imageUrl != null) {
            imageDescriptor = ImageDescriptor.createFromURL((URL)imageUrl);
        }
        return imageDescriptor;
    }

    public static String getSequenceNumber() {
        long id = atomicLong.addAndGet(1L);
        return String.valueOf(id);
    }

    public static RGB blend(RGB val1, RGB val2) {
        int red = GUIHelper.blend(val1.red, val2.red);
        int green = GUIHelper.blend(val1.green, val2.green);
        int blue = GUIHelper.blend(val1.blue, val2.blue);
        return new RGB(red, green, blue);
    }

    private static int blend(int temp1, int temp2) {
        return Math.abs(temp1 - temp2) / 2 + Math.min(temp1, temp2);
    }
}

