/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.selection;

import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.painter.layer.GridLineCellLayerPainter;
import org.eclipse.nebula.widgets.nattable.style.BorderStyle;
import org.eclipse.nebula.widgets.nattable.style.CellStyleAttributes;
import org.eclipse.nebula.widgets.nattable.style.IStyle;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

public class SelectionLayerPainter
extends GridLineCellLayerPainter {
    public SelectionLayerPainter(Color gridColor) {
        super(gridColor);
    }

    public SelectionLayerPainter() {
    }

    public SelectionLayerPainter(Color gridColor, boolean clipLeft, boolean clipTop) {
        super(gridColor, clipLeft, clipTop);
    }

    public SelectionLayerPainter(boolean clipLeft, boolean clipTop) {
        this(GUIHelper.COLOR_GRAY, clipLeft, clipTop);
    }

    @Override
    public void paintLayer(ILayer natLayer, GC gc, int xOffset, int yOffset, Rectangle pixelRectangle, IConfigRegistry configRegistry) {
        Rectangle currentCellBounds;
        ILayerCell afterCell;
        ILayerCell currentCell;
        ILayerCell previousCell;
        Rectangle positionRectangle = this.getPositionRectangleFromPixelRectangle(natLayer, pixelRectangle);
        int columnPositionOffset = positionRectangle.x;
        int rowPositionOffset = positionRectangle.y;
        super.paintLayer(natLayer, gc, xOffset, yOffset, pixelRectangle, configRegistry);
        int originalLineStyle = gc.getLineStyle();
        Color originalForeground = gc.getForeground();
        this.applyBorderStyle(gc, configRegistry);
        int columnPosition = columnPositionOffset;
        while (columnPosition < columnPositionOffset + positionRectangle.width) {
            previousCell = null;
            currentCell = null;
            afterCell = null;
            int rowPosition = rowPositionOffset;
            while (rowPosition < rowPositionOffset + positionRectangle.height) {
                currentCell = natLayer.getCellByPosition(columnPosition, rowPosition);
                afterCell = natLayer.getCellByPosition(columnPosition, rowPosition + 1);
                if (currentCell != null) {
                    currentCellBounds = currentCell.getBounds();
                    if (this.isSelected(currentCell)) {
                        int x0 = currentCellBounds.x - 1;
                        int x1 = currentCellBounds.x + currentCellBounds.width - 1;
                        int y = currentCellBounds.y - 1;
                        if (previousCell != null) {
                            Rectangle previousCellBounds = previousCell.getBounds();
                            x0 = Math.max(x0, previousCellBounds.x - 1);
                            x1 = Math.min(x1, previousCellBounds.x + previousCellBounds.width - 1);
                        }
                        if (previousCell == null || !this.isSelected(previousCell)) {
                            gc.drawLine(x0, y, x1, y);
                        }
                        if (afterCell == null || !this.isSelected(afterCell)) {
                            Rectangle cellBounds = afterCell != null ? afterCell.getBounds() : currentCell.getBounds();
                            y = currentCellBounds.y + currentCellBounds.height - 1;
                            x0 = Math.max(x0, cellBounds.x - 1);
                            x1 = Math.min(x1, cellBounds.x + cellBounds.width - 1);
                            gc.drawLine(x0, y, x1, y);
                        }
                    } else if ((positionRectangle.width == 2 || positionRectangle.height == 2) && afterCell != null && this.isSelected(afterCell)) {
                        Rectangle afterCellBounds = afterCell.getBounds();
                        int x0 = Math.max(afterCellBounds.x - 1, currentCellBounds.x - 1);
                        int x1 = Math.min(afterCellBounds.x + afterCellBounds.width - 1, currentCellBounds.x + currentCellBounds.width - 1);
                        int y = currentCellBounds.y + currentCellBounds.height - 1;
                        gc.drawLine(x0, y, x1, y);
                    }
                }
                previousCell = currentCell;
                ++rowPosition;
            }
            ++columnPosition;
        }
        int rowPosition = rowPositionOffset;
        while (rowPosition < rowPositionOffset + positionRectangle.height) {
            previousCell = null;
            currentCell = null;
            afterCell = null;
            int columnPosition2 = columnPositionOffset;
            while (columnPosition2 < columnPositionOffset + positionRectangle.width) {
                currentCell = natLayer.getCellByPosition(columnPosition2, rowPosition);
                afterCell = natLayer.getCellByPosition(columnPosition2 + 1, rowPosition);
                if (currentCell != null) {
                    currentCellBounds = currentCell.getBounds();
                    if (this.isSelected(currentCell)) {
                        int y0 = currentCellBounds.y - 1;
                        int y1 = currentCellBounds.y + currentCellBounds.height - 1;
                        int x = currentCellBounds.x - 1;
                        if (previousCell != null) {
                            Rectangle previousCellBounds = previousCell.getBounds();
                            y0 = Math.max(y0, previousCellBounds.y - 1);
                            y1 = Math.min(y1, previousCellBounds.y + previousCellBounds.height - 1);
                        }
                        if (previousCell == null || !this.isSelected(previousCell)) {
                            gc.drawLine(x, y0, x, y1);
                        }
                        if (afterCell == null || !this.isSelected(afterCell)) {
                            Rectangle cellBounds = afterCell != null ? afterCell.getBounds() : currentCell.getBounds();
                            x = currentCellBounds.x + currentCellBounds.width - 1;
                            y0 = Math.max(y0, cellBounds.y - 1);
                            y1 = Math.min(y1, cellBounds.y + cellBounds.height - 1);
                            gc.drawLine(x, y0, x, y1);
                        }
                    } else if ((positionRectangle.width == 2 || positionRectangle.height == 2) && afterCell != null && this.isSelected(afterCell)) {
                        Rectangle afterCellBounds = afterCell.getBounds();
                        int y0 = Math.max(afterCellBounds.y - 1, currentCellBounds.y - 1);
                        int y1 = Math.min(afterCellBounds.y + afterCellBounds.height - 1, currentCellBounds.y + currentCellBounds.height - 1);
                        int x = currentCellBounds.x + currentCellBounds.width - 1;
                        gc.drawLine(x, y0, x, y1);
                    }
                }
                previousCell = currentCell;
                ++columnPosition2;
            }
            ++rowPosition;
        }
        gc.setLineStyle(originalLineStyle);
        gc.setForeground(originalForeground);
    }

    private boolean isSelected(ILayerCell cell) {
        return cell.getDisplayMode() == "SELECT" || cell.getDisplayMode() == "SELECT_HOVER";
    }

    private void applyBorderStyle(GC gc, IConfigRegistry configRegistry) {
        BorderStyle borderStyle;
        IStyle cellStyle = configRegistry.getConfigAttribute(CellConfigAttributes.CELL_STYLE, "SELECT", "selectionAnchorGridLine");
        BorderStyle borderStyle2 = borderStyle = cellStyle != null ? cellStyle.getAttributeValue(CellStyleAttributes.BORDER_STYLE) : null;
        if (borderStyle == null) {
            gc.setLineStyle(6);
            gc.setLineDash(new int[]{1, 1});
            gc.setForeground(GUIHelper.COLOR_BLACK);
        } else {
            gc.setLineStyle(BorderStyle.LineStyleEnum.toSWT(borderStyle.getLineStyle()));
            gc.setLineWidth(borderStyle.getThickness());
            gc.setForeground(borderStyle.getColor());
        }
    }
}

