/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.resize.mode;

import java.util.HashSet;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.painter.IOverlayPainter;
import org.eclipse.nebula.widgets.nattable.resize.command.RowResizeCommand;
import org.eclipse.nebula.widgets.nattable.ui.action.IDragMode;
import org.eclipse.nebula.widgets.nattable.ui.util.CellEdgeDetectUtil;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;

public class RowResizeDragMode
implements IDragMode {
    private static final int DEFAULT_ROW_HEIGHT_MINIMUM = 18;
    protected int gridRowPositionToResize;
    protected int originalRowHeight;
    protected int startY;
    protected int currentY;
    protected int lastY = -1;
    protected int gridRowStartY;
    protected boolean checkMinimumWidth = true;
    protected final IOverlayPainter overlayPainter = new RowResizeOverlayPainter();

    @Override
    public void mouseDown(NatTable natTable, MouseEvent event) {
        natTable.forceFocus();
        this.gridRowPositionToResize = CellEdgeDetectUtil.getRowPositionToResize(natTable, new Point(event.x, event.y));
        if (this.gridRowPositionToResize > 0) {
            this.gridRowStartY = natTable.getStartYOfRowPosition(this.gridRowPositionToResize);
            this.originalRowHeight = natTable.getRowHeightByPosition(this.gridRowPositionToResize);
            this.startY = event.y;
            natTable.addOverlayPainter(this.overlayPainter);
        }
    }

    @Override
    public void mouseMove(NatTable natTable, MouseEvent event) {
        if (event.y > natTable.getHeight()) {
            return;
        }
        this.currentY = event.y;
        if (this.checkMinimumWidth && this.currentY < this.gridRowStartY + this.getRowHeightMinimum()) {
            this.currentY = this.gridRowStartY + this.getRowHeightMinimum();
        } else {
            int overlayExtent = 1;
            HashSet<Integer> rowsToRepaint = new HashSet<Integer>();
            rowsToRepaint.add(natTable.getRowPositionByY(this.currentY - overlayExtent));
            rowsToRepaint.add(natTable.getRowPositionByY(this.currentY + overlayExtent));
            if (this.lastY >= 0) {
                rowsToRepaint.add(natTable.getRowPositionByY(this.lastY - overlayExtent));
                rowsToRepaint.add(natTable.getRowPositionByY(this.lastY + overlayExtent));
            }
            for (Integer rowToRepaint : rowsToRepaint) {
                natTable.repaintRow(rowToRepaint);
            }
            this.lastY = this.currentY;
        }
    }

    @Override
    public void mouseUp(NatTable natTable, MouseEvent event) {
        natTable.removeOverlayPainter(this.overlayPainter);
        this.updateRowHeight(natTable, event);
    }

    private void updateRowHeight(ILayer natLayer, MouseEvent e) {
        int dragHeight = e.y - this.startY;
        int newRowHeight = this.originalRowHeight + dragHeight;
        if (newRowHeight < this.getRowHeightMinimum()) {
            newRowHeight = this.getRowHeightMinimum();
        }
        natLayer.doCommand(new RowResizeCommand(natLayer, this.gridRowPositionToResize, newRowHeight));
    }

    public int getRowHeightMinimum() {
        return 18;
    }

    private class RowResizeOverlayPainter
    implements IOverlayPainter {
        static final int ROW_RESIZE_OVERLAY_HEIGHT = 2;

        private RowResizeOverlayPainter() {
        }

        @Override
        public void paintOverlay(GC gc, ILayer layer) {
            Color originalBackgroundColor = gc.getBackground();
            gc.setBackground(GUIHelper.COLOR_DARK_GRAY);
            gc.fillRectangle(0, RowResizeDragMode.this.currentY - 1, layer.getWidth(), 2);
            gc.setBackground(originalBackgroundColor);
        }
    }
}

