/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.group;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.nebula.widgets.nattable.group.ColumnGroupModel;
import org.eclipse.nebula.widgets.nattable.group.command.GroupColumnReorderCommandHandler;
import org.eclipse.nebula.widgets.nattable.group.command.GroupMultiColumnReorderCommandHandler;
import org.eclipse.nebula.widgets.nattable.group.command.ReorderColumnGroupCommandHandler;
import org.eclipse.nebula.widgets.nattable.group.command.ReorderColumnGroupEndCommandHandler;
import org.eclipse.nebula.widgets.nattable.group.command.ReorderColumnGroupStartCommandHandler;
import org.eclipse.nebula.widgets.nattable.group.command.ReorderColumnsAndGroupsCommandHandler;
import org.eclipse.nebula.widgets.nattable.layer.AbstractLayerTransform;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.reorder.command.MultiColumnReorderCommand;

public class ColumnGroupReorderLayer
extends AbstractLayerTransform
implements IUniqueIndexLayer {
    private IUniqueIndexLayer underlyingLayer;
    private final ColumnGroupModel model;
    private int reorderFromColumnPosition;

    public ColumnGroupReorderLayer(IUniqueIndexLayer underlyingLayer, ColumnGroupModel model) {
        this.setUnderlyingLayer(underlyingLayer);
        this.underlyingLayer = underlyingLayer;
        this.model = model;
        this.registerCommandHandlers();
    }

    public boolean reorderColumnGroup(int fromColumnPosition, int toColumnPosition) {
        int fromColumnIndex = this.underlyingLayer.getColumnIndexByPosition(fromColumnPosition);
        List<Integer> fromColumnPositions = this.getColumnGroupPositions(fromColumnIndex);
        return this.underlyingLayer.doCommand(new MultiColumnReorderCommand(this, fromColumnPositions, toColumnPosition));
    }

    public ColumnGroupModel getModel() {
        return this.model;
    }

    @Override
    public ILayer getUnderlyingLayer() {
        return super.getUnderlyingLayer();
    }

    @Override
    protected void registerCommandHandlers() {
        this.registerCommandHandler(new ReorderColumnGroupCommandHandler(this));
        this.registerCommandHandler(new ReorderColumnGroupStartCommandHandler(this));
        this.registerCommandHandler(new ReorderColumnGroupEndCommandHandler(this));
        this.registerCommandHandler(new ReorderColumnsAndGroupsCommandHandler(this));
        this.registerCommandHandler(new GroupColumnReorderCommandHandler(this));
        this.registerCommandHandler(new GroupMultiColumnReorderCommandHandler(this));
    }

    @Override
    public int getColumnPositionByIndex(int columnIndex) {
        return this.underlyingLayer.getColumnPositionByIndex(columnIndex);
    }

    @Override
    public int getRowPositionByIndex(int rowIndex) {
        return this.underlyingLayer.getRowPositionByIndex(rowIndex);
    }

    public List<Integer> getColumnGroupPositions(int fromColumnIndex) {
        List<Integer> fromColumnIndexes = this.model.getColumnGroupByIndex(fromColumnIndex).getMembers();
        ArrayList<Integer> fromColumnPositions = new ArrayList<Integer>();
        for (Integer columnIndex : fromColumnIndexes) {
            fromColumnPositions.add(this.underlyingLayer.getColumnPositionByIndex(columnIndex));
        }
        Collections.sort(fromColumnPositions);
        return fromColumnPositions;
    }

    public int getReorderFromColumnPosition() {
        return this.reorderFromColumnPosition;
    }

    public void setReorderFromColumnPosition(int fromColumnPosition) {
        this.reorderFromColumnPosition = fromColumnPosition;
    }
}

