/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.grid.layer;

import java.util.Collection;
import java.util.HashSet;
import java.util.Properties;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.config.ConfigRegistry;
import org.eclipse.nebula.widgets.nattable.coordinate.Range;
import org.eclipse.nebula.widgets.nattable.layer.AbstractLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayerListener;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.layer.LayerUtil;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.IStructuralChangeEvent;
import org.eclipse.nebula.widgets.nattable.painter.layer.ILayerPainter;
import org.eclipse.nebula.widgets.nattable.ui.binding.UiBindingRegistry;
import org.eclipse.nebula.widgets.nattable.util.IClientAreaProvider;

public class DimensionallyDependentLayer
extends AbstractLayer {
    private final IUniqueIndexLayer baseLayer;
    private ILayer horizontalLayerDependency;
    private ILayer verticalLayerDependency;
    private IClientAreaProvider clientAreaProvider;

    public DimensionallyDependentLayer(IUniqueIndexLayer baseLayer, ILayer horizontalLayerDependency, ILayer verticalLayerDependency) {
        this.baseLayer = baseLayer;
        this.horizontalLayerDependency = horizontalLayerDependency;
        this.verticalLayerDependency = verticalLayerDependency;
        baseLayer.addLayerListener(this);
        horizontalLayerDependency.addLayerListener(new ILayerListener(){

            @Override
            public void handleLayerEvent(ILayerEvent event) {
                boolean cfr_ignored_0 = event instanceof IStructuralChangeEvent;
            }
        });
        verticalLayerDependency.addLayerListener(new ILayerListener(){

            @Override
            public void handleLayerEvent(ILayerEvent event) {
                boolean cfr_ignored_0 = event instanceof IStructuralChangeEvent;
            }
        });
    }

    @Override
    public void saveState(String prefix, Properties properties) {
        super.saveState(prefix, properties);
        this.baseLayer.saveState(prefix, properties);
    }

    @Override
    public void loadState(String prefix, Properties properties) {
        super.loadState(prefix, properties);
        this.baseLayer.loadState(prefix, properties);
    }

    @Override
    public void configure(ConfigRegistry configRegistry, UiBindingRegistry uiBindingRegistry) {
        this.baseLayer.configure(configRegistry, uiBindingRegistry);
        super.configure(configRegistry, uiBindingRegistry);
    }

    public void setHorizontalLayerDependency(ILayer horizontalLayerDependency) {
        this.horizontalLayerDependency = horizontalLayerDependency;
    }

    public void setVerticalLayerDependency(ILayer verticalLayerDependency) {
        this.verticalLayerDependency = verticalLayerDependency;
    }

    public ILayer getHorizontalLayerDependency() {
        return this.horizontalLayerDependency;
    }

    public ILayer getVerticalLayerDependency() {
        return this.verticalLayerDependency;
    }

    public IUniqueIndexLayer getBaseLayer() {
        return this.baseLayer;
    }

    @Override
    public boolean doCommand(ILayerCommand command) {
        ILayerCommand clonedCommand = command.cloneCommand();
        if (super.doCommand(clonedCommand)) {
            return true;
        }
        clonedCommand = command.cloneCommand();
        if (this.horizontalLayerDependency.doCommand(clonedCommand)) {
            return true;
        }
        clonedCommand = command.cloneCommand();
        if (this.verticalLayerDependency.doCommand(clonedCommand)) {
            return true;
        }
        return this.baseLayer.doCommand(command);
    }

    @Override
    public ILayerPainter getLayerPainter() {
        return this.layerPainter != null ? this.layerPainter : this.baseLayer.getLayerPainter();
    }

    @Override
    public int getColumnCount() {
        return this.horizontalLayerDependency.getColumnCount();
    }

    @Override
    public int getPreferredColumnCount() {
        return this.horizontalLayerDependency.getPreferredColumnCount();
    }

    @Override
    public int getColumnIndexByPosition(int columnPosition) {
        return this.horizontalLayerDependency.getColumnIndexByPosition(columnPosition);
    }

    @Override
    public int localToUnderlyingColumnPosition(int localColumnPosition) {
        return this.horizontalLayerDependency.localToUnderlyingColumnPosition(localColumnPosition);
    }

    @Override
    public int underlyingToLocalColumnPosition(ILayer sourceUnderlyingLayer, int underlyingColumnPosition) {
        if (sourceUnderlyingLayer == this.horizontalLayerDependency) {
            return underlyingColumnPosition;
        }
        return this.horizontalLayerDependency.underlyingToLocalColumnPosition(sourceUnderlyingLayer, underlyingColumnPosition);
    }

    @Override
    public Collection<Range> underlyingToLocalColumnPositions(ILayer sourceUnderlyingLayer, Collection<Range> underlyingColumnPositionRanges) {
        if (sourceUnderlyingLayer == this.horizontalLayerDependency) {
            return underlyingColumnPositionRanges;
        }
        return this.horizontalLayerDependency.underlyingToLocalColumnPositions(sourceUnderlyingLayer, underlyingColumnPositionRanges);
    }

    @Override
    public int getWidth() {
        return this.horizontalLayerDependency.getWidth();
    }

    @Override
    public int getPreferredWidth() {
        return this.horizontalLayerDependency.getPreferredWidth();
    }

    @Override
    public int getColumnWidthByPosition(int columnPosition) {
        return this.horizontalLayerDependency.getColumnWidthByPosition(columnPosition);
    }

    @Override
    public boolean isColumnPositionResizable(int columnPosition) {
        return this.horizontalLayerDependency.isColumnPositionResizable(columnPosition);
    }

    @Override
    public int getColumnPositionByX(int x) {
        return this.horizontalLayerDependency.getColumnPositionByX(x);
    }

    @Override
    public int getStartXOfColumnPosition(int columnPosition) {
        return this.horizontalLayerDependency.getStartXOfColumnPosition(columnPosition);
    }

    @Override
    public Collection<ILayer> getUnderlyingLayersByColumnPosition(int columnPosition) {
        HashSet<ILayer> underlyingLayers = new HashSet<ILayer>();
        underlyingLayers.add(this.baseLayer);
        return underlyingLayers;
    }

    @Override
    public int getRowCount() {
        return this.verticalLayerDependency.getRowCount();
    }

    @Override
    public int getPreferredRowCount() {
        return this.verticalLayerDependency.getPreferredRowCount();
    }

    @Override
    public int getRowIndexByPosition(int rowPosition) {
        return this.verticalLayerDependency.getRowIndexByPosition(rowPosition);
    }

    @Override
    public int localToUnderlyingRowPosition(int localRowPosition) {
        return this.verticalLayerDependency.localToUnderlyingRowPosition(localRowPosition);
    }

    @Override
    public int underlyingToLocalRowPosition(ILayer sourceUnderlyingLayer, int underlyingRowPosition) {
        if (sourceUnderlyingLayer == this.verticalLayerDependency) {
            return underlyingRowPosition;
        }
        return this.verticalLayerDependency.underlyingToLocalRowPosition(sourceUnderlyingLayer, underlyingRowPosition);
    }

    @Override
    public Collection<Range> underlyingToLocalRowPositions(ILayer sourceUnderlyingLayer, Collection<Range> underlyingRowPositionRanges) {
        if (sourceUnderlyingLayer == this.verticalLayerDependency) {
            return underlyingRowPositionRanges;
        }
        return this.verticalLayerDependency.underlyingToLocalRowPositions(sourceUnderlyingLayer, underlyingRowPositionRanges);
    }

    @Override
    public int getHeight() {
        return this.verticalLayerDependency.getHeight();
    }

    @Override
    public int getPreferredHeight() {
        return this.verticalLayerDependency.getPreferredHeight();
    }

    @Override
    public int getRowHeightByPosition(int rowPosition) {
        return this.verticalLayerDependency.getRowHeightByPosition(rowPosition);
    }

    @Override
    public boolean isRowPositionResizable(int rowPosition) {
        return this.verticalLayerDependency.isRowPositionResizable(rowPosition);
    }

    @Override
    public int getRowPositionByY(int y) {
        return this.verticalLayerDependency.getRowPositionByY(y);
    }

    @Override
    public int getStartYOfRowPosition(int rowPosition) {
        return this.verticalLayerDependency.getStartYOfRowPosition(rowPosition);
    }

    @Override
    public Collection<ILayer> getUnderlyingLayersByRowPosition(int rowPosition) {
        HashSet<ILayer> underlyingLayers = new HashSet<ILayer>();
        underlyingLayers.add(this.baseLayer);
        return underlyingLayers;
    }

    @Override
    public String getDisplayModeByPosition(int columnPosition, int rowPosition) {
        int baseColumnPosition = LayerUtil.convertColumnPosition(this, columnPosition, this.baseLayer);
        int baseRowPosition = LayerUtil.convertRowPosition(this, rowPosition, this.baseLayer);
        return this.baseLayer.getDisplayModeByPosition(baseColumnPosition, baseRowPosition);
    }

    @Override
    public LabelStack getConfigLabelsByPosition(int columnPosition, int rowPosition) {
        int baseColumnPosition = LayerUtil.convertColumnPosition(this, columnPosition, this.baseLayer);
        int baseRowPosition = LayerUtil.convertRowPosition(this, rowPosition, this.baseLayer);
        return this.baseLayer.getConfigLabelsByPosition(baseColumnPosition, baseRowPosition);
    }

    @Override
    public Object getDataValueByPosition(int columnPosition, int rowPosition) {
        int baseColumnPosition = LayerUtil.convertColumnPosition(this, columnPosition, this.baseLayer);
        int baseRowPosition = LayerUtil.convertRowPosition(this, rowPosition, this.baseLayer);
        return this.baseLayer.getDataValueByPosition(baseColumnPosition, baseRowPosition);
    }

    @Override
    public LabelStack getRegionLabelsByXY(int x, int y) {
        return this.baseLayer.getRegionLabelsByXY(x, y);
    }

    @Override
    public IClientAreaProvider getClientAreaProvider() {
        return this.clientAreaProvider;
    }

    @Override
    public void setClientAreaProvider(IClientAreaProvider clientAreaProvider) {
        this.clientAreaProvider = clientAreaProvider;
    }

    @Override
    public ILayer getUnderlyingLayerByPosition(int columnPosition, int rowPosition) {
        return this.baseLayer;
    }
}

