/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.filterrow;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.eclipse.nebula.widgets.nattable.edit.editor.TextCellEditor;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;

public class FilterRowTextCellEditor
extends TextCellEditor {
    @Override
    protected Text createEditorControl(Composite parent, int style) {
        Text text = super.createEditorControl(parent, style);
        final ScheduledExecutorService service = Executors.newScheduledThreadPool(1);
        text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                service.schedule(new KeyPressCommitRunnable(FilterRowTextCellEditor.this.getEditorValue()), 150L, TimeUnit.MILLISECONDS);
            }
        });
        text.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                service.shutdownNow();
            }
        });
        return text;
    }

    private class KeyPressCommitRunnable
    implements Runnable {
        final String toCommit;

        KeyPressCommitRunnable(String toCommit) {
            this.toCommit = toCommit;
        }

        @Override
        public void run() {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    if (KeyPressCommitRunnable.this.toCommit != null && KeyPressCommitRunnable.this.toCommit.equals(FilterRowTextCellEditor.this.getEditorValue())) {
                        FilterRowTextCellEditor.this.commit(SelectionLayer.MoveDirectionEnum.NONE, false);
                    }
                }
            });
        }
    }
}

