/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.coordinate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.nebula.widgets.nattable.coordinate.Range;
import org.eclipse.nebula.widgets.nattable.util.ObjectUtils;

public class PositionUtil {
    public static List<List<Integer>> getGroupedByContiguous(Collection<Integer> numberCollection) {
        ArrayList<Integer> numbers = new ArrayList<Integer>(numberCollection);
        Collections.sort(numbers);
        ArrayList<Integer> contiguous = new ArrayList<Integer>();
        ArrayList<List<Integer>> grouped = new ArrayList<List<Integer>>();
        int i = 0;
        while (i < numbers.size() - 1) {
            if ((Integer)numbers.get(i) + 1 != (Integer)numbers.get(i + 1)) {
                contiguous.add((Integer)numbers.get(i));
                grouped.add(contiguous);
                contiguous = new ArrayList();
            } else {
                contiguous.add((Integer)numbers.get(i));
            }
            ++i;
        }
        if (ObjectUtils.isNotEmpty(numbers)) {
            contiguous.add((Integer)numbers.get(numbers.size() - 1));
        }
        grouped.add(contiguous);
        return grouped;
    }

    public static List<Range> getRanges(Collection<Integer> numbers) {
        ArrayList<Range> ranges = new ArrayList<Range>();
        if (ObjectUtils.isNotEmpty(numbers)) {
            for (List<Integer> number : PositionUtil.getGroupedByContiguous(numbers)) {
                int start = number.get(0);
                int end = number.get(number.size() - 1) + 1;
                ranges.add(new Range(start, end));
            }
        }
        return ranges;
    }
}

