/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.emf.validation.validity.utilities;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.emf.validation.validity.AbstractNode;
import org.eclipse.ocl.examples.emf.validation.validity.Result;
import org.eclipse.ocl.examples.emf.validation.validity.Severity;
import org.eclipse.ocl.examples.emf.validation.validity.utilities.IVisibilityFilter;

public class SeveritiesVisibilityFilter
implements IVisibilityFilter {
    @NonNull
    private Set<Severity> acceptedSeverities = new HashSet<Severity>();

    @Override
    public boolean isVisible(@NonNull AbstractNode element) {
        if (this.acceptedSeverities.isEmpty()) {
            return true;
        }
        if (element instanceof AbstractNode) {
            return this.isAcceptedNode(element);
        }
        return false;
    }

    public void addFilteredSeverity(Severity severity) {
        this.acceptedSeverities.add(severity);
    }

    public boolean removeFilteredSeverity(Severity severity) {
        this.acceptedSeverities.remove((Object)severity);
        return this.acceptedSeverities.size() > 0;
    }

    private boolean isAcceptedNode(AbstractNode node) {
        Result worstResultForNode = node.getWorstResult();
        if (worstResultForNode != null && this.acceptedSeverities.contains((Object)worstResultForNode.getSeverity())) {
            return true;
        }
        for (AbstractNode child : node.getChildren()) {
            if (!this.isAcceptedNode(child)) continue;
            return true;
        }
        return false;
    }
}

