/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.emf.validation.validity.manager;

import org.eclipse.emf.common.util.Monitor;
import org.eclipse.jdt.annotation.NonNull;

public class MonitorStep {
    @NonNull
    protected final Monitor monitor;
    protected final int worked;
    private int workedSoFar = 0;
    private double workSoFar = 0.0;

    public MonitorStep(@NonNull Monitor monitor, int worked) {
        this.monitor = monitor;
        this.worked = worked;
    }

    public void done() {
        int residue = this.worked - this.workedSoFar;
        if (residue > 0) {
            this.monitor.worked(residue);
        }
    }

    @NonNull
    public Monitor getMonitor() {
        return this.monitor;
    }

    public void workedFraction(int parts) {
        int oldWorkedSoFar = this.workedSoFar;
        this.workSoFar += (double)this.worked / (double)parts;
        this.workedSoFar = (int)this.workSoFar;
        this.monitor.worked(this.workedSoFar - oldWorkedSoFar);
    }
}

