/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.db;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimerTask;
import org.eclipse.emf.cdo.common.CDOCommonRepository;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchHandler;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.branch.CDOBranchVersion;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfo;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfoHandler;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.lob.CDOLobHandler;
import org.eclipse.emf.cdo.common.lock.IDurableLockingManager;
import org.eclipse.emf.cdo.common.model.CDOClassifierRef;
import org.eclipse.emf.cdo.common.model.CDOPackageRegistry;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionCacheAdder;
import org.eclipse.emf.cdo.common.revision.CDORevisionHandler;
import org.eclipse.emf.cdo.common.util.CDOQueryInfo;
import org.eclipse.emf.cdo.eresource.EresourcePackage;
import org.eclipse.emf.cdo.server.IQueryHandler;
import org.eclipse.emf.cdo.server.ISession;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.ITransaction;
import org.eclipse.emf.cdo.server.db.IDBStoreAccessor;
import org.eclipse.emf.cdo.server.db.IIDHandler;
import org.eclipse.emf.cdo.server.db.IMetaDataManager;
import org.eclipse.emf.cdo.server.db.IPreparedStatementCache;
import org.eclipse.emf.cdo.server.db.mapping.IClassMapping;
import org.eclipse.emf.cdo.server.db.mapping.IClassMappingAuditSupport;
import org.eclipse.emf.cdo.server.db.mapping.IClassMappingDeltaSupport;
import org.eclipse.emf.cdo.server.db.mapping.IMappingStrategy;
import org.eclipse.emf.cdo.server.internal.db.CDODBSchema;
import org.eclipse.emf.cdo.server.internal.db.DBRevisionHandler;
import org.eclipse.emf.cdo.server.internal.db.DBStore;
import org.eclipse.emf.cdo.server.internal.db.DBStoreChunkReader;
import org.eclipse.emf.cdo.server.internal.db.DurableLockingManager;
import org.eclipse.emf.cdo.server.internal.db.SQLQueryHandler;
import org.eclipse.emf.cdo.server.internal.db.bundle.OM;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.AbstractHorizontalClassMapping;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranch;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranchManager;
import org.eclipse.emf.cdo.spi.common.commit.CDOChangeSetSegment;
import org.eclipse.emf.cdo.spi.common.commit.CDOCommitInfoUtil;
import org.eclipse.emf.cdo.spi.common.commit.InternalCDOCommitInfoManager;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageRegistry;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageUnit;
import org.eclipse.emf.cdo.spi.common.revision.DetachedCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionDelta;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionManager;
import org.eclipse.emf.cdo.spi.server.InternalCommitContext;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.cdo.spi.server.Store;
import org.eclipse.emf.cdo.spi.server.StoreAccessor;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.IDBConnection;
import org.eclipse.net4j.db.IDBPreparedStatement;
import org.eclipse.net4j.db.IDBResultSet;
import org.eclipse.net4j.db.ddl.IDBTable;
import org.eclipse.net4j.util.HexUtil;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.collection.CloseableIterator;
import org.eclipse.net4j.util.collection.Pair;
import org.eclipse.net4j.util.concurrent.IRWLockManager;
import org.eclipse.net4j.util.concurrent.TrackableTimerTask;
import org.eclipse.net4j.util.io.ExtendedDataInput;
import org.eclipse.net4j.util.io.ExtendedDataOutput;
import org.eclipse.net4j.util.io.IOUtil;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.monitor.OMMonitor;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBStoreAccessor
extends StoreAccessor
implements IDBStoreAccessor,
InternalCDOBranchManager.BranchLoader2,
IStoreAccessor.DurableLocking2 {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, DBStoreAccessor.class);
    private IDBConnection connection;
    private ConnectionKeepAliveTask connectionKeepAliveTask;
    private Set<CDOID> newObjects = new HashSet<CDOID>();
    private CDOID maxID = CDOID.NULL;

    public DBStoreAccessor(DBStore store, ISession session) throws DBException {
        super((Store)store, session);
    }

    public DBStoreAccessor(DBStore store, ITransaction transaction) throws DBException {
        super((Store)store, transaction);
    }

    @Override
    public DBStore getStore() {
        return (DBStore)super.getStore();
    }

    @Override
    public IDBConnection getDBConnection() {
        return this.connection;
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    @Deprecated
    public IPreparedStatementCache getStatementCache() {
        return new IPreparedStatementCache(){

            public void setConnection(Connection connection) {
            }

            public IDBPreparedStatement getPreparedStatement(String sql, IPreparedStatementCache.ReuseProbability reuseProbability) {
                IDBPreparedStatement.ReuseProbability converted = IDBPreparedStatement.ReuseProbability.values()[reuseProbability.ordinal()];
                return DBStoreAccessor.this.connection.prepareStatement(sql, converted);
            }

            public void releasePreparedStatement(PreparedStatement ps) {
                DBUtil.close((Statement)ps);
            }
        };
    }

    public DBStoreChunkReader createChunkReader(InternalCDORevision revision, EStructuralFeature feature) {
        return new DBStoreChunkReader(this, (CDORevision)revision, feature);
    }

    @Deprecated
    public CloseableIterator<CDOID> readObjectIDs() {
        if (TRACER.isEnabled()) {
            TRACER.trace("Selecting object IDs");
        }
        return this.getStore().getMappingStrategy().readObjectIDs(this);
    }

    public CDOClassifierRef readObjectType(CDOID id) {
        if (TRACER.isEnabled()) {
            TRACER.format("Selecting object type: {0}", new Object[]{id});
        }
        IMappingStrategy mappingStrategy = this.getStore().getMappingStrategy();
        return mappingStrategy.readObjectType(this, id);
    }

    protected EClass getObjectType(CDOID id) {
        InternalRepository repository = this.getStore().getRepository();
        if (id.equals(repository.getRootResourceID())) {
            return EresourcePackage.Literals.CDO_RESOURCE;
        }
        EClass result = repository.getRevisionManager().getObjectType(id);
        if (result != null) {
            return result;
        }
        CDOClassifierRef type = this.readObjectType(id);
        if (type != null) {
            CDOPackageRegistry packageRegistry = repository.getPackageRegistry();
            return (EClass)type.resolve((EPackage.Registry)packageRegistry);
        }
        return null;
    }

    public InternalCDORevision readRevision(CDOID id, CDOBranchPoint branchPoint, int listChunk, CDORevisionCacheAdder cache) {
        if (TRACER.isEnabled()) {
            TRACER.format("Selecting revision {0} from {1}", new Object[]{id, branchPoint});
        }
        IMappingStrategy mappingStrategy = this.getStore().getMappingStrategy();
        EClass eClass = this.getObjectType(id);
        if (eClass != null) {
            InternalCDORevision revision = this.getStore().createRevision(eClass, id);
            revision.setBranchPoint(branchPoint);
            IClassMapping mapping = mappingStrategy.getClassMapping(eClass);
            if (mapping.readRevision(this, revision, listChunk)) {
                int version = revision.getVersion();
                if (version < 0) {
                    return new DetachedCDORevision(eClass, id, (CDOBranch)revision.getBranch(), -version, revision.getTimeStamp(), revision.getRevised());
                }
                return revision;
            }
        }
        return null;
    }

    public InternalCDORevision readRevisionByVersion(CDOID id, CDOBranchVersion branchVersion, int listChunk, CDORevisionCacheAdder cache) {
        DBStore store = this.getStore();
        EClass eClass = this.getObjectType(id);
        IMappingStrategy mappingStrategy = store.getMappingStrategy();
        IClassMapping mapping = mappingStrategy.getClassMapping(eClass);
        InternalCDORevision revision = store.createRevision(eClass, id);
        revision.setVersion(branchVersion.getVersion());
        revision.setBranchPoint(branchVersion.getBranch().getHead());
        boolean success = false;
        if (mappingStrategy.hasAuditSupport()) {
            if (TRACER.isEnabled()) {
                TRACER.format("Selecting revision {0} from {1}", new Object[]{id, branchVersion});
            }
            if ((success = ((IClassMappingAuditSupport)((Object)mapping)).readRevisionByVersion(this, revision, listChunk)) && revision.getVersion() < 0) {
                revision = new DetachedCDORevision(eClass, id, (CDOBranch)revision.getBranch(), -revision.getVersion(), revision.getTimeStamp(), revision.getRevised());
            }
        } else {
            if (TRACER.isEnabled()) {
                TRACER.format("Selecting current base revision: {0}", new Object[]{id});
            }
            if ((success = mapping.readRevision(this, revision, listChunk)) && revision.getVersion() != branchVersion.getVersion()) {
                throw new IllegalStateException("Can only retrieve current version " + revision.getVersion() + " for " + id + " - version requested was " + branchVersion);
            }
        }
        return success ? revision : null;
    }

    public void queryResources(IStoreAccessor.QueryResourcesContext context) {
        IMappingStrategy mappingStrategy = this.getStore().getMappingStrategy();
        mappingStrategy.queryResources(this, context);
    }

    public void queryXRefs(IStoreAccessor.QueryXRefsContext context) {
        IMappingStrategy mappingStrategy = this.getStore().getMappingStrategy();
        mappingStrategy.queryXRefs(this, context);
    }

    public IQueryHandler getQueryHandler(CDOQueryInfo info) {
        String queryLanguage = info.getQueryLanguage();
        if (StringUtil.equalsUpperOrLowerCase((String)queryLanguage, (String)"sql")) {
            return new SQLQueryHandler(this);
        }
        return null;
    }

    public void queryLobs(List<byte[]> ids) {
        IDBPreparedStatement stmt = this.connection.prepareStatement(CDODBSchema.SQL_QUERY_LOBS, IDBPreparedStatement.ReuseProbability.MEDIUM);
        IDBResultSet resultSet = null;
        try {
            try {
                Iterator<byte[]> it = ids.iterator();
                while (it.hasNext()) {
                    byte[] id = it.next();
                    stmt.setString(1, HexUtil.bytesToHex((byte[])id));
                    try {
                        resultSet = stmt.executeQuery();
                        if (resultSet.next()) continue;
                        it.remove();
                    }
                    finally {
                        DBUtil.close((ResultSet)resultSet);
                    }
                }
            }
            catch (SQLException ex) {
                throw new DBException((Throwable)ex);
            }
        }
        finally {
            DBUtil.close((Statement)stmt);
        }
    }

    public void loadLob(byte[] id, OutputStream out) throws IOException {
        IDBPreparedStatement stmt = this.connection.prepareStatement(CDODBSchema.SQL_LOAD_LOB, IDBPreparedStatement.ReuseProbability.MEDIUM);
        IDBResultSet resultSet = null;
        try {
            try {
                stmt.setString(1, HexUtil.bytesToHex((byte[])id));
                resultSet = stmt.executeQuery();
                resultSet.next();
                long size = resultSet.getLong(1);
                InputStream inputStream = resultSet.getBinaryStream(2);
                if (resultSet.wasNull()) {
                    Reader reader = resultSet.getCharacterStream(3);
                    IOUtil.copyCharacter((Reader)reader, (Writer)new OutputStreamWriter(out), (long)size);
                } else {
                    IOUtil.copyBinary((InputStream)inputStream, (OutputStream)out, (long)size);
                }
            }
            catch (SQLException ex) {
                throw new DBException((Throwable)ex);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(resultSet);
            DBUtil.close((Statement)stmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)resultSet);
        DBUtil.close((Statement)stmt);
    }

    public void handleLobs(long fromTime, long toTime, CDOLobHandler handler) throws IOException {
        IDBPreparedStatement stmt = this.connection.prepareStatement(CDODBSchema.SQL_HANDLE_LOBS, IDBPreparedStatement.ReuseProbability.LOW);
        IDBResultSet resultSet = null;
        try {
            try {
                resultSet = stmt.executeQuery();
                while (resultSet.next()) {
                    byte[] id = HexUtil.hexToBytes((String)resultSet.getString(1));
                    long size = resultSet.getLong(2);
                    InputStream inputStream = resultSet.getBinaryStream(3);
                    if (resultSet.wasNull()) {
                        Reader reader = resultSet.getCharacterStream(4);
                        Writer out = handler.handleClob(id, size);
                        if (out == null) continue;
                        try {
                            IOUtil.copyCharacter((Reader)reader, (Writer)out, (long)size);
                            continue;
                        }
                        finally {
                            IOUtil.close((Closeable)out);
                        }
                    }
                    OutputStream out = handler.handleBlob(id, size);
                    if (out == null) continue;
                    try {
                        IOUtil.copyBinary((InputStream)inputStream, (OutputStream)out, (long)size);
                    }
                    finally {
                        IOUtil.close((Closeable)out);
                    }
                }
            }
            catch (SQLException ex) {
                throw new DBException((Throwable)ex);
            }
        }
        finally {
            DBUtil.close((ResultSet)resultSet);
            DBUtil.close((Statement)stmt);
        }
    }

    protected void applyIDMappings(InternalCommitContext context, OMMonitor monitor) {
        super.applyIDMappings(context, monitor);
        boolean adjustMaxID = !context.getBranchPoint().getBranch().isLocal() && this.getStore().getRepository().getIDGenerationLocation() == CDOCommonRepository.IDGenerationLocation.STORE;
        IIDHandler idHandler = this.getStore().getIDHandler();
        InternalCDORevision[] internalCDORevisionArray = context.getNewObjects();
        int n = internalCDORevisionArray.length;
        int n2 = 0;
        while (n2 < n) {
            InternalCDORevision revision = internalCDORevisionArray[n2];
            CDOID id = revision.getID();
            this.newObjects.add(id);
            if (adjustMaxID && idHandler.compare(id, this.maxID) > 0) {
                this.maxID = id;
            }
            ++n2;
        }
    }

    protected void writeCommitInfo(CDOBranch branch, long timeStamp, long previousTimeStamp, String userID, String comment, OMMonitor monitor) {
        IDBPreparedStatement stmt = this.connection.prepareStatement(CDODBSchema.SQL_CREATE_COMMIT_INFO, IDBPreparedStatement.ReuseProbability.HIGH);
        try {
            try {
                stmt.setLong(1, timeStamp);
                stmt.setLong(2, previousTimeStamp);
                stmt.setInt(3, branch.getID());
                stmt.setString(4, userID);
                stmt.setString(5, comment);
                DBUtil.update((PreparedStatement)stmt, (boolean)true);
            }
            catch (SQLException ex) {
                throw new DBException((Throwable)ex);
            }
        }
        finally {
            DBUtil.close((Statement)stmt);
        }
    }

    protected void writeRevisionDeltas(InternalCDORevisionDelta[] revisionDeltas, CDOBranch branch, long created, OMMonitor monitor) {
        IMappingStrategy mappingStrategy = this.getStore().getMappingStrategy();
        if (!mappingStrategy.hasDeltaSupport()) {
            throw new UnsupportedOperationException("Mapping strategy does not support revision deltas");
        }
        monitor.begin((double)revisionDeltas.length);
        try {
            InternalCDORevisionDelta[] internalCDORevisionDeltaArray = revisionDeltas;
            int n = revisionDeltas.length;
            int n2 = 0;
            while (n2 < n) {
                InternalCDORevisionDelta delta = internalCDORevisionDeltaArray[n2];
                this.writeRevisionDelta(delta, created, monitor.fork());
                ++n2;
            }
        }
        finally {
            monitor.done();
        }
    }

    protected void writeRevisionDelta(InternalCDORevisionDelta delta, long created, OMMonitor monitor) {
        CDOID id = delta.getID();
        EClass eClass = this.getObjectType(id);
        IClassMappingDeltaSupport mapping = (IClassMappingDeltaSupport)((Object)this.getStore().getMappingStrategy().getClassMapping(eClass));
        mapping.writeRevisionDelta(this, delta, created, monitor);
    }

    protected void writeRevisions(InternalCDORevision[] revisions, CDOBranch branch, OMMonitor monitor) {
        try {
            monitor.begin((double)revisions.length);
            InternalCDORevision[] internalCDORevisionArray = revisions;
            int n = revisions.length;
            int n2 = 0;
            while (n2 < n) {
                InternalCDORevision revision = internalCDORevisionArray[n2];
                boolean mapType = this.newObjects.contains(revision.getID());
                this.writeRevision(revision, mapType, true, monitor.fork());
                ++n2;
            }
        }
        finally {
            this.newObjects.clear();
            monitor.done();
        }
    }

    protected void writeRevision(InternalCDORevision revision, boolean mapType, boolean revise, OMMonitor monitor) {
        if (TRACER.isEnabled()) {
            TRACER.format("Writing revision: {0}", new Object[]{revision});
        }
        EClass eClass = revision.getEClass();
        IClassMapping mapping = this.getStore().getMappingStrategy().getClassMapping(eClass);
        mapping.writeRevision(this, revision, mapType, revise, monitor);
    }

    protected void detachObjects(CDOID[] detachedObjects, CDOBranch branch, long timeStamp, OMMonitor monitor) {
        IMappingStrategy mappingStrategy = this.getStore().getMappingStrategy();
        monitor.begin((double)detachedObjects.length);
        try {
            InternalCDORevisionManager revisionManager = this.getStore().getRepository().getRevisionManager();
            CDOID[] cDOIDArray = detachedObjects;
            int n = detachedObjects.length;
            int n2 = 0;
            while (n2 < n) {
                int version;
                CDOID id = cDOIDArray[n2];
                InternalCDORevision revision = revisionManager.getRevision(id, branch.getHead(), -1, 0, true);
                int n3 = version = ObjectUtil.equals((Object)branch, (Object)revision.getBranch()) ? revision.getVersion() + 1 : 1;
                if (TRACER.isEnabled()) {
                    TRACER.format("Detaching object: {0}", new Object[]{id});
                }
                EClass eClass = this.getObjectType(id);
                IClassMapping mapping = mappingStrategy.getClassMapping(eClass);
                mapping.detachObject(this, id, version, branch, timeStamp, monitor.fork());
                ++n2;
            }
        }
        finally {
            monitor.done();
        }
    }

    protected CDOID getNextCDOID(CDORevision revision) {
        return this.getStore().getIDHandler().getNextCDOID(revision);
    }

    protected void writeBlob(byte[] id, long size, InputStream inputStream) throws IOException {
        IDBPreparedStatement stmt = this.connection.prepareStatement(CDODBSchema.SQL_WRITE_BLOB, IDBPreparedStatement.ReuseProbability.MEDIUM);
        try {
            try {
                stmt.setString(1, HexUtil.bytesToHex((byte[])id));
                stmt.setLong(2, size);
                stmt.setBinaryStream(3, inputStream, (int)size);
                DBUtil.update((PreparedStatement)stmt, (boolean)true);
            }
            catch (SQLException ex) {
                throw new DBException((Throwable)ex);
            }
        }
        finally {
            DBUtil.close((Statement)stmt);
        }
    }

    protected void writeClob(byte[] id, long size, Reader reader) throws IOException {
        IDBPreparedStatement stmt = this.connection.prepareStatement(CDODBSchema.SQL_WRITE_CLOB, IDBPreparedStatement.ReuseProbability.MEDIUM);
        try {
            try {
                stmt.setString(1, HexUtil.bytesToHex((byte[])id));
                stmt.setLong(2, size);
                stmt.setCharacterStream(3, reader, (int)size);
                DBUtil.update((PreparedStatement)stmt, (boolean)true);
            }
            catch (SQLException ex) {
                throw new DBException((Throwable)ex);
            }
        }
        finally {
            DBUtil.close((Statement)stmt);
        }
    }

    protected final void doCommit(OMMonitor monitor) {
        if (TRACER.isEnabled()) {
            TRACER.format("--- DB COMMIT ---", new Object[0]);
        }
        OMMonitor.Async async = null;
        monitor.begin();
        try {
            try {
                try {
                    async = monitor.forkAsync();
                    this.getConnection().commit();
                    if (this.maxID != CDOID.NULL) {
                        this.getStore().getIDHandler().adjustLastObjectID(this.maxID);
                        this.maxID = CDOID.NULL;
                    }
                }
                finally {
                    if (async != null) {
                        async.stop();
                    }
                }
            }
            catch (SQLException ex) {
                throw new DBException((Throwable)ex);
            }
        }
        finally {
            monitor.done();
        }
    }

    protected final void doRollback(IStoreAccessor.CommitContext commitContext) {
        this.getStore().getMetaDataManager().clearMetaIDMappings();
        if (TRACER.isEnabled()) {
            TRACER.format("--- DB ROLLBACK ---", new Object[0]);
        }
        try {
            this.getConnection().rollback();
            this.getStore().getMappingStrategy().removeMapping(this.getConnection(), commitContext.getNewPackageUnits());
        }
        catch (SQLException ex) {
            throw new DBException((Throwable)ex);
        }
    }

    protected void doActivate() throws Exception {
        String value;
        super.doActivate();
        DBStore store = this.getStore();
        this.connection = store.getDatabase().getConnection();
        this.connectionKeepAliveTask = new ConnectionKeepAliveTask(this);
        long keepAlivePeriod = 14400000L;
        Map<String, String> storeProps = store.getProperties();
        if (storeProps != null && (value = storeProps.get("connectionKeepAlivePeriod")) != null) {
            keepAlivePeriod = Long.parseLong(value) * 60L * 1000L;
        }
        store.getConnectionKeepAliveTimer().schedule((TimerTask)((Object)this.connectionKeepAliveTask), keepAlivePeriod, keepAlivePeriod);
    }

    protected void doDeactivate() throws Exception {
        this.connectionKeepAliveTask.cancel();
        this.connectionKeepAliveTask = null;
        DBUtil.close((Connection)this.connection);
        this.connection = null;
        super.doDeactivate();
    }

    protected void doPassivate() throws Exception {
        this.getConnection().rollback();
    }

    protected void doUnpassivate() throws Exception {
    }

    public EPackage[] loadPackageUnit(InternalCDOPackageUnit packageUnit) {
        return this.getStore().getMetaDataManager().loadPackageUnit(this.getConnection(), packageUnit);
    }

    public Collection<InternalCDOPackageUnit> readPackageUnits() {
        return this.getStore().getMetaDataManager().readPackageUnits(this.getConnection());
    }

    public void writePackageUnits(InternalCDOPackageUnit[] packageUnits, OMMonitor monitor) {
        monitor.begin(2.0);
        try {
            DBStore store = this.getStore();
            Connection connection = this.getConnection();
            IMetaDataManager metaDataManager = store.getMetaDataManager();
            metaDataManager.writePackageUnits(connection, packageUnits, monitor.fork());
            IMappingStrategy mappingStrategy = store.getMappingStrategy();
            mappingStrategy.createMapping(connection, packageUnits, monitor.fork());
        }
        finally {
            monitor.done();
        }
    }

    public Pair<Integer, Long> createBranch(int branchID, InternalCDOBranchManager.BranchLoader.BranchInfo branchInfo) {
        this.checkBranchingSupport();
        if (branchID == Integer.MAX_VALUE) {
            branchID = this.getStore().getNextBranchID();
        } else if (branchID == Integer.MIN_VALUE) {
            branchID = this.getStore().getNextLocalBranchID();
        }
        IDBPreparedStatement stmt = this.connection.prepareStatement(CDODBSchema.SQL_CREATE_BRANCH, IDBPreparedStatement.ReuseProbability.LOW);
        try {
            stmt.setInt(1, branchID);
            stmt.setString(2, branchInfo.getName());
            stmt.setInt(3, branchInfo.getBaseBranchID());
            stmt.setLong(4, branchInfo.getBaseTimeStamp());
            DBUtil.update((PreparedStatement)stmt, (boolean)true);
            this.getConnection().commit();
            Pair pair = Pair.create((Object)branchID, (Object)branchInfo.getBaseTimeStamp());
            return pair;
        }
        catch (SQLException ex) {
            throw new DBException((Throwable)ex);
        }
        finally {
            DBUtil.close((Statement)stmt);
        }
    }

    public InternalCDOBranchManager.BranchLoader.BranchInfo loadBranch(int branchID) {
        InternalCDOBranchManager.BranchLoader.BranchInfo branchInfo;
        this.checkBranchingSupport();
        IDBPreparedStatement stmt = this.connection.prepareStatement(CDODBSchema.SQL_LOAD_BRANCH, IDBPreparedStatement.ReuseProbability.HIGH);
        IDBResultSet resultSet = null;
        try {
            stmt.setInt(1, branchID);
            resultSet = stmt.executeQuery();
            if (!resultSet.next()) {
                throw new DBException("Branch with ID " + branchID + " does not exist");
            }
            String name = resultSet.getString(1);
            int baseBranchID = resultSet.getInt(2);
            long baseTimeStamp = resultSet.getLong(3);
            branchInfo = new InternalCDOBranchManager.BranchLoader.BranchInfo(name, baseBranchID, baseTimeStamp);
        }
        catch (SQLException ex) {
            try {
                throw new DBException((Throwable)ex);
            }
            catch (Throwable throwable) {
                DBUtil.close(resultSet);
                DBUtil.close((Statement)stmt);
                throw throwable;
            }
        }
        DBUtil.close((ResultSet)resultSet);
        DBUtil.close((Statement)stmt);
        return branchInfo;
    }

    public InternalCDOBranchManager.BranchLoader.SubBranchInfo[] loadSubBranches(int baseID) {
        InternalCDOBranchManager.BranchLoader.SubBranchInfo[] subBranchInfoArray;
        this.checkBranchingSupport();
        IDBPreparedStatement stmt = this.connection.prepareStatement(CDODBSchema.SQL_LOAD_SUB_BRANCHES, IDBPreparedStatement.ReuseProbability.HIGH);
        IDBResultSet resultSet = null;
        try {
            stmt.setInt(1, baseID);
            resultSet = stmt.executeQuery();
            ArrayList<InternalCDOBranchManager.BranchLoader.SubBranchInfo> result = new ArrayList<InternalCDOBranchManager.BranchLoader.SubBranchInfo>();
            while (resultSet.next()) {
                int id = resultSet.getInt(1);
                String name = resultSet.getString(2);
                long baseTimeStamp = resultSet.getLong(3);
                result.add(new InternalCDOBranchManager.BranchLoader.SubBranchInfo(id, name, baseTimeStamp));
            }
            subBranchInfoArray = result.toArray(new InternalCDOBranchManager.BranchLoader.SubBranchInfo[result.size()]);
        }
        catch (SQLException ex) {
            try {
                throw new DBException((Throwable)ex);
            }
            catch (Throwable throwable) {
                DBUtil.close(resultSet);
                DBUtil.close((Statement)stmt);
                throw throwable;
            }
        }
        DBUtil.close((ResultSet)resultSet);
        DBUtil.close((Statement)stmt);
        return subBranchInfoArray;
    }

    private void checkBranchingSupport() {
        if (!this.getStore().getMappingStrategy().hasBranchingSupport()) {
            throw new UnsupportedOperationException("Mapping strategy does not support branching");
        }
    }

    public int loadBranches(int startID, int endID, CDOBranchHandler handler) {
        int n;
        int count = 0;
        IDBPreparedStatement stmt = this.connection.prepareStatement(CDODBSchema.SQL_LOAD_BRANCHES, IDBPreparedStatement.ReuseProbability.HIGH);
        IDBResultSet resultSet = null;
        InternalRepository repository = this.getSession().getManager().getRepository();
        InternalCDOBranchManager branchManager = repository.getBranchManager();
        try {
            stmt.setInt(1, startID);
            stmt.setInt(2, endID > 0 ? endID : Integer.MAX_VALUE);
            resultSet = stmt.executeQuery();
            while (resultSet.next()) {
                int branchID = resultSet.getInt(1);
                String name = resultSet.getString(2);
                int baseBranchID = resultSet.getInt(3);
                long baseTimeStamp = resultSet.getLong(4);
                InternalCDOBranch branch = branchManager.getBranch(branchID, new InternalCDOBranchManager.BranchLoader.BranchInfo(name, baseBranchID, baseTimeStamp));
                handler.handleBranch((CDOBranch)branch);
                ++count;
            }
            n = count;
        }
        catch (SQLException ex) {
            try {
                throw new DBException((Throwable)ex);
            }
            catch (Throwable throwable) {
                DBUtil.close(resultSet);
                DBUtil.close((Statement)stmt);
                throw throwable;
            }
        }
        DBUtil.close((ResultSet)resultSet);
        DBUtil.close((Statement)stmt);
        return n;
    }

    @Deprecated
    public void deleteBranch(int branchID) {
        throw new UnsupportedOperationException();
    }

    public void renameBranch(int branchID, String newName) {
        this.checkBranchingSupport();
        IDBPreparedStatement stmt = this.connection.prepareStatement(CDODBSchema.SQL_RENAME_BRANCH, IDBPreparedStatement.ReuseProbability.LOW);
        try {
            try {
                stmt.setString(1, newName);
                stmt.setInt(2, branchID);
                DBUtil.update((PreparedStatement)stmt, (boolean)true);
                this.getConnection().commit();
            }
            catch (SQLException ex) {
                throw new DBException((Throwable)ex);
            }
        }
        finally {
            DBUtil.close((Statement)stmt);
        }
    }

    public void loadCommitInfos(CDOBranch branch, long startTime, long endTime, CDOCommitInfoHandler handler) {
        int count = CDOCommitInfoUtil.decodeCount((long)endTime);
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT ");
        builder.append(CDODBSchema.COMMIT_INFOS_TIMESTAMP);
        builder.append(", ");
        builder.append(CDODBSchema.COMMIT_INFOS_PREVIOUS_TIMESTAMP);
        builder.append(", ");
        builder.append(CDODBSchema.COMMIT_INFOS_USER);
        builder.append(", ");
        builder.append(CDODBSchema.COMMIT_INFOS_COMMENT);
        if (branch == null) {
            builder.append(", ");
            builder.append(CDODBSchema.COMMIT_INFOS_BRANCH);
        }
        builder.append(" FROM ");
        builder.append(CDODBSchema.COMMIT_INFOS);
        boolean where = false;
        if (branch != null) {
            builder.append(where ? " AND " : " WHERE ");
            builder.append(CDODBSchema.COMMIT_INFOS_BRANCH);
            builder.append("=");
            builder.append(branch.getID());
            where = true;
        }
        if (startTime != 0L) {
            builder.append(where ? " AND " : " WHERE ");
            builder.append(CDODBSchema.COMMIT_INFOS_TIMESTAMP);
            builder.append(count < 0 ? "<=" : ">=");
            builder.append(startTime);
            where = true;
        }
        if (endTime > 0L) {
            builder.append(where ? " AND " : " WHERE ");
            builder.append(CDODBSchema.COMMIT_INFOS_TIMESTAMP);
            builder.append("<=");
            builder.append(endTime);
            where = true;
        }
        builder.append(" ORDER BY ");
        builder.append(CDODBSchema.COMMIT_INFOS_TIMESTAMP);
        builder.append(count < 0 || 0L <= endTime && endTime <= startTime ? " DESC" : " ASC");
        String sql = builder.toString();
        IDBPreparedStatement stmt = this.connection.prepareStatement(sql, IDBPreparedStatement.ReuseProbability.MEDIUM);
        IDBResultSet resultSet = null;
        InternalRepository repository = this.getStore().getRepository();
        InternalCDOBranchManager branchManager = repository.getBranchManager();
        InternalCDOCommitInfoManager commitInfoManager = repository.getCommitInfoManager();
        count = Math.abs(count);
        try {
            try {
                resultSet = stmt.executeQuery();
                while (resultSet.next()) {
                    long timeStamp = resultSet.getLong(1);
                    long previousTimeStamp = resultSet.getLong(2);
                    String userID = resultSet.getString(3);
                    String comment = resultSet.getString(4);
                    CDOBranch infoBranch = branch;
                    if (infoBranch == null) {
                        int id = resultSet.getInt(5);
                        infoBranch = branchManager.getBranch(id);
                    }
                    CDOCommitInfo commitInfo = commitInfoManager.createCommitInfo(infoBranch, timeStamp, previousTimeStamp, userID, comment, null);
                    handler.handleCommitInfo(commitInfo);
                    if (--count != 0) continue;
                    break;
                }
            }
            catch (SQLException ex) {
                throw new DBException((Throwable)ex);
            }
        }
        finally {
            DBUtil.close((ResultSet)resultSet);
            DBUtil.close((Statement)stmt);
        }
    }

    public Set<CDOID> readChangeSet(OMMonitor monitor, CDOChangeSetSegment ... segments) {
        IMappingStrategy mappingStrategy = this.getStore().getMappingStrategy();
        return mappingStrategy.readChangeSet(this, monitor, segments);
    }

    public void handleRevisions(EClass eClass, CDOBranch branch, long timeStamp, boolean exactTime, CDORevisionHandler handler) {
        IMappingStrategy mappingStrategy = this.getStore().getMappingStrategy();
        mappingStrategy.handleRevisions(this, eClass, branch, timeStamp, exactTime, new DBRevisionHandler(handler));
    }

    public void rawExport(CDODataOutput out, int fromBranchID, int toBranchID, long fromCommitTime, long toCommitTime) throws IOException {
        DBStore store = this.getStore();
        if (store.getRepository().getIDGenerationLocation() == CDOCommonRepository.IDGenerationLocation.STORE) {
            out.writeCDOID(store.getIDHandler().getLastObjectID());
        }
        Connection connection = this.getConnection();
        String where = " WHERE " + CDODBSchema.BRANCHES_ID + " BETWEEN " + fromBranchID + " AND " + toBranchID;
        DBUtil.serializeTable((ExtendedDataOutput)out, (Connection)connection, (IDBTable)CDODBSchema.BRANCHES, null, (String)where);
        where = " WHERE " + CDODBSchema.COMMIT_INFOS_TIMESTAMP + " BETWEEN " + fromCommitTime + " AND " + toCommitTime;
        DBUtil.serializeTable((ExtendedDataOutput)out, (Connection)connection, (IDBTable)CDODBSchema.COMMIT_INFOS, null, (String)where);
        DurableLockingManager durableLockingManager = store.getDurableLockingManager();
        durableLockingManager.rawExport(connection, out, fromCommitTime, toCommitTime);
        IIDHandler idHandler = store.getIDHandler();
        idHandler.rawExport(connection, out, fromCommitTime, toCommitTime);
        IMappingStrategy mappingStrategy = store.getMappingStrategy();
        mappingStrategy.rawExport(this, out, fromBranchID, toBranchID, fromCommitTime, toCommitTime);
    }

    public void rawImport(CDODataInput in, int fromBranchID, int toBranchID, long fromCommitTime, long toCommitTime, OMMonitor monitor) throws IOException {
        DBStore store = this.getStore();
        IIDHandler idHandler = store.getIDHandler();
        if (store.getRepository().getIDGenerationLocation() == CDOCommonRepository.IDGenerationLocation.STORE) {
            idHandler.setLastObjectID(in.readCDOID());
        }
        IMappingStrategy mappingStrategy = store.getMappingStrategy();
        int size = mappingStrategy.getClassMappings().size();
        int commitWork = 5;
        monitor.begin((double)(commitWork + size + commitWork));
        HashSet<InternalCDOPackageUnit> packageUnits = new HashSet<InternalCDOPackageUnit>();
        Connection connection = this.getConnection();
        try {
            try {
                DBUtil.deserializeTable((ExtendedDataInput)in, (Connection)connection, (IDBTable)CDODBSchema.BRANCHES, (OMMonitor)monitor.fork());
                DBUtil.deserializeTable((ExtendedDataInput)in, (Connection)connection, (IDBTable)CDODBSchema.COMMIT_INFOS, (OMMonitor)monitor.fork());
                DurableLockingManager durableLockingManager = store.getDurableLockingManager();
                durableLockingManager.rawImport(connection, in, fromCommitTime, toCommitTime, monitor.fork());
                idHandler.rawImport(connection, in, fromCommitTime, toCommitTime, monitor.fork());
                mappingStrategy.rawImport(this, in, fromCommitTime, toCommitTime, monitor.fork((double)size));
                this.rawCommit(commitWork, monitor);
            }
            catch (RuntimeException ex) {
                this.rawRollback(packageUnits);
                throw ex;
            }
            catch (IOException ex) {
                this.rawRollback(packageUnits);
                throw ex;
            }
        }
        finally {
            monitor.done();
        }
    }

    private void rawRollback(Collection<InternalCDOPackageUnit> packageUnits) {
        try {
            Connection connection = this.getConnection();
            connection.rollback();
        }
        catch (SQLException ex) {
            OM.LOG.error((Throwable)ex);
        }
        this.getStore().getMappingStrategy().removeMapping(this.getConnection(), packageUnits.toArray(new InternalCDOPackageUnit[packageUnits.size()]));
    }

    protected void rawImportPackageUnits(CDODataInput in, long fromCommitTime, long toCommitTime, Collection<InternalCDOPackageUnit> packageUnits, OMMonitor monitor) throws IOException {
        monitor.begin(2.0);
        try {
            DBStore store = this.getStore();
            IMetaDataManager metaDataManager = store.getMetaDataManager();
            Connection connection = this.getConnection();
            packageUnits.addAll(metaDataManager.rawImport(connection, in, fromCommitTime, toCommitTime, monitor.fork()));
            InternalRepository repository = store.getRepository();
            InternalCDOPackageRegistry packageRegistry = repository.getPackageRegistry(false);
            for (InternalCDOPackageUnit packageUnit : packageUnits) {
                packageRegistry.putPackageUnit(packageUnit);
            }
            IMappingStrategy mappingStrategy = store.getMappingStrategy();
            Connection connection2 = null;
            try {
                connection2 = store.getConnection();
                mappingStrategy.createMapping(connection2, packageUnits.toArray(new InternalCDOPackageUnit[packageUnits.size()]), monitor.fork());
            }
            finally {
                DBUtil.close((Connection)connection2);
            }
        }
        finally {
            monitor.done();
        }
    }

    public void rawStore(InternalCDOPackageUnit[] packageUnits, OMMonitor monitor) {
        this.writePackageUnits(packageUnits, monitor);
    }

    public void rawStore(InternalCDORevision revision, OMMonitor monitor) {
        boolean isFirstRevision;
        CDOID id = revision.getID();
        CDOClassifierRef classifierRef = this.getStore().getMappingStrategy().readObjectType(this, id);
        boolean bl = isFirstRevision = classifierRef == null;
        if (!isFirstRevision) {
            EClass eClass = revision.getEClass();
            boolean namesMatch = classifierRef.getClassifierName().equals(eClass.getName());
            boolean packagesMatch = classifierRef.getPackageURI().equals(eClass.getEPackage().getNsURI());
            if (!namesMatch || !packagesMatch) {
                throw new IllegalStateException();
            }
        }
        this.writeRevision(revision, isFirstRevision, false, monitor);
        this.getStore().getIDHandler().adjustLastObjectID(id);
    }

    public void rawStore(byte[] id, long size, InputStream inputStream) throws IOException {
        this.writeBlob(id, size, inputStream);
    }

    public void rawStore(byte[] id, long size, Reader reader) throws IOException {
        this.writeClob(id, size, reader);
    }

    public void rawStore(CDOBranch branch, long timeStamp, long previousTimeStamp, String userID, String comment, OMMonitor monitor) {
        this.writeCommitInfo(branch, timeStamp, previousTimeStamp, userID, comment, monitor);
    }

    public void rawDelete(CDOID id, int version, CDOBranch branch, EClass eClass, OMMonitor monitor) {
        IMappingStrategy mappingStrategy;
        IClassMapping mapping;
        if (eClass == null) {
            eClass = this.getObjectType(id);
        }
        if (!((mapping = (mappingStrategy = this.getStore().getMappingStrategy()).getClassMapping(eClass)) instanceof AbstractHorizontalClassMapping)) {
            throw new UnsupportedOperationException("rawDelete() is not supported by " + mapping.getClass().getName());
        }
        AbstractHorizontalClassMapping m = (AbstractHorizontalClassMapping)mapping;
        m.rawDelete(this, id, version, branch, monitor);
    }

    public void rawCommit(double commitWork, OMMonitor monitor) {
        monitor.begin();
        OMMonitor.Async async = monitor.forkAsync();
        try {
            try {
                Connection connection = this.getConnection();
                connection.commit();
            }
            catch (SQLException ex) {
                throw new DBException((Throwable)ex);
            }
        }
        finally {
            async.stop();
            monitor.done();
        }
    }

    public IDurableLockingManager.LockArea createLockArea(String userID, CDOBranchPoint branchPoint, boolean readOnly, Map<CDOID, IDurableLockingManager.LockGrade> locks) {
        return this.createLockArea(null, userID, branchPoint, readOnly, locks);
    }

    public IDurableLockingManager.LockArea createLockArea(String durableLockingID, String userID, CDOBranchPoint branchPoint, boolean readOnly, Map<CDOID, IDurableLockingManager.LockGrade> locks) {
        DurableLockingManager manager = this.getStore().getDurableLockingManager();
        return manager.createLockArea(this, durableLockingID, userID, branchPoint, readOnly, locks);
    }

    public void updateLockArea(IDurableLockingManager.LockArea area) {
        DurableLockingManager manager = this.getStore().getDurableLockingManager();
        manager.updateLockArea(this, area);
    }

    public IDurableLockingManager.LockArea getLockArea(String durableLockingID) throws IDurableLockingManager.LockAreaNotFoundException {
        DurableLockingManager manager = this.getStore().getDurableLockingManager();
        return manager.getLockArea(this, durableLockingID);
    }

    public void getLockAreas(String userIDPrefix, IDurableLockingManager.LockArea.Handler handler) {
        DurableLockingManager manager = this.getStore().getDurableLockingManager();
        manager.getLockAreas(this, userIDPrefix, handler);
    }

    public void deleteLockArea(String durableLockingID) {
        DurableLockingManager manager = this.getStore().getDurableLockingManager();
        manager.deleteLockArea(this, durableLockingID);
    }

    public void lock(String durableLockingID, IRWLockManager.LockType type, Collection<? extends Object> objectsToLock) {
        DurableLockingManager manager = this.getStore().getDurableLockingManager();
        manager.lock(this, durableLockingID, type, objectsToLock);
    }

    public void unlock(String durableLockingID, IRWLockManager.LockType type, Collection<? extends Object> objectsToUnlock) {
        DurableLockingManager manager = this.getStore().getDurableLockingManager();
        manager.unlock(this, durableLockingID, type, objectsToUnlock);
    }

    public void unlock(String durableLockingID) {
        DurableLockingManager manager = this.getStore().getDurableLockingManager();
        manager.unlock(this, durableLockingID);
    }

    private static final class ConnectionKeepAliveTask
    extends TrackableTimerTask {
        public static final long EXECUTION_PERIOD = 14400000L;
        private DBStoreAccessor accessor;

        public ConnectionKeepAliveTask(DBStoreAccessor accessor) {
            this.accessor = accessor;
        }

        public void run() {
            block11: {
                if (this.accessor == null) {
                    return;
                }
                Statement stmt = null;
                try {
                    if (TRACER.isEnabled()) {
                        TRACER.trace("DB connection keep-alive task activated");
                    }
                    Connection connection = this.accessor.getConnection();
                    stmt = connection.createStatement();
                    stmt.executeQuery("SELECT 1 FROM " + CDODBSchema.PROPERTIES);
                }
                catch (SQLException ex) {
                    OM.LOG.error("DB connection keep-alive failed", (Throwable)ex);
                    try {
                        LifecycleUtil.deactivate((Object)this.accessor);
                        LifecycleUtil.activate((Object)this.accessor);
                    }
                    catch (Exception ex2) {
                        OM.LOG.error("DB connection reconnect failed", (Throwable)ex2);
                    }
                    DBUtil.close((Statement)stmt);
                    break block11;
                }
                catch (Exception ex) {
                    try {
                        OM.LOG.error("DB connection keep-alive failed", (Throwable)ex);
                        break block11;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        DBUtil.close(stmt);
                    }
                }
                DBUtil.close((Statement)stmt);
            }
        }

        public boolean cancel() {
            this.accessor = null;
            return super.cancel();
        }
    }
}

