/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.util;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.ExecutionOccurrenceSpecification;
import org.eclipse.uml2.uml.ExecutionSpecification;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.InteractionOperand;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.MessageOccurrenceSpecification;
import org.eclipse.uml2.uml.OccurrenceSpecification;
import org.eclipse.uml2.uml.UMLPackage;

public class OccurrenceSpecificationHelper {
    private OccurrenceSpecificationHelper() {
    }

    public static boolean resetExecutionStart(ExecutionSpecification execution, Element newStart) {
        if (!(newStart instanceof OccurrenceSpecification)) {
            return false;
        }
        return OccurrenceSpecificationHelper.resetExecutionEnd(execution, (OccurrenceSpecification)newStart, true);
    }

    public static boolean resetExecutionFinish(ExecutionSpecification execution, Element newFinish) {
        if (!(newFinish instanceof OccurrenceSpecification)) {
            return false;
        }
        return OccurrenceSpecificationHelper.resetExecutionEnd(execution, (OccurrenceSpecification)newFinish, false);
    }

    private static void copyInfo(OccurrenceSpecification fromOS, OccurrenceSpecification toOS) {
        if (fromOS == null || toOS == null) {
            return;
        }
        EList covereds = fromOS.getCovereds();
        for (Lifeline lifeline : covereds) {
            if (toOS.getCovereds().contains((Object)lifeline)) continue;
            toOS.getCovereds().add((Object)lifeline);
        }
    }

    public static boolean resetExecutionEnd(ExecutionSpecification execution, OccurrenceSpecification newEnd, boolean isStart) {
        OccurrenceSpecification oldEnd;
        if (execution == null || newEnd == null) {
            return false;
        }
        OccurrenceSpecification occurrenceSpecification = oldEnd = isStart ? execution.getStart() : execution.getFinish();
        if (newEnd.eContainer() == null) {
            EObject eContainer;
            EObject eObject = eContainer = oldEnd != null ? oldEnd.eContainer() : execution.eContainer();
            if (eContainer instanceof Interaction) {
                newEnd.setEnclosingInteraction((Interaction)eContainer);
            } else if (eContainer instanceof InteractionOperand) {
                newEnd.setEnclosingOperand((InteractionOperand)eContainer);
            }
        }
        if (newEnd.getName() == null) {
            if (isStart) {
                newEnd.setName(String.valueOf(execution.getName()) + "Start");
            } else {
                newEnd.setName(String.valueOf(execution.getName()) + "Finish");
            }
        }
        OccurrenceSpecificationHelper.copyInfo(oldEnd, newEnd);
        if (newEnd instanceof ExecutionOccurrenceSpecification) {
            ((ExecutionOccurrenceSpecification)newEnd).setExecution(execution);
        }
        if (isStart) {
            execution.setStart(newEnd);
        } else {
            execution.setFinish(newEnd);
        }
        if (OccurrenceSpecificationHelper.canBeRemoved(oldEnd, newEnd, isStart)) {
            EcoreUtil.remove((EObject)oldEnd);
        }
        return true;
    }

    private static boolean canBeRemoved(OccurrenceSpecification os, OccurrenceSpecification copy, boolean isStart) {
        if (os == null || copy == null || os instanceof MessageOccurrenceSpecification) {
            return false;
        }
        Collection usages = EMFHelper.getUsages((EObject)os);
        for (EStructuralFeature.Setting setting : usages) {
            Object osValue = setting.get(true);
            if (osValue instanceof List && ((List)osValue).contains(copy)) continue;
            EStructuralFeature feature = setting.getEStructuralFeature();
            if ((!isStart || UMLPackage.eINSTANCE.getExecutionSpecification_Start() != feature) && !isStart && UMLPackage.eINSTANCE.getExecutionSpecification_Finish() != feature) continue;
        }
        return true;
    }

    public static ExecutionSpecification findExecutionWith(OccurrenceSpecification end, boolean isStart) {
        if (end instanceof ExecutionOccurrenceSpecification) {
            return ((ExecutionOccurrenceSpecification)end).getExecution();
        }
        Collection usages = EMFHelper.getUsages((EObject)end);
        for (EStructuralFeature.Setting setting : usages) {
            EObject eObject = setting.getEObject();
            EStructuralFeature feature = setting.getEStructuralFeature();
            if (isStart && UMLPackage.eINSTANCE.getExecutionSpecification_Start() == feature) {
                return (ExecutionSpecification)eObject;
            }
            if (isStart || UMLPackage.eINSTANCE.getExecutionSpecification_Finish() != feature) continue;
            return (ExecutionSpecification)eObject;
        }
        return null;
    }
}

