/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.IMaskManagedLabelEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.helper.StereotypedElementLabelHelper;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.LifelineNameEditPart;
import org.eclipse.papyrus.uml.tools.utils.UMLUtil;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.Type;

public class LifelineLabelHelper
extends StereotypedElementLabelHelper {
    public static final String SHOW_REPRESENT_NAME = "representsName";
    public static final String SHOW_REPRESENT_TYPE = "representsType";
    public static final String SHOW_UNDEFINED_TYPE = "undefinedType";
    public static final String SHOW_LIFELINE_NAME = "lifelineName";
    public static final Collection<String> DEFAULT_LABEL_DISPLAY = Arrays.asList("representsName", "representsType");
    private static LifelineLabelHelper labelHelper;
    protected final Map<String, String> masks = new HashMap<String, String>();
    private static final String UNAMED = "<Unnamed>";
    private static final String UNDEFINED = "<Undefined>";

    public static LifelineLabelHelper getInstance() {
        if (labelHelper == null) {
            labelHelper = new LifelineLabelHelper();
        }
        return labelHelper;
    }

    protected LifelineLabelHelper() {
        this.masks.put(SHOW_REPRESENT_NAME, "Show represent name");
        this.masks.put(SHOW_REPRESENT_TYPE, "Show represent type");
        this.masks.put(SHOW_UNDEFINED_TYPE, "Always show undefined type");
        this.masks.put(SHOW_LIFELINE_NAME, "Always show lifeline name");
    }

    public Map<String, String> getMasks() {
        return this.masks;
    }

    public Lifeline getUMLElement(GraphicalEditPart editPart) {
        return (Lifeline)UMLUtil.resolveUMLElement((Object)editPart);
    }

    protected String elementLabel(GraphicalEditPart editPart) {
        if (editPart instanceof LifelineNameEditPart) {
            editPart = (GraphicalEditPart)editPart.getParent();
        }
        Collection displayValue = DEFAULT_LABEL_DISPLAY;
        IMaskManagedLabelEditPolicy policy = (IMaskManagedLabelEditPolicy)editPart.getEditPolicy((Object)"MaskManagedLabelPolicy");
        if (policy != null) {
            displayValue = policy.getCurrentDisplayValue();
        }
        return this.getCustomLabel(this.getUMLElement(editPart), displayValue);
    }

    private String getCustomLabel(Lifeline lifeline, Collection<String> displayValue) {
        StringBuilder sb = new StringBuilder();
        this.appendName(lifeline, displayValue, sb);
        boolean displayType = displayValue.contains(SHOW_REPRESENT_TYPE);
        if (lifeline.getRepresents() == null || displayValue.contains(SHOW_LIFELINE_NAME)) {
            displayType = false;
        }
        if (displayType) {
            this.appendType(lifeline, displayValue, sb);
        }
        return sb.toString();
    }

    protected void appendName(Lifeline lifeline, Collection<String> displayValue, StringBuilder sb) {
        ConnectableElement element = lifeline.getRepresents();
        String lifelineName = lifeline.getName();
        if (element == null || displayValue.contains(SHOW_LIFELINE_NAME)) {
            this.appendString(sb, lifelineName, UNAMED);
            return;
        }
        if (displayValue.contains(SHOW_REPRESENT_NAME)) {
            this.appendString(sb, element.getName(), UNAMED);
        } else if (!displayValue.contains(SHOW_REPRESENT_TYPE)) {
            this.appendString(sb, lifelineName, UNAMED);
        }
    }

    protected void appendType(Lifeline lifeline, Collection<String> displayValue, StringBuilder sb) {
        ConnectableElement element = lifeline.getRepresents();
        if (element == null) {
            return;
        }
        Type type = element.getType();
        if (displayValue.contains(SHOW_REPRESENT_TYPE)) {
            if (type == null) {
                if (displayValue.contains(SHOW_UNDEFINED_TYPE)) {
                    sb.append(":").append(UNDEFINED);
                }
            } else {
                this.appendString(sb.append(":"), type.getName(), UNAMED);
            }
        }
    }

    private void appendString(StringBuilder sb, String str, String defaultValue) {
        if (str != null) {
            sb.append(str);
        } else {
            sb.append(defaultValue);
        }
    }
}

