/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalCommandStack;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.InternalTransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.TransactionalCommandStackImpl;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.Tool;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.papyrus.infra.core.editor.CoreMultiDiagramEditor;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.uml.diagram.common.util.MessageDirection;
import org.eclipse.papyrus.uml.diagram.sequence.CustomMessages;
import org.eclipse.papyrus.uml.diagram.sequence.SequencePaletteFactory;
import org.eclipse.papyrus.uml.diagram.sequence.part.UMLDiagramEditorPlugin;
import org.eclipse.papyrus.uml.diagram.sequence.providers.ElementInitializers;
import org.eclipse.papyrus.uml.diagram.sequence.util.EventHelper;
import org.eclipse.papyrus.uml.diagram.sequence.util.GateHelper;
import org.eclipse.papyrus.uml.diagram.sequence.util.SelectOrCreateDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.uml2.uml.ActionExecutionSpecification;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.CombinedFragment;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.DestructionOccurrenceSpecification;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Event;
import org.eclipse.uml2.uml.ExecutionOccurrenceSpecification;
import org.eclipse.uml2.uml.ExecutionSpecification;
import org.eclipse.uml2.uml.Gate;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.InteractionFragment;
import org.eclipse.uml2.uml.InteractionOperand;
import org.eclipse.uml2.uml.InteractionOperatorKind;
import org.eclipse.uml2.uml.InteractionUse;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageEnd;
import org.eclipse.uml2.uml.MessageOccurrenceSpecification;
import org.eclipse.uml2.uml.MessageSort;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.OccurrenceSpecification;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Signal;
import org.eclipse.uml2.uml.StateInvariant;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.UMLPackage;

public class CommandHelper {
    private static final String NO_REFERENCED_INTERACTION_DIALOG_TITLE = "No referenced interaction";
    private static final String NO_REFERENCED_INTERACTION_DIALOG_MSG = "Couldn't had message if there isn't referenced interaction";
    private static final String WRONG_GATE_CONTAINER_TYPE_ERROR_MSG = "Wrong element UML type for create a gate";
    private static final String CHOOSE_GATE_DIALOG_TITLE = "Actual gates of the interaction use";
    private static final String CHOOSE_GATE_DIALOG_MSG = "Choose the gate to attach the message";

    public static Message doCreateMessage(Interaction interaction, MessageSort messageSort, NamedElement signature) {
        Message message = interaction.createMessage(null);
        message.setInteraction(interaction);
        message.setMessageSort(messageSort);
        String prefix = "";
        if (signature != null) {
            prefix = String.valueOf(signature.getName()) + "_";
        }
        ElementInitializers.init_NamedElement((NamedElement)message, prefix);
        if (signature != null) {
            message.setSignature(signature);
        }
        return message;
    }

    public static MessageOccurrenceSpecification doCreateMessageOccurrence(InteractionFragment fragment, Event event, Lifeline lifeline) {
        MessageOccurrenceSpecification mos = UMLFactory.eINSTANCE.createMessageOccurrenceSpecification();
        CommandHelper.doConfigureOccurenceSpecification((OccurrenceSpecification)mos, event, fragment, lifeline);
        return mos;
    }

    public static ExecutionOccurrenceSpecification doCreateExecutionOccurenceSpecification(ExecutionSpecification es, InteractionFragment fragment, Lifeline lifeline) {
        ExecutionOccurrenceSpecification eos = UMLFactory.eINSTANCE.createExecutionOccurrenceSpecification();
        CommandHelper.doConfigureOccurenceSpecification((OccurrenceSpecification)eos, null, fragment, lifeline);
        eos.setExecution(es);
        return eos;
    }

    private static void doConfigureOccurenceSpecification(OccurrenceSpecification os, Event event, InteractionFragment fragment, Lifeline lifeline) {
        if (fragment instanceof Interaction) {
            os.setEnclosingInteraction((Interaction)fragment);
        } else if (fragment instanceof InteractionOperand) {
            os.setEnclosingOperand((InteractionOperand)fragment);
        }
        os.getCovereds().add((Object)lifeline);
    }

    public static void setSingleCovered(Lifeline lifeline, InteractionFragment fragment) {
        if (!fragment.getCovereds().contains((Object)lifeline)) {
            fragment.getCovereds().add((Object)lifeline);
        }
    }

    public static List<NamedElement> getSignature(Element model, Element source, Element target) {
        return CommandHelper.getSignature(model, source, target, null);
    }

    public static List<NamedElement> getSignature(Element model, Element source, Element target, MessageSort messageSort) {
        TransactionalEditingDomain editingDomain;
        Element parentsOwner = target;
        boolean useOperations = true;
        boolean useSignals = true;
        if (MessageSort.SYNCH_CALL_LITERAL.equals((Object)messageSort)) {
            useSignals = false;
        } else if (MessageSort.CREATE_MESSAGE_LITERAL.equals((Object)messageSort) || MessageSort.DELETE_MESSAGE_LITERAL.equals((Object)messageSort)) {
            useOperations = false;
        } else if (MessageSort.REPLY_LITERAL.equals((Object)messageSort)) {
            parentsOwner = source;
            useSignals = false;
        }
        LinkedHashMap<EClass, List<EObject>> mapTypesPossibleParents = new LinkedHashMap<EClass, List<EObject>>();
        if (useSignals) {
            mapTypesPossibleParents.put(UMLPackage.eINSTANCE.getSignal(), new LinkedList());
        }
        if (useOperations) {
            mapTypesPossibleParents.put(UMLPackage.eINSTANCE.getOperation(), new LinkedList());
        }
        boolean existingParent = false;
        ArrayList<Type> types = new ArrayList<Type>();
        if (parentsOwner instanceof InteractionFragment) {
            EList lifelines = ((InteractionFragment)parentsOwner).getCovereds();
            for (Lifeline l : lifelines) {
                boolean result;
                if (l.getRepresents() != null && l.getRepresents().getType() != null) {
                    types.add(l.getRepresents().getType());
                }
                if (!(result = CommandHelper.addParentsFromLifeline(l, mapTypesPossibleParents))) continue;
                existingParent = true;
            }
        } else if (parentsOwner instanceof Lifeline) {
            Lifeline l = (Lifeline)parentsOwner;
            if (l.getRepresents() != null && l.getRepresents().getType() != null) {
                types.add(l.getRepresents().getType());
            }
            existingParent = CommandHelper.addParentsFromLifeline(l, mapTypesPossibleParents);
        }
        if (!existingParent) {
            return new ArrayList<NamedElement>();
        }
        Set<EObject> existingElements = CommandHelper.getExistingElementsFromParents(mapTypesPossibleParents);
        CommandHelper.clearConnectionFeedback();
        try {
            editingDomain = ServiceUtilsForEObject.getInstance().getTransactionalEditingDomain((Object)model);
        }
        catch (ServiceException ex) {
            UMLDiagramEditorPlugin.log.error((Throwable)ex);
            return Collections.emptyList();
        }
        SelectOrCreateDialog dialog = new SelectOrCreateDialog(Display.getCurrent().getActiveShell(), CustomMessages.CommandHelper_CreateMessage, (ILabelProvider)CommandHelper.createTypeLabelProvider(), (ILabelProvider)new AdapterFactoryLabelProvider(UMLDiagramEditorPlugin.getInstance().getItemProvidersAdapterFactory()), editingDomain, existingElements, mapTypesPossibleParents, types);
        if (dialog.open() == 0) {
            ArrayList<NamedElement> returnElements = new ArrayList<NamedElement>();
            EObject element = dialog.getSelected();
            if (element instanceof NamedElement) {
                returnElements.add((NamedElement)element);
                return returnElements;
            }
            return returnElements;
        }
        return null;
    }

    private static void clearConnectionFeedback() {
        DiagramEditor de;
        DiagramEditPart diagramEP;
        EditDomain domain;
        Tool tool;
        SequencePaletteFactory.AspectUnspecifiedTypeConnectionToolEx conTool = null;
        IEditorPart editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (editor instanceof CoreMultiDiagramEditor && (editor = ((CoreMultiDiagramEditor)editor).getActiveEditor()) instanceof DiagramEditor && (tool = (domain = (diagramEP = (de = (DiagramEditor)editor).getDiagramEditPart()).getRoot().getViewer().getEditDomain()).getActiveTool()) instanceof SequencePaletteFactory.AspectUnspecifiedTypeConnectionToolEx) {
            conTool = (SequencePaletteFactory.AspectUnspecifiedTypeConnectionToolEx)tool;
            conTool.clearConnectionFeedback();
        }
    }

    private static Set<EObject> getExistingElementsFromParents(Map<EClass, List<EObject>> mapTypesPossibleParents) {
        HashSet<EObject> existingElements = new HashSet<EObject>();
        for (EClass eClass : mapTypesPossibleParents.keySet()) {
            List<EObject> parents = mapTypesPossibleParents.get(eClass);
            for (EObject parent : parents) {
                if (parent instanceof Classifier) {
                    existingElements.addAll((Collection<EObject>)((Classifier)parent).getAllOperations());
                    EList attrs = ((Classifier)parent).getAllAttributes();
                    for (Property p : attrs) {
                        if (!(p instanceof Port) || !(p.getType() instanceof Classifier)) continue;
                        existingElements.addAll((Collection<EObject>)((Classifier)p.getType()).getAllOperations());
                    }
                    continue;
                }
                if (!(parent instanceof Package)) continue;
                EList ownedElements = ((Package)parent).allOwnedElements();
                for (Element e : ownedElements) {
                    if (!(e instanceof Signal)) continue;
                    existingElements.add((EObject)e);
                }
            }
        }
        return existingElements;
    }

    private static AdapterFactoryLabelProvider createTypeLabelProvider() {
        AdapterFactoryLabelProvider typeLabelProvider = new AdapterFactoryLabelProvider(UMLDiagramEditorPlugin.getInstance().getItemProvidersAdapterFactory()){

            public String getText(Object object) {
                String text = super.getText(object);
                int index = text.indexOf(" ");
                if (index != -1) {
                    text = text.substring(0, index);
                }
                return text;
            }
        };
        return typeLabelProvider;
    }

    private static boolean addParentsFromLifeline(Lifeline l, Map<EClass, List<EObject>> mapTypesPossibleParents) {
        List<EObject> possiblePackages;
        ConnectableElement e = l.getRepresents();
        boolean existingParent = false;
        if (e == null) {
            return false;
        }
        Type type = e.getType();
        if (type == null) {
            return false;
        }
        List<EObject> possibleClassifier = mapTypesPossibleParents.get(UMLPackage.eINSTANCE.getOperation());
        if (possibleClassifier != null && type instanceof Classifier) {
            Classifier classifier = (Classifier)type;
            possibleClassifier.add((EObject)classifier);
            possibleClassifier.addAll((Collection<EObject>)classifier.allParents());
            existingParent = true;
        }
        if ((possiblePackages = mapTypesPossibleParents.get(UMLPackage.eINSTANCE.getSignal())) != null && type.getPackage() != null) {
            Package package_ = type.getPackage();
            possiblePackages.add((EObject)package_);
            possiblePackages.addAll((Collection<EObject>)package_.allOwningPackages());
            existingParent = true;
        }
        return existingParent;
    }

    public static Property getProperties(List<Property> availableProperties) {
        AdapterFactoryLabelProvider labelProvider = new AdapterFactoryLabelProvider(UMLDiagramEditorPlugin.getInstance().getItemProvidersAdapterFactory());
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(Display.getCurrent().getActiveShell(), (ILabelProvider)labelProvider);
        dialog.setTitle("Property Selection");
        dialog.setMessage("Select a property (* = any string, ? = any char):");
        if (availableProperties == null || availableProperties.isEmpty()) {
            return null;
        }
        dialog.setElements(availableProperties.toArray());
        Property element = null;
        int dialogResult = dialog.open();
        if (dialogResult == 0 && !"".equals(dialog.getFirstResult())) {
            element = (Property)dialog.getFirstResult();
        }
        return element;
    }

    public static void executeCommandWithoutHistory(EditingDomain editingDomain, Command command) {
        try {
            CommandStack commandStack = editingDomain.getCommandStack();
            if (commandStack instanceof TransactionalCommandStack) {
                ((TransactionalCommandStack)commandStack).execute(command, Collections.singletonMap("unprotected", Boolean.TRUE));
            } else {
                commandStack.execute(command);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (RollbackException e) {
            e.printStackTrace();
        }
    }

    public static void executeCommandWithoutHistory(EditingDomain editingDomain, Command command, boolean flag) {
        TransactionalCommandStackImpl stack = new TransactionalCommandStackImpl();
        stack.setEditingDomain((InternalTransactionalEditingDomain)editingDomain);
        try {
            stack.execute(command, Collections.singletonMap("unprotected", Boolean.TRUE));
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (RollbackException e) {
            e.printStackTrace();
        }
    }

    public static Lifeline getExecutionSpecificationLifeline(ExecutionSpecification es) {
        Lifeline lifeline = null;
        if (es.getStart() != null) {
            lifeline = (Lifeline)es.getStart().getCovereds().get(0);
        } else if (es.getFinish() != null) {
            lifeline = (Lifeline)es.getFinish().getCovereds().get(0);
        }
        if (lifeline == null && !es.getCovereds().isEmpty()) {
            lifeline = (Lifeline)es.getCovereds().get(0);
        }
        return lifeline;
    }

    public static DestructionOccurrenceSpecification doCreateDestructionOccurrenceSpecification(Lifeline lifeline, Object modelContainer) {
        Package pack = lifeline.getNearestPackage();
        Element element = CommandHelper.createElement(modelContainer, UMLPackage.eINSTANCE.getDestructionOccurrenceSpecification());
        DestructionOccurrenceSpecification os = null;
        if (element instanceof DestructionOccurrenceSpecification) {
            os = (DestructionOccurrenceSpecification)element;
            CommandHelper.doConfigureOccurenceSpecification((OccurrenceSpecification)os, null, (InteractionFragment)modelContainer, lifeline);
        }
        return os;
    }

    public static StateInvariant doCreateStateInvariant(Lifeline lifeline, Object modelContainer) {
        StateInvariant stateInvariant = null;
        Element element = CommandHelper.createElement(modelContainer, UMLPackage.eINSTANCE.getStateInvariant());
        if (element instanceof StateInvariant) {
            stateInvariant = (StateInvariant)element;
            stateInvariant.getCovereds().add((Object)lifeline);
            stateInvariant.createInvariant("");
        }
        return stateInvariant;
    }

    private static Element createElement(Object modelContainer, EClass eClass) {
        if (modelContainer instanceof InteractionOperand) {
            InteractionOperand interactionOperand = (InteractionOperand)modelContainer;
            return interactionOperand.createFragment(ElementInitializers.getNextNumberedName((Collection)interactionOperand.getFragments(), eClass.getName()), eClass);
        }
        if (modelContainer instanceof Interaction) {
            Interaction interaction = (Interaction)modelContainer;
            return interaction.createFragment(ElementInitializers.getNextNumberedName((Collection)interaction.getFragments(), eClass.getName()), eClass);
        }
        return null;
    }

    public static CombinedFragment doCreateCombinedFragment(Object modelContainer, InteractionOperatorKind operatorKind, Collection coveredLifelines) {
        CombinedFragment combinedFragment = null;
        Element element = CommandHelper.createElement(modelContainer, UMLPackage.eINSTANCE.getCombinedFragment());
        if (element instanceof CombinedFragment) {
            combinedFragment = (CombinedFragment)element;
            combinedFragment.getCovereds().addAll(coveredLifelines);
            combinedFragment.setInteractionOperator(operatorKind);
            CommandHelper.createCoRegionInteractionOperand(combinedFragment);
        }
        return combinedFragment;
    }

    public static CombinedFragment doCreateCoRegion(Object modelContainer, Lifeline coveredLifeline) {
        Element element = CommandHelper.createElement(modelContainer, UMLPackage.eINSTANCE.getCombinedFragment());
        if (element instanceof CombinedFragment) {
            CombinedFragment combinedFragment = (CombinedFragment)element;
            combinedFragment = (CombinedFragment)element;
            combinedFragment.getCovereds().add((Object)coveredLifeline);
            combinedFragment.setInteractionOperator(InteractionOperatorKind.PAR_LITERAL);
            return combinedFragment;
        }
        return null;
    }

    public static ExecutionSpecification doCreateExecutionSpecification(ExecutionSpecification es, Lifeline lifeline, Object modelContainer) {
        InteractionOperand interactionFragment = null;
        if (modelContainer instanceof InteractionOperand) {
            InteractionOperand interactionOperand;
            interactionFragment = interactionOperand = (InteractionOperand)modelContainer;
        } else {
            Interaction interaction = lifeline.getInteraction();
            interactionFragment = interaction;
        }
        Package eventContainer = interactionFragment.getNearestPackage();
        ExecutionOccurrenceSpecification start = CommandHelper.doCreateExecutionOccurenceSpecification(null, (InteractionFragment)interactionFragment, lifeline);
        if (modelContainer instanceof InteractionOperand) {
            InteractionOperand interactionOperand = (InteractionOperand)modelContainer;
            es = (ExecutionSpecification)interactionOperand.createFragment(null, es.eClass());
        } else {
            Interaction interaction = lifeline.getInteraction();
            es = (ExecutionSpecification)interaction.createFragment(null, es.eClass());
        }
        ExecutionOccurrenceSpecification finish = CommandHelper.doCreateExecutionOccurenceSpecification(es, (InteractionFragment)interactionFragment, lifeline);
        es.getCovereds().add((Object)lifeline);
        es.setStart((OccurrenceSpecification)start);
        es.setFinish((OccurrenceSpecification)finish);
        start.setExecution(es);
        CommandHelper.initExecutionSpecificationName(es);
        return es;
    }

    private static void initExecutionSpecificationName(ExecutionSpecification es) {
        String body = "";
        body = es instanceof ActionExecutionSpecification ? "ActionExecSpec" : "BehaviorExecSpec";
        ElementInitializers.init_NamedElement((NamedElement)es, "", body, "");
        ElementInitializers.init_NamedElement((NamedElement)es.getStart(), "", es.getName(), "Start");
        ElementInitializers.init_NamedElement((NamedElement)es.getFinish(), "", es.getName(), "Finish");
    }

    public static MessageEnd createMessageEnd(InteractionFragment interactionFragment, Event event, Element element, MessageDirection direction) {
        MessageEnd endMsg = null;
        if (element instanceof MessageEnd) {
            endMsg = (MessageEnd)element;
        } else if (element instanceof Lifeline) {
            endMsg = CommandHelper.doCreateMessageOccurrence(interactionFragment, event, (Lifeline)element);
        } else if (element instanceof ExecutionSpecification) {
            Lifeline lifeline = CommandHelper.getExecutionSpecificationLifeline((ExecutionSpecification)element);
            endMsg = CommandHelper.doCreateMessageOccurrence(interactionFragment, event, lifeline);
        } else if (element instanceof Interaction || element instanceof CombinedFragment || element instanceof InteractionUse) {
            endMsg = CommandHelper.doCreateGate(element, direction);
        } else if (element instanceof ExecutionOccurrenceSpecification) {
            endMsg = CommandHelper.createMessageEnd(interactionFragment, event, (Element)((ExecutionOccurrenceSpecification)element).getExecution(), direction);
        }
        return endMsg;
    }

    public static Gate doCreateGate(Element element, MessageDirection direction) {
        Gate gate = GateHelper.createGate(element, true);
        if (element instanceof CombinedFragment) {
            GateHelper.setVolatile(gate, true);
        }
        if (gate != null && gate.getName() == null) {
            ElementInitializers.init_NamedElement((NamedElement)gate, String.valueOf(direction.toString().toLowerCase()) + "_");
        }
        return gate;
    }

    public static Message doCreateMessage(Interaction interaction, MessageSort messageSort, Element source, Element target, Map<Object, Object> params) {
        InteractionFragment sourceContainer = (InteractionFragment)params.get("Source model container");
        InteractionFragment targetContainer = (InteractionFragment)params.get("Target model container");
        Lifeline lifeline = (Lifeline)params.get("Lifeline graphical container");
        if (lifeline != null) {
            CombinedFragment cf;
            if (source instanceof CombinedFragment) {
                CombinedFragment cf2 = (CombinedFragment)source;
                if (InteractionOperatorKind.PAR_LITERAL.equals((Object)cf2.getInteractionOperator())) {
                    InteractionOperand interactionOperand = CommandHelper.getCoRegionInteractionOperand(cf2);
                    sourceContainer = interactionOperand;
                    targetContainer = interactionOperand;
                    source = lifeline;
                    if (target instanceof Lifeline) {
                        CommandHelper.addCoveredLifelineToCombinedFragment((Lifeline)target, cf2);
                    }
                }
            } else if (target instanceof CombinedFragment && InteractionOperatorKind.PAR_LITERAL.equals((Object)(cf = (CombinedFragment)target).getInteractionOperator())) {
                InteractionOperand interactionOperand = CommandHelper.getCoRegionInteractionOperand(cf);
                sourceContainer = interactionOperand;
                targetContainer = interactionOperand;
                target = lifeline;
                if (source instanceof Lifeline) {
                    CommandHelper.addCoveredLifelineToCombinedFragment((Lifeline)source, cf);
                }
            }
        }
        return CommandHelper.doCreateMessage(interaction, messageSort, source, target, sourceContainer, targetContainer);
    }

    private static void addCoveredLifelineToCombinedFragment(Lifeline coveredLifeline, CombinedFragment cf) {
        cf.getCovereds().add((Object)coveredLifeline);
        for (InteractionOperand io : cf.getOperands()) {
            io.getCovereds().add((Object)coveredLifeline);
        }
    }

    public static InteractionOperand getCoRegionInteractionOperand(CombinedFragment cf) {
        InteractionOperand interactionOperand = null;
        for (InteractionOperand existingOperand : cf.getOperands()) {
            if (!existingOperand.getFragments().isEmpty()) continue;
            interactionOperand = existingOperand;
            break;
        }
        if (interactionOperand == null) {
            interactionOperand = CommandHelper.createCoRegionInteractionOperand(cf);
        }
        return interactionOperand;
    }

    private static InteractionOperand createCoRegionInteractionOperand(CombinedFragment cf) {
        InteractionOperand interactionOperand = cf.createOperand("");
        interactionOperand.getCovereds().addAll((Collection)cf.getCovereds());
        interactionOperand.setName(ElementInitializers.getNextNumberedName((Collection)cf.getOperands(), interactionOperand.eClass().getName()));
        return interactionOperand;
    }

    public static Message doCreateMessage(Interaction container, MessageSort messageSort, Element source, Element target, InteractionFragment sourceContainer, InteractionFragment targetContainer) {
        return CommandHelper.doCreateMessage(container, messageSort, source, target, sourceContainer, targetContainer, null, null);
    }

    public static Message doCreateMessage(Interaction container, MessageSort messageSort, Element source, Element target, InteractionFragment sourceContainer, InteractionFragment targetContainer, MessageEnd sendMessageEnd, MessageEnd receiveMessageEnd) {
        Gate outerCFGate;
        Gate outerGate;
        List<NamedElement> signatures = CommandHelper.getSignature((Element)container.getModel(), source, target, messageSort);
        if (signatures == null) {
            return null;
        }
        NamedElement signature = null;
        if (!signatures.isEmpty()) {
            signature = signatures.get(0);
        }
        messageSort = CommandHelper.getMessageSort(signature, messageSort);
        Message message = CommandHelper.doCreateMessage(container, messageSort, signature);
        if (sendMessageEnd == null && source != null) {
            sendMessageEnd = CommandHelper.createMessageEnd(sourceContainer, EventHelper.doCreateSendEvent(messageSort, container, signature), source, MessageDirection.OUT);
        }
        if (receiveMessageEnd == null && target != null) {
            receiveMessageEnd = CommandHelper.createMessageEnd(targetContainer, EventHelper.doCreateReceiveEvent(messageSort, container, signature), target, MessageDirection.IN);
        }
        if (sendMessageEnd != null) {
            sendMessageEnd.setMessage(message);
            if (sendMessageEnd.getName() == null) {
                ElementInitializers.init_NamedElement((NamedElement)sendMessageEnd, "", message.getName(), "Send");
            }
            message.setSendEvent(sendMessageEnd);
        }
        if (receiveMessageEnd != null) {
            receiveMessageEnd.setMessage(message);
            if (receiveMessageEnd.getName() == null) {
                ElementInitializers.init_NamedElement((NamedElement)receiveMessageEnd, "", message.getName(), "Recv");
            }
            message.setReceiveEvent(receiveMessageEnd);
        }
        if (sendMessageEnd instanceof Gate && GateHelper.isInnerCFGate((Gate)sendMessageEnd) && (outerGate = GateHelper.getOuterCFGate((Gate)sendMessageEnd)) != null && outerGate.getMessage() != null) {
            message.setName(outerGate.getMessage().getName());
        }
        if (receiveMessageEnd instanceof Gate && GateHelper.isInnerCFGate((Gate)receiveMessageEnd) && (outerCFGate = GateHelper.getOuterCFGate((Gate)receiveMessageEnd)) != null && outerCFGate.getMessage() != null) {
            message.setName(outerCFGate.getMessage().getName());
        }
        GateHelper.updateGateWithMessage(message, false);
        return message;
    }

    private static MessageSort getMessageSort(NamedElement signature, MessageSort messageSort) {
        if (messageSort == null) {
            if (signature instanceof Signal) {
                return MessageSort.ASYNCH_SIGNAL_LITERAL;
            }
            return MessageSort.ASYNCH_CALL_LITERAL;
        }
        return messageSort;
    }

    public static boolean hasValidContainer(IEditCommandRequest request) {
        Object srcEndContainer = request.getParameter("Source model container");
        Object tgtEndContainer = request.getParameter("Target model container");
        if (srcEndContainer == null || tgtEndContainer == null) {
            return false;
        }
        if (srcEndContainer.equals(tgtEndContainer)) {
            return true;
        }
        if (request instanceof CreateRelationshipRequest) {
            EObject src = ((CreateRelationshipRequest)request).getSource();
            EObject tgt = ((CreateRelationshipRequest)request).getTarget();
            if (!(src instanceof Lifeline)) {
                if (src instanceof InteractionOperand) {
                    src = src.eContainer();
                } else if (src instanceof Gate) {
                    src = ((Gate)src).eContainer();
                }
                if (src instanceof InteractionFragment) {
                    if (tgtEndContainer instanceof Interaction && ((Interaction)tgtEndContainer).getFragments().contains((Object)src)) {
                        return true;
                    }
                    if (tgtEndContainer instanceof InteractionOperand && ((InteractionOperand)tgtEndContainer).getFragments().contains((Object)src)) {
                        return true;
                    }
                }
            }
            if (!(tgt instanceof Lifeline)) {
                if (tgt instanceof InteractionOperand) {
                    tgt = tgt.eContainer();
                } else if (tgt instanceof Gate) {
                    tgt = ((Gate)tgt).eContainer();
                }
                if (tgt instanceof InteractionFragment) {
                    if (srcEndContainer instanceof Interaction && ((Interaction)srcEndContainer).getFragments().contains((Object)tgt)) {
                        return true;
                    }
                    if (srcEndContainer instanceof InteractionOperand && ((InteractionOperand)srcEndContainer).getFragments().contains((Object)tgt)) {
                        return true;
                    }
                }
            }
        }
        return false;
    }
}

