/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.part;

import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.tooling.runtime.structure.DiagramStructure;
import org.eclipse.papyrus.uml.diagram.common.helper.DurationConstraintHelper;
import org.eclipse.papyrus.uml.diagram.common.helper.DurationObservationHelper;
import org.eclipse.papyrus.uml.diagram.sequence.expressions.UMLOCLFactory;
import org.eclipse.papyrus.uml.diagram.sequence.part.UMLDiagramEditorPlugin;
import org.eclipse.uml2.uml.DurationConstraint;
import org.eclipse.uml2.uml.DurationObservation;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.OccurrenceSpecification;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.UMLPackage;

public class UMLVisualIDRegistry {
    private static final String DEBUG_KEY = "org.eclipse.papyrus.uml.diagram.sequence/debug/visualID";
    public static final DiagramStructure TYPED_INSTANCE = new DiagramStructure(){

        public int getVisualID(View view) {
            return UMLVisualIDRegistry.getVisualID(view);
        }

        public String getModelID(View view) {
            return UMLVisualIDRegistry.getModelID(view);
        }

        public int getNodeVisualID(View containerView, EObject domainElement) {
            return UMLVisualIDRegistry.getNodeVisualID(containerView, domainElement);
        }

        public boolean checkNodeVisualID(View containerView, EObject domainElement, int candidate) {
            return UMLVisualIDRegistry.checkNodeVisualID(containerView, domainElement, candidate);
        }

        public boolean isCompartmentVisualID(int visualID) {
            return UMLVisualIDRegistry.isCompartmentVisualID(visualID);
        }

        public boolean isSemanticLeafVisualID(int visualID) {
            return UMLVisualIDRegistry.isSemanticLeafVisualID(visualID);
        }
    };

    public static int getVisualID(View view) {
        if (view instanceof Diagram) {
            if ("PapyrusUMLSequenceDiagram".equals(view.getType())) {
                return 1000;
            }
            return -1;
        }
        return UMLVisualIDRegistry.getVisualID(view.getType());
    }

    public static String getModelID(View view) {
        Diagram diagram = view.getDiagram();
        while (view != diagram) {
            EAnnotation annotation = view.getEAnnotation("Shortcut");
            if (annotation != null) {
                return (String)annotation.getDetails().get((Object)"modelID");
            }
            view = (View)view.eContainer();
        }
        return diagram != null ? diagram.getType() : null;
    }

    public static int getVisualID(String type) {
        try {
            return Integer.parseInt(type);
        }
        catch (NumberFormatException e) {
            if (Boolean.TRUE.toString().equalsIgnoreCase(Platform.getDebugOption((String)DEBUG_KEY))) {
                UMLDiagramEditorPlugin.getInstance().logError("Unable to parse view type as a visualID number: " + type);
            }
            return -1;
        }
    }

    public static String getType(int visualID) {
        return Integer.toString(visualID);
    }

    public static int getDiagramVisualID(EObject domainElement) {
        return 1000;
    }

    public static int getNodeVisualID(View containerView, EObject domainElement) {
        int containerVisualID;
        if (domainElement == null) {
            return -1;
        }
        String containerModelID = UMLVisualIDRegistry.getModelID(containerView);
        if (!"PapyrusUMLSequenceDiagram".equals(containerModelID)) {
            return -1;
        }
        if ("PapyrusUMLSequenceDiagram".equals(containerModelID)) {
            containerVisualID = UMLVisualIDRegistry.getVisualID(containerView);
        } else if (containerView instanceof Diagram) {
            containerVisualID = 1000;
        } else {
            return -1;
        }
        switch (containerVisualID) {
            case 1000: {
                if (!UMLPackage.eINSTANCE.getInteraction().isSuperTypeOf(domainElement.eClass())) break;
                return 2001;
            }
            case 2001: {
                if (UMLPackage.eINSTANCE.getDurationConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3023;
                }
                if (!UMLPackage.eINSTANCE.getDurationObservation().isSuperTypeOf(domainElement.eClass())) break;
                return 3024;
            }
            case 3005: {
                if (UMLPackage.eINSTANCE.getInteractionUse().isSuperTypeOf(domainElement.eClass())) {
                    return 3002;
                }
                if (UMLPackage.eINSTANCE.getConsiderIgnoreFragment().isSuperTypeOf(domainElement.eClass())) {
                    return 3007;
                }
                if (UMLPackage.eINSTANCE.getCombinedFragment().isSuperTypeOf(domainElement.eClass())) {
                    return 3004;
                }
                if (!UMLPackage.eINSTANCE.getContinuation().isSuperTypeOf(domainElement.eClass())) break;
                return 3016;
            }
            case 3001: {
                EList occurrences;
                if (UMLPackage.eINSTANCE.getActionExecutionSpecification().isSuperTypeOf(domainElement.eClass())) {
                    return 3006;
                }
                if (UMLPackage.eINSTANCE.getBehaviorExecutionSpecification().isSuperTypeOf(domainElement.eClass())) {
                    return 3003;
                }
                if (UMLPackage.eINSTANCE.getStateInvariant().isSuperTypeOf(domainElement.eClass())) {
                    return 3017;
                }
                if (UMLPackage.eINSTANCE.getCombinedFragment().isSuperTypeOf(domainElement.eClass())) {
                    return 3018;
                }
                if (UMLPackage.eINSTANCE.getTimeConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3019;
                }
                if (UMLPackage.eINSTANCE.getTimeObservation().isSuperTypeOf(domainElement.eClass())) {
                    return 3020;
                }
                if (UMLPackage.eINSTANCE.getDurationConstraint().isSuperTypeOf(domainElement.eClass())) {
                    EList occurrences2 = ((DurationConstraint)domainElement).getConstrainedElements();
                    if (occurrences2.size() >= 2 && occurrences2.get(0) instanceof OccurrenceSpecification && occurrences2.get(1) instanceof OccurrenceSpecification && DurationConstraintHelper.endsOfSameMessage((OccurrenceSpecification)((OccurrenceSpecification)occurrences2.get(0)), (OccurrenceSpecification)((OccurrenceSpecification)occurrences2.get(1)))) {
                        return 3023;
                    }
                    return 3021;
                }
                if (UMLPackage.eINSTANCE.getDurationObservation().isSuperTypeOf(domainElement.eClass()) && (occurrences = ((DurationObservation)domainElement).getEvents()).size() >= 2 && occurrences.get(0) instanceof OccurrenceSpecification && occurrences.get(1) instanceof OccurrenceSpecification && DurationObservationHelper.endsOfSameMessage((OccurrenceSpecification)((OccurrenceSpecification)occurrences.get(0)), (OccurrenceSpecification)((OccurrenceSpecification)occurrences.get(1)))) {
                    return 3024;
                }
                if (UMLPackage.eINSTANCE.getDestructionOccurrenceSpecification().isSuperTypeOf(domainElement.eClass())) {
                    return 3022;
                }
                if (!UMLPackage.eINSTANCE.getLifeline().isSuperTypeOf(domainElement.eClass())) break;
                return 3001;
            }
            case 7001: {
                if (UMLPackage.eINSTANCE.getConsiderIgnoreFragment().isSuperTypeOf(domainElement.eClass())) {
                    return 3007;
                }
                if (UMLPackage.eINSTANCE.getCombinedFragment().isSuperTypeOf(domainElement.eClass())) {
                    return 3004;
                }
                if (UMLPackage.eINSTANCE.getLifeline().isSuperTypeOf(domainElement.eClass())) {
                    return 3001;
                }
                if (UMLPackage.eINSTANCE.getInteractionOperand().isSuperTypeOf(domainElement.eClass())) {
                    return 3005;
                }
                if (UMLPackage.eINSTANCE.getInteractionUse().isSuperTypeOf(domainElement.eClass())) {
                    return 3002;
                }
                if (UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3008;
                }
                if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                    return 3009;
                }
                if (UMLPackage.eINSTANCE.getTimeObservation().isSuperTypeOf(domainElement.eClass())) {
                    return 3020;
                }
                if (!UMLPackage.eINSTANCE.getDurationObservation().isSuperTypeOf(domainElement.eClass())) break;
                return 3024;
            }
            case 7004: {
                if (UMLPackage.eINSTANCE.getInteractionOperand().isSuperTypeOf(domainElement.eClass())) {
                    return 3005;
                }
                if (UMLPackage.eINSTANCE.getContinuation().isSuperTypeOf(domainElement.eClass())) {
                    return 3016;
                }
                if (!UMLPackage.eINSTANCE.getCombinedFragment().isSuperTypeOf(domainElement.eClass())) break;
                return 3004;
            }
            case 4003: 
            case 4004: 
            case 4005: 
            case 4006: 
            case 4007: 
            case 4008: 
            case 4009: {
                if (UMLPackage.eINSTANCE.getDurationConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3023;
                }
                if (!UMLPackage.eINSTANCE.getDurationObservation().isSuperTypeOf(domainElement.eClass())) break;
                return 3024;
            }
        }
        return -1;
    }

    public static boolean canCreateNode(View containerView, int nodeVisualID) {
        int containerVisualID;
        String containerModelID = UMLVisualIDRegistry.getModelID(containerView);
        if (!"PapyrusUMLSequenceDiagram".equals(containerModelID)) {
            return false;
        }
        if ("PapyrusUMLSequenceDiagram".equals(containerModelID)) {
            containerVisualID = UMLVisualIDRegistry.getVisualID(containerView);
        } else if (containerView instanceof Diagram) {
            containerVisualID = 1000;
        } else {
            return false;
        }
        switch (containerVisualID) {
            case 1000: {
                if (2001 != nodeVisualID) break;
                return true;
            }
            case 2001: {
                if (5001 == nodeVisualID) {
                    return true;
                }
                if (7001 == nodeVisualID) {
                    return true;
                }
                if (3023 == nodeVisualID) {
                    return true;
                }
                if (3024 != nodeVisualID) break;
                return true;
            }
            case 3004: {
                if (7004 != nodeVisualID) break;
                return true;
            }
            case 3005: {
                if (3002 == nodeVisualID) {
                    return true;
                }
                if (3007 == nodeVisualID) {
                    return true;
                }
                if (3004 == nodeVisualID) {
                    return true;
                }
                if (3016 != nodeVisualID) break;
                return true;
            }
            case 3002: {
                if (5003 == nodeVisualID) {
                    return true;
                }
                if (5004 != nodeVisualID) break;
                return true;
            }
            case 3016: {
                if (5007 != nodeVisualID) break;
                return true;
            }
            case 3001: {
                if (3001 == nodeVisualID) {
                    return true;
                }
                if (5002 == nodeVisualID) {
                    return true;
                }
                if (3006 == nodeVisualID) {
                    return true;
                }
                if (3003 == nodeVisualID) {
                    return true;
                }
                if (3017 == nodeVisualID) {
                    return true;
                }
                if (3018 == nodeVisualID) {
                    return true;
                }
                if (3019 == nodeVisualID) {
                    return true;
                }
                if (3020 == nodeVisualID) {
                    return true;
                }
                if (3021 == nodeVisualID) {
                    return true;
                }
                if (3022 != nodeVisualID) break;
                return true;
            }
            case 3017: {
                if (5008 != nodeVisualID) break;
                return true;
            }
            case 3019: {
                if (5009 == nodeVisualID) {
                    return true;
                }
                if (5013 != nodeVisualID) break;
                return true;
            }
            case 3020: {
                if (5010 == nodeVisualID) {
                    return true;
                }
                if (5014 != nodeVisualID) break;
                return true;
            }
            case 3021: {
                if (5011 == nodeVisualID) {
                    return true;
                }
                if (5015 != nodeVisualID) break;
                return true;
            }
            case 3008: {
                if (5005 == nodeVisualID) {
                    return true;
                }
                if (5012 != nodeVisualID) break;
                return true;
            }
            case 3009: {
                if (5006 != nodeVisualID) break;
                return true;
            }
            case 3023: {
                if (5018 == nodeVisualID) {
                    return true;
                }
                if (5019 != nodeVisualID) break;
                return true;
            }
            case 3024: {
                if (5016 == nodeVisualID) {
                    return true;
                }
                if (5017 != nodeVisualID) break;
                return true;
            }
            case 7001: {
                if (3007 == nodeVisualID) {
                    return true;
                }
                if (3004 == nodeVisualID) {
                    return true;
                }
                if (3001 == nodeVisualID) {
                    return true;
                }
                if (3002 == nodeVisualID) {
                    return true;
                }
                if (3008 == nodeVisualID) {
                    return true;
                }
                if (3009 == nodeVisualID) {
                    return true;
                }
                if (3020 == nodeVisualID) {
                    return true;
                }
                if (3024 != nodeVisualID) break;
                return true;
            }
            case 7004: {
                if (3005 != nodeVisualID) break;
                return true;
            }
            case 4003: {
                if (6001 == nodeVisualID) {
                    return true;
                }
                if (6008 != nodeVisualID) break;
                return true;
            }
            case 4004: {
                if (6002 == nodeVisualID) {
                    return true;
                }
                if (6009 != nodeVisualID) break;
                return true;
            }
            case 4005: {
                if (6003 == nodeVisualID) {
                    return true;
                }
                if (6010 != nodeVisualID) break;
                return true;
            }
            case 4006: {
                if (6004 == nodeVisualID) {
                    return true;
                }
                if (6011 != nodeVisualID) break;
                return true;
            }
            case 4007: {
                if (6005 == nodeVisualID) {
                    return true;
                }
                if (6012 != nodeVisualID) break;
                return true;
            }
            case 4008: {
                if (6006 == nodeVisualID) {
                    return true;
                }
                if (6013 != nodeVisualID) break;
                return true;
            }
            case 4009: {
                if (6007 == nodeVisualID) {
                    return true;
                }
                if (6014 != nodeVisualID) break;
                return true;
            }
            case 4012: {
                if (6015 != nodeVisualID) break;
                return true;
            }
        }
        return false;
    }

    public static int getLinkWithClassVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        if (UMLPackage.eINSTANCE.getMessage().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isMessage_4003((Message)domainElement)) {
            return 4003;
        }
        if (UMLPackage.eINSTANCE.getMessage().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isMessage_4004((Message)domainElement)) {
            return 4004;
        }
        if (UMLPackage.eINSTANCE.getMessage().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isMessage_4005((Message)domainElement)) {
            return 4005;
        }
        if (UMLPackage.eINSTANCE.getMessage().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isMessage_4006((Message)domainElement)) {
            return 4006;
        }
        if (UMLPackage.eINSTANCE.getMessage().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isMessage_4007((Message)domainElement)) {
            return 4007;
        }
        if (UMLPackage.eINSTANCE.getMessage().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isMessage_4008((Message)domainElement)) {
            return 4008;
        }
        if (UMLPackage.eINSTANCE.getMessage().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isMessage_4009((Message)domainElement)) {
            return 4009;
        }
        if (UMLPackage.eINSTANCE.getGeneralOrdering().isSuperTypeOf(domainElement.eClass())) {
            return 4012;
        }
        return -1;
    }

    private static boolean isDiagram(Package element) {
        return true;
    }

    private static boolean isMessage_4003(Message domainElement) {
        Object result = UMLOCLFactory.getExpression(1, (EClassifier)UMLPackage.eINSTANCE.getMessage(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isMessage_4004(Message domainElement) {
        Object result = UMLOCLFactory.getExpression(4, (EClassifier)UMLPackage.eINSTANCE.getMessage(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isMessage_4005(Message domainElement) {
        Object result = UMLOCLFactory.getExpression(7, (EClassifier)UMLPackage.eINSTANCE.getMessage(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isMessage_4006(Message domainElement) {
        Object result = UMLOCLFactory.getExpression(10, (EClassifier)UMLPackage.eINSTANCE.getMessage(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isMessage_4007(Message domainElement) {
        Object result = UMLOCLFactory.getExpression(13, (EClassifier)UMLPackage.eINSTANCE.getMessage(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isMessage_4008(Message domainElement) {
        Object result = UMLOCLFactory.getExpression(16, (EClassifier)UMLPackage.eINSTANCE.getMessage(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isMessage_4009(Message domainElement) {
        Object result = UMLOCLFactory.getExpression(19, (EClassifier)UMLPackage.eINSTANCE.getMessage(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    public static boolean checkNodeVisualID(View containerView, EObject domainElement, int candidate) {
        if (candidate == -1) {
            return false;
        }
        int basic = UMLVisualIDRegistry.getNodeVisualID(containerView, domainElement);
        return basic == candidate;
    }

    public static boolean isCompartmentVisualID(int visualID) {
        switch (visualID) {
            case 7001: 
            case 7004: {
                return true;
            }
        }
        return false;
    }

    public static boolean isSemanticLeafVisualID(int visualID) {
        switch (visualID) {
            case 1000: {
                return false;
            }
            case 3002: 
            case 3003: 
            case 3006: 
            case 3007: 
            case 3008: 
            case 3009: 
            case 3016: 
            case 3017: 
            case 3018: 
            case 3019: 
            case 3020: 
            case 3021: 
            case 3022: 
            case 3023: 
            case 3024: {
                return true;
            }
        }
        return false;
    }
}

