/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.parts;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Shape;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.InteractionInteractionCompartmentEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.LifelineEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.figures.LifelineDotLineCustomFigure;
import org.eclipse.papyrus.uml.diagram.sequence.util.CommandHelper;
import org.eclipse.uml2.uml.InteractionFragment;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.PartDecomposition;
import org.eclipse.uml2.uml.UMLPackage;

public abstract class InteractionFragmentEditPart
extends ShapeNodeEditPart {
    public InteractionFragmentEditPart(View view) {
        super(view);
    }

    public void resizeInteractionFragmentFigure() {
        List childrenEditPart;
        EList lifelineCoveredList;
        EObject element;
        Object obj = this.getModel();
        if (obj instanceof Shape && (element = ((Shape)obj).getElement()) instanceof InteractionFragment && (lifelineCoveredList = ((InteractionFragment)element).getCovereds()) != null && this.getParent() != null && (childrenEditPart = this.getParent().getChildren()) != null) {
            int minX = Integer.MAX_VALUE;
            int maxX = -2147483647;
            int maxR = -2147483647;
            for (EditPart childEditPart : childrenEditPart) {
                EObject childElement;
                Object childModel;
                if (!(childEditPart instanceof LifelineEditPart) || !((childModel = childEditPart.getModel()) instanceof Shape) || !((childElement = ((Shape)childModel).getElement()) instanceof Lifeline)) continue;
                Lifeline lifeline = (Lifeline)childElement;
                for (Lifeline lfn : lifelineCoveredList) {
                    if (!lifeline.equals(lfn)) continue;
                    LifelineEditPart liflelineEditPart = (LifelineEditPart)childEditPart;
                    if (liflelineEditPart.getFigure().getBounds().x > maxX) {
                        maxX = liflelineEditPart.getFigure().getBounds().x;
                        maxR = liflelineEditPart.getFigure().getBounds().right();
                    }
                    if (liflelineEditPart.getFigure().getBounds().x >= minX) continue;
                    minX = liflelineEditPart.getFigure().getBounds().x;
                }
            }
            if (minX != Integer.MAX_VALUE || maxR != -2147483647) {
                this.getNewSize(minX, maxR);
            }
        }
    }

    private void getNewSize(int min, int max) {
        int h = this.getFigure().getBounds().height;
        int y = this.getFigure().getBounds().y;
        Dimension size = new Dimension(max - min, h);
        Point loc = new Point(min, y);
        ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.getFigure(), (Object)new Rectangle(loc, size));
    }

    public void updateCoveredLifelines(Bounds newBounds) {
        Rectangle newBound = new Rectangle(newBounds.getX(), newBounds.getY(), newBounds.getWidth(), newBounds.getHeight());
        InteractionFragment combinedFragment = (InteractionFragment)this.resolveSemanticElement();
        EList coveredLifelines = combinedFragment.getCovereds();
        ArrayList<Lifeline> coveredLifelinesToAdd = new ArrayList<Lifeline>();
        ArrayList<Lifeline> coveredLifelinesToRemove = new ArrayList<Lifeline>();
        EditPart interactionCompartment = this.getInteractionCompartment();
        if (interactionCompartment != null) {
            this.getFigure().translateToAbsolute((Translatable)newBound);
            for (Object child : interactionCompartment.getChildren()) {
                if (!(child instanceof LifelineEditPart)) continue;
                LifelineEditPart lifelineEditPart = (LifelineEditPart)((Object)child);
                this.updateCoveredLifelines(lifelineEditPart, newBound, coveredLifelinesToAdd, coveredLifelinesToRemove, (EList<Lifeline>)coveredLifelines);
            }
        }
        if (!coveredLifelinesToAdd.isEmpty()) {
            CommandHelper.executeCommandWithoutHistory((EditingDomain)this.getEditingDomain(), AddCommand.create((EditingDomain)this.getEditingDomain(), (Object)combinedFragment, (Object)UMLPackage.eINSTANCE.getInteractionFragment_Covered(), coveredLifelinesToAdd), true);
        }
        if (!coveredLifelinesToRemove.isEmpty()) {
            CommandHelper.executeCommandWithoutHistory((EditingDomain)this.getEditingDomain(), RemoveCommand.create((EditingDomain)this.getEditingDomain(), (Object)combinedFragment, (Object)UMLPackage.eINSTANCE.getInteractionFragment_Covered(), coveredLifelinesToRemove), true);
        }
    }

    private void updateCoveredLifelines(LifelineEditPart lifelineEditPart, Rectangle newBound, List<Lifeline> coveredLifelinesToAdd, List<Lifeline> coveredLifelinesToRemove, EList<Lifeline> coveredLifelines) {
        PartDecomposition partDecomposition;
        Lifeline lifeline = (Lifeline)lifelineEditPart.resolveSemanticElement();
        LifelineDotLineCustomFigure dotLineFigure = lifelineEditPart.getPrimaryShape().getFigureLifelineDotLineFigure();
        Rectangle dotLineBounds = dotLineFigure.getBounds().getCopy();
        Rectangle centralLineBounds = new Rectangle(dotLineBounds.x() + dotLineBounds.width() / 2, dotLineBounds.y(), 1, dotLineBounds.height());
        dotLineFigure.translateToAbsolute((Translatable)centralLineBounds);
        if (newBound.intersects(centralLineBounds)) {
            if (!coveredLifelines.contains((Object)lifeline)) {
                coveredLifelinesToAdd.add(lifeline);
            }
        } else if (coveredLifelines.contains((Object)lifeline)) {
            coveredLifelinesToRemove.add(lifeline);
        }
        if ((partDecomposition = lifeline.getDecomposedAs()) != null) {
            List subLifelines = lifelineEditPart.getChildren();
            for (Object child : subLifelines) {
                if (!(child instanceof LifelineEditPart)) continue;
                this.updateCoveredLifelines((LifelineEditPart)((Object)child), newBound, coveredLifelinesToAdd, coveredLifelinesToRemove, coveredLifelines);
            }
        }
    }

    public EditPart getInteractionCompartment() {
        EditPart editPart = this.getParent();
        while (editPart != null && !(editPart instanceof InteractionInteractionCompartmentEditPart)) {
            editPart = editPart.getParent();
        }
        return editPart;
    }
}

