/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.controlmode.commands;

import java.util.Collections;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.services.controlmode.ControlModeRequest;
import org.eclipse.papyrus.infra.services.controlmode.commands.AbstractControlCommand;

public class BasicControlCommand
extends AbstractControlCommand {
    public BasicControlCommand(ControlModeRequest request) {
        super("Control command", Collections.singletonList(WorkspaceSynchronizer.getFile((Resource)request.getTargetObject().eResource())), request);
    }

    public boolean canExecute() {
        return super.canExecute() && this.getObjectToControl() != null && !this.getObjectToControl().eIsProxy();
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        ModelSet currentResourceSet = this.getRequest().getModelSet();
        Resource resource = currentResourceSet.getResource(this.getNewURI(), false);
        if (resource == null) {
            throw new ExecutionException("The resource was not created");
        }
        EObject objectToControl = this.getObjectToControl();
        if (objectToControl != null && objectToControl.eResource() != null) {
            objectToControl.eResource().setModified(true);
        }
        resource.getContents().add((Object)objectToControl);
        return CommandResult.newOKCommandResult((Object)resource);
    }

    public EObject getObjectToControl() {
        return this.getRequest().getTargetObject();
    }

    public URI getNewURI() {
        return this.getRequest().getNewURI();
    }
}

