/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.spi.label.swt;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecp.view.spi.label.model.VLabel;
import org.eclipse.emf.ecp.view.spi.label.model.VLabelStyle;
import org.eclipse.emf.ecp.view.spi.label.swt.Activator;
import org.eclipse.emf.ecp.view.spi.renderer.NoPropertyDescriptorFoundExeption;
import org.eclipse.emf.ecp.view.spi.renderer.NoRendererFoundException;
import org.eclipse.emf.ecp.view.spi.swt.AbstractSWTRenderer;
import org.eclipse.emf.ecp.view.spi.swt.layout.GridDescriptionFactory;
import org.eclipse.emf.ecp.view.spi.swt.layout.SWTGridCell;
import org.eclipse.emf.ecp.view.spi.swt.layout.SWTGridDescription;
import org.eclipse.emf.ecp.view.template.model.VTStyleProperty;
import org.eclipse.emf.ecp.view.template.style.fontProperties.model.VTFontPropertiesFactory;
import org.eclipse.emf.ecp.view.template.style.fontProperties.model.VTFontPropertiesStyleProperty;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;

public class LabelSWTRenderer
extends AbstractSWTRenderer<VLabel> {
    private SWTGridDescription rendererGridDescription;
    private Font font;
    private Color labelColor;
    private Map<VLabelStyle, VTFontPropertiesStyleProperty> defaultStyles;
    private Composite parent;

    protected void dispose() {
        this.rendererGridDescription = null;
        if (this.font != null) {
            this.font.dispose();
        }
        if (this.labelColor != null) {
            this.labelColor.dispose();
        }
        super.dispose();
    }

    public SWTGridDescription getGridDescription(SWTGridDescription gridDescription) {
        if (this.rendererGridDescription == null) {
            this.rendererGridDescription = GridDescriptionFactory.INSTANCE.createSimpleGrid(1, 1, (AbstractSWTRenderer)this);
            SWTGridCell gridCell = (SWTGridCell)this.rendererGridDescription.getGrid().get(0);
            gridCell.setVerticalGrab(false);
            gridCell.setVerticalFill(false);
            gridCell.setHorizontalFill(true);
            gridCell.setHorizontalGrab(true);
        }
        return this.rendererGridDescription;
    }

    protected Control renderControl(SWTGridCell cell, Composite parent) throws NoRendererFoundException, NoPropertyDescriptorFoundExeption {
        Label label;
        this.parent = parent;
        if (((VLabel)this.getVElement()).getStyle() == VLabelStyle.SEPARATOR) {
            label = new Label(parent, 258);
        } else {
            label = new Label(parent, 0);
            if (((VLabel)this.getVElement()).getName() != null) {
                label.setText(((VLabel)this.getVElement()).getName());
            }
            this.applyStyle(label);
        }
        return label;
    }

    protected void applyStyle(Label label) {
        VTFontPropertiesStyleProperty fontProperties = this.getFontProperty();
        if (fontProperties == null) {
            return;
        }
        FontData[] fD = label.getFont().getFontData();
        int style = 0;
        if (fontProperties.isBold()) {
            style |= 1;
        }
        if (fontProperties.isItalic()) {
            style |= 2;
        }
        fD[0].setStyle(style);
        fD[0].setHeight(fontProperties.getHeight());
        if (this.font != null) {
            this.font.dispose();
        }
        if (this.labelColor != null) {
            this.labelColor.dispose();
        }
        this.font = new Font((Device)label.getDisplay(), fontProperties.getFontName(), fontProperties.getHeight(), style);
        label.setFont(this.font);
        this.labelColor = this.getColor(fontProperties.getColorHEX());
        label.setForeground(this.labelColor);
    }

    private Color getColor(String colorHex) {
        String redString = colorHex.substring(0, 2);
        String greenString = colorHex.substring(2, 4);
        String blueString = colorHex.substring(4, 6);
        int red = Integer.parseInt(redString, 16);
        int green = Integer.parseInt(greenString, 16);
        int blue = Integer.parseInt(blueString, 16);
        return new Color((Device)Display.getDefault(), red, green, blue);
    }

    private VTFontPropertiesStyleProperty getFontProperty() {
        Set styleProperties = Activator.getDefault().getVTViewTemplateProvider().getStyleProperties(this.getVElement(), this.getViewModelContext());
        for (VTStyleProperty styleProperty : styleProperties) {
            if (!VTFontPropertiesStyleProperty.class.isInstance(styleProperty)) continue;
            VTFontPropertiesStyleProperty fontProperties = (VTFontPropertiesStyleProperty)VTFontPropertiesStyleProperty.class.cast(styleProperty);
            return fontProperties;
        }
        VTFontPropertiesStyleProperty fontProperties = this.getDefaultFontProperties().get(((VLabel)this.getVElement()).getStyle());
        return fontProperties;
    }

    private Map<VLabelStyle, VTFontPropertiesStyleProperty> getDefaultFontProperties() {
        if (this.defaultStyles == null) {
            this.defaultStyles = new HashMap<VLabelStyle, VTFontPropertiesStyleProperty>();
            String defaultFontName = this.parent.getDisplay().getSystemFont().getFontData()[0].getName();
            this.defaultStyles.put(VLabelStyle.H0, this.createStyle(false, false, "000000", defaultFontName, 10));
            this.defaultStyles.put(VLabelStyle.H1, this.createStyle(false, false, "000000", defaultFontName, 12));
            this.defaultStyles.put(VLabelStyle.H2, this.createStyle(false, false, "000000", defaultFontName, 14));
            this.defaultStyles.put(VLabelStyle.H3, this.createStyle(true, true, "000000", defaultFontName, 10));
            this.defaultStyles.put(VLabelStyle.H4, this.createStyle(true, false, "000000", defaultFontName, 10));
            this.defaultStyles.put(VLabelStyle.H5, this.createStyle(true, false, "000000", defaultFontName, 12));
            this.defaultStyles.put(VLabelStyle.H6, this.createStyle(true, false, "000000", defaultFontName, 14));
            this.defaultStyles.put(VLabelStyle.H7, this.createStyle(false, true, "000000", defaultFontName, 10));
            this.defaultStyles.put(VLabelStyle.H8, this.createStyle(false, true, "000000", defaultFontName, 12));
            this.defaultStyles.put(VLabelStyle.H9, this.createStyle(false, true, "000000", defaultFontName, 14));
        }
        return this.defaultStyles;
    }

    private VTFontPropertiesStyleProperty createStyle(boolean bold, boolean italic, String colorHex, String fontName, int fontHeight) {
        VTFontPropertiesStyleProperty fontProp = VTFontPropertiesFactory.eINSTANCE.createFontPropertiesStyleProperty();
        fontProp.setBold(bold);
        fontProp.setColorHEX(colorHex);
        fontProp.setFontName(fontName);
        fontProp.setHeight(fontHeight);
        fontProp.setItalic(italic);
        return fontProp;
    }
}

