/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.wizards.pages;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;

public class SessionResourceCreationWizardPage
extends WizardNewFileCreationPage {
    private final String fileExtension;
    private IFile selectedFile;

    public SessionResourceCreationWizardPage(String pageName, IStructuredSelection selection, String fileExtension) {
        super(pageName, selection);
        this.fileExtension = fileExtension;
        if (selection.getFirstElement() instanceof IFile) {
            this.selectedFile = (IFile)selection.getFirstElement();
        }
    }

    protected String getExtension() {
        return this.fileExtension;
    }

    public URI getURI() {
        return URI.createPlatformResourceURI((String)this.getFilePath().toString(), (boolean)true);
    }

    protected IPath getFilePath() {
        String fileName;
        IPath path = this.getContainerFullPath();
        if (path == null) {
            path = new Path("");
        }
        if ((fileName = this.getFileName()) != null) {
            path = path.append(fileName);
        }
        return path;
    }

    public String getDefaultFileName() {
        if (this.selectedFile != null && this.selectedFile.getFullPath().removeFileExtension().lastSegment() != null) {
            String name = this.selectedFile.getFullPath().removeFileExtension().lastSegment();
            return name;
        }
        return this.getNoselectionFileName();
    }

    protected String getNoselectionFileName() {
        return "newDiagrams";
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.setFileName(String.valueOf(this.getDefaultFileName()) + "." + this.getExtension());
        this.setPageComplete(this.validatePage());
    }

    protected boolean validatePage() {
        boolean result = true;
        if (!super.validatePage()) {
            return false;
        }
        String extension = this.getExtension();
        if (extension != null && !this.getFilePath().toString().endsWith("." + extension)) {
            this.setErrorMessage("The file extension is wrong. It should be " + extension);
            result = false;
        }
        return result;
    }
}

