/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.wizards.pages;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.ui.tools.api.views.ViewHelper;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.ContainerCheckedTreeViewer;

public class RepresentationsSelectionWizardPage
extends WizardPage {
    private static final String SELECT_REPRESENTATIONS_TO_EXPORT = "Select Representations to export";
    private static final String PAGE_TITLE = "Selection of representations to export";
    private static final int CODE_OK = 0;
    private static final int CODE_NO_SEL = 1;
    private static final int CODE_ERROR = 2;
    private Composite pageComposite;
    private CheckboxTreeViewer treeViewer;
    private final Session root;
    private final Collection<DRepresentation> preselection;

    public RepresentationsSelectionWizardPage(Session root, Collection<DRepresentation> representations) {
        super(PAGE_TITLE);
        this.setTitle(PAGE_TITLE);
        this.root = root;
        this.preselection = representations;
        if (this.preselection.size() > 0) {
            this.setPageComplete(true);
        }
        this.setMessage(SELECT_REPRESENTATIONS_TO_EXPORT, 1);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.pageComposite = new Composite(parent, 0);
        this.pageComposite.setLayout((Layout)new GridLayout());
        this.pageComposite.setLayoutData((Object)new GridData(4, 4, false, false));
        this.treeViewer = this.createTreeViewer(this.pageComposite);
        this.treeViewer.setInput((Object)this.root);
        this.treeViewer.expandAll();
        this.treeViewer.collapseAll();
        this.setControl((Control)this.pageComposite);
        for (DRepresentation preselected : this.preselection) {
            this.treeViewer.setChecked((Object)preselected, true);
        }
    }

    private CheckboxTreeViewer createTreeViewer(Composite parent) {
        DescDiagramSelectionTreeViewer viewer = new DescDiagramSelectionTreeViewer(parent, 2820);
        GridData gridData = new GridData(4, 4, true, true);
        viewer.getControl().setLayoutData((Object)gridData);
        viewer.getTree().setHeaderVisible(false);
        viewer.getTree().setLinesVisible(false);
        viewer.addCheckStateListener(new SiriusDiagramSelectionCheckStateListener());
        viewer.setContentProvider((IContentProvider)new SessionContentProvider(this.root));
        viewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider(ViewHelper.INSTANCE.createAdapterFactory()));
        return viewer;
    }

    private int checkSelection(Collection<?> selectedItems) {
        int result = 0;
        if (selectedItems.isEmpty()) {
            result = 1;
        } else {
            for (Object next : selectedItems) {
                if (next instanceof DRepresentation) continue;
                result = 2;
            }
        }
        return result;
    }

    public Collection<DRepresentation> getSelectedElements() {
        HashSet<DRepresentation> result = new HashSet<DRepresentation>();
        result.addAll(Arrays.asList(this.treeViewer.getCheckedElements()));
        result.removeAll(Arrays.asList(this.treeViewer.getGrayedElements()));
        return result;
    }

    private class DescDiagramSelectionTreeViewer
    extends ContainerCheckedTreeViewer {
        public DescDiagramSelectionTreeViewer(Composite parent) {
            super(parent);
        }

        public DescDiagramSelectionTreeViewer(Composite parent, int style) {
            super(parent, style);
        }

        public DescDiagramSelectionTreeViewer(Tree tree) {
            super(tree);
        }

        protected void doCheckStateChanged(Object element) {
            Widget item = this.findItem(element);
            if (item instanceof TreeItem) {
                TreeItem treeItem = (TreeItem)item;
                if (!(element instanceof DRepresentation)) {
                    boolean result = this.updateChildrenItems(treeItem, treeItem.getChecked());
                    if (result) {
                        treeItem.setGrayed(true);
                    } else {
                        treeItem.setGrayed(false);
                    }
                    treeItem.setChecked(result);
                }
                this.updateParentItems(treeItem);
            }
        }

        private void updateParentItems(TreeItem item) {
            if (item != null && !(item.getData() instanceof DRepresentation)) {
                Item[] children = this.getChildren((Widget)item);
                boolean containsChecked = false;
                Item[] itemArray = children;
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    Item element = itemArray[n2];
                    TreeItem curr = (TreeItem)element;
                    containsChecked = containsChecked || curr.getChecked();
                    ++n2;
                }
                item.setChecked(containsChecked);
                item.setGrayed(containsChecked);
            }
            if (item != null) {
                this.updateParentItems(item.getParentItem());
            }
        }

        private boolean updateChildrenItems(TreeItem parent, boolean state) {
            Item[] children;
            boolean result = false;
            Item[] itemArray = children = this.getChildren((Widget)parent);
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Item element = itemArray[n2];
                TreeItem curr = (TreeItem)element;
                if (curr.getData() instanceof DRepresentation && (curr.getChecked() != state || curr.getGrayed())) {
                    curr.setChecked(state);
                    curr.setGrayed(false);
                    result = result || state;
                    result = result || this.updateChildrenItems(curr, state);
                } else if (curr.getData() != null && (curr.getChecked() != state || curr.getGrayed())) {
                    boolean childrenResult = this.updateChildrenItems(curr, state);
                    if (childrenResult) {
                        curr.setChecked(true);
                        curr.setGrayed(true);
                    } else {
                        curr.setChecked(false);
                        curr.setGrayed(false);
                    }
                    result = result || childrenResult;
                }
                ++n2;
            }
            return result;
        }
    }

    private static final class SessionContentProvider
    implements ITreeContentProvider {
        private static Object[] empty = new Object[0];
        private final AdapterFactoryContentProvider semanticProvider;
        private final Session session;

        public SessionContentProvider(Session session) {
            this.session = session;
            ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
            this.semanticProvider = new AdapterFactoryContentProvider((AdapterFactory)adapterFactory);
        }

        public Object[] getChildren(Object parentElement) {
            Object[] children = empty;
            if (parentElement instanceof Session) {
                children = ((Session)parentElement).getSemanticResources().toArray();
            } else if (parentElement instanceof Resource) {
                children = ((Resource)parentElement).getContents().toArray();
            } else if (parentElement instanceof EObject && !(parentElement instanceof DRepresentation)) {
                EObject parent = (EObject)parentElement;
                Collection<DRepresentation> representations = this.findRepresentations(parent);
                Object[] semantic = this.semanticProvider.getChildren(parentElement);
                semantic = this.filtersSemanticFromAnotherResource(parent.eResource(), semantic);
                Object[] result = new Object[representations.size() + semantic.length];
                int i = 0;
                Iterator<DRepresentation> iterRepresentation = representations.iterator();
                while (iterRepresentation.hasNext()) {
                    result[i++] = iterRepresentation.next();
                }
                System.arraycopy(semantic, 0, result, representations.size(), semantic.length);
                children = result;
            }
            return children;
        }

        private Object[] filtersSemanticFromAnotherResource(Resource resource, Object[] semantic) {
            Object object;
            ArrayList<Object> filtered = new ArrayList<Object>();
            Object[] objectArray = semantic;
            int n = semantic.length;
            int n2 = 0;
            while (n2 < n) {
                object = objectArray[n2];
                filtered.add(object);
                ++n2;
            }
            objectArray = semantic;
            n = semantic.length;
            n2 = 0;
            while (n2 < n) {
                object = objectArray[n2];
                if (object instanceof EObject && ((EObject)object).eResource() != null && resource != ((EObject)object).eResource() && this.session.getSemanticResources().contains(((EObject)object).eResource())) {
                    filtered.remove(object);
                }
                ++n2;
            }
            return filtered.toArray();
        }

        public Object getParent(Object element) {
            if (element instanceof EObject) {
                EObject current = (EObject)element;
                EObject parent = current instanceof DRepresentation ? ((DSemanticDecorator)current).getTarget() : current.eContainer();
                return parent;
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
            this.semanticProvider.dispose();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        private Collection<DRepresentation> findRepresentations(EObject semanticElement) {
            if (semanticElement == null) {
                return Collections.emptySet();
            }
            return DialectManager.INSTANCE.getRepresentations(semanticElement, this.session);
        }
    }

    private class SiriusDiagramSelectionCheckStateListener
    implements ICheckStateListener {
        private SiriusDiagramSelectionCheckStateListener() {
        }

        public void checkStateChanged(CheckStateChangedEvent event) {
            int result = RepresentationsSelectionWizardPage.this.checkSelection(RepresentationsSelectionWizardPage.this.getSelectedElements());
            switch (result) {
                case 0: 
                case 1: {
                    RepresentationsSelectionWizardPage.this.setMessage(RepresentationsSelectionWizardPage.SELECT_REPRESENTATIONS_TO_EXPORT, 1);
                    RepresentationsSelectionWizardPage.this.setPageComplete(true);
                    break;
                }
                case 2: {
                    break;
                }
                default: {
                    RepresentationsSelectionWizardPage.this.setMessage("Unknown code result", 3);
                    RepresentationsSelectionWizardPage.this.setPageComplete(false);
                }
            }
        }
    }
}

