/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.views.common.navigator;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.ui.tools.internal.actions.session.OpenRepresentationsAction;
import org.eclipse.sirius.viewpoint.DRepresentation;

public class OpenRepresentationListener
implements IDoubleClickListener {
    public void doubleClick(DoubleClickEvent event) {
        List selection;
        Iterable<DRepresentation> representationToOpen;
        if (event != null && event.getSelection() instanceof IStructuredSelection && !Iterables.isEmpty(representationToOpen = this.getRepresentationsToOpen(selection = ((IStructuredSelection)event.getSelection()).toList()))) {
            new OpenRepresentationsAction(Sets.newLinkedHashSet(representationToOpen)).run();
        }
    }

    private Iterable<DRepresentation> getRepresentationsToOpen(List<?> selection) {
        LinkedHashSet representations = Sets.newLinkedHashSet();
        for (Object obj : selection) {
            if (obj instanceof DRepresentation) {
                representations.add((DRepresentation)obj);
                continue;
            }
            DRepresentation adapted = this.adaptToDRepresentation(obj);
            if (adapted == null) continue;
            representations.add(adapted);
        }
        return representations;
    }

    private DRepresentation adaptToDRepresentation(Object input) {
        Object adapter;
        if (input instanceof IAdaptable && (adapter = ((IAdaptable)input).getAdapter(EObject.class)) instanceof DRepresentation) {
            return (DRepresentation)adapter;
        }
        return null;
    }
}

