/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.views.common.item;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.ui.tools.api.views.common.item.RepresentationDescriptionItem;
import org.eclipse.sirius.ui.tools.internal.views.common.item.RepresentationItemImpl;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;

public class RepresentationDescriptionItemImpl
implements RepresentationDescriptionItem,
Comparable<RepresentationDescriptionItemImpl>,
IAdaptable {
    private final Session session;
    private final RepresentationDescription representationDescription;
    private Resource resource;
    private boolean filterForResource;
    private final Object parent;

    public RepresentationDescriptionItemImpl(Session session, RepresentationDescription representationDescription, Object parent) {
        this.session = session;
        this.representationDescription = representationDescription;
        this.parent = parent;
    }

    public RepresentationDescriptionItemImpl(Session session, RepresentationDescription representationDescription, Resource resource, Object parent) {
        this(session, representationDescription, parent);
        this.resource = resource;
        this.filterForResource = true;
    }

    @Override
    public Object getWrappedObject() {
        return this.representationDescription;
    }

    @Override
    public int compareTo(RepresentationDescriptionItemImpl o) {
        if (this.representationDescription.getName() != null) {
            return this.representationDescription.getName().compareTo(o.representationDescription.getName());
        }
        return 0;
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (this == obj) {
            result = true;
        } else if (obj instanceof RepresentationDescriptionItemImpl) {
            RepresentationDescriptionItemImpl rdiObj = (RepresentationDescriptionItemImpl)obj;
            result = rdiObj.compareTo(this) == 0 && rdiObj.parent.equals(this.parent);
        }
        return result;
    }

    public int hashCode() {
        return this.representationDescription.getName().hashCode() + this.parent.hashCode();
    }

    public Object getAdapter(Class adapter) {
        if (adapter == EObject.class) {
            return this.representationDescription;
        }
        return null;
    }

    @Override
    public Option<Session> getSession() {
        return Options.newSome((Object)this.session);
    }

    public Collection<?> getChildren() {
        ArrayList representationsCandidates = Lists.newArrayList((Iterable)DialectManager.INSTANCE.getRepresentations(this.representationDescription, this.session));
        ArrayList representations = Lists.newArrayList();
        if (this.filterForResource) {
            for (DRepresentation representation : representationsCandidates) {
                if (representation.eResource() == null || !representation.eResource().equals(this.resource)) continue;
                representations.add(new RepresentationItemImpl(representation, this));
            }
        } else {
            for (DRepresentation representation : representationsCandidates) {
                representations.add(new RepresentationItemImpl(representation, this));
            }
        }
        Collections.sort(representations, Ordering.natural().onResultOf((Function)new Function<RepresentationItemImpl, String>(){

            public String apply(RepresentationItemImpl from) {
                return from.getRepresentation().getName();
            }
        }));
        return representations;
    }

    public boolean isFilterForResource() {
        return this.filterForResource;
    }

    public void setFilterForResource(boolean filterForResource) {
        this.filterForResource = filterForResource;
    }

    public Object getParent() {
        return this.parent;
    }
}

